require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&AR_ISR_S2_S)) {
    sub AR_ISR_S2_S () {	0xd0;}
}
unless(defined(&AR_ISR_S3_S)) {
    sub AR_ISR_S3_S () {	0xd4;}
}
unless(defined(&AR_ISR_S4_S)) {
    sub AR_ISR_S4_S () {	0xd8;}
}
unless(defined(&AR_ISR_S5_S)) {
    sub AR_ISR_S5_S () {	0xdc;}
}
unless(defined(&AR_GPIO_IN_OUT)) {
    sub AR_GPIO_IN_OUT () {	0x4048;}
}
unless(defined(&AR_GPIO_OE_OUT)) {
    sub AR_GPIO_OE_OUT () {	0x4050;}
}
unless(defined(&AR_GPIO_INTR_POL)) {
    sub AR_GPIO_INTR_POL () {	0x4058;}
}
unless(defined(&AR_GPIO_INPUT_EN_VAL)) {
    sub AR_GPIO_INPUT_EN_VAL () {	0x405c;}
}
unless(defined(&AR_GPIO_INPUT_MUX1)) {
    sub AR_GPIO_INPUT_MUX1 () {	0x4060;}
}
unless(defined(&AR_GPIO_INPUT_MUX2)) {
    sub AR_GPIO_INPUT_MUX2 () {	0x4064;}
}
unless(defined(&AR_GPIO_OUTPUT_MUX)) {
    sub AR_GPIO_OUTPUT_MUX {
	my($i) = @_;
	eval q((0x4068 + ($i) * 4));
    }
}
unless(defined(&AR_INPUT_STATE)) {
    sub AR_INPUT_STATE () {	0x4074;}
}
unless(defined(&AR_EEPROM_STATUS_DATA)) {
    sub AR_EEPROM_STATUS_DATA () {	0x4084;}
}
unless(defined(&AR_OBS)) {
    sub AR_OBS () {	0x4088;}
}
unless(defined(&AR_GPIO_PDPU)) {
    sub AR_GPIO_PDPU () {	0x4090;}
}
unless(defined(&AR_PCIE_MSI)) {
    sub AR_PCIE_MSI () {	0x40a4;}
}
unless(defined(&AR_PHY_TIMING1)) {
    sub AR_PHY_TIMING1 () {	0x9800;}
}
unless(defined(&AR_PHY_TIMING2)) {
    sub AR_PHY_TIMING2 () {	0x9804;}
}
unless(defined(&AR_PHY_TIMING3)) {
    sub AR_PHY_TIMING3 () {	0x9808;}
}
unless(defined(&AR_PHY_TIMING4)) {
    sub AR_PHY_TIMING4 () {	0x980c;}
}
unless(defined(&AR_PHY_TIMING5)) {
    sub AR_PHY_TIMING5 () {	0x9810;}
}
unless(defined(&AR_PHY_TIMING6)) {
    sub AR_PHY_TIMING6 () {	0x9814;}
}
unless(defined(&AR_PHY_TIMING11)) {
    sub AR_PHY_TIMING11 () {	0x9818;}
}
unless(defined(&AR_PHY_SPUR_REG)) {
    sub AR_PHY_SPUR_REG () {	0x981c;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW)) {
    sub AR_PHY_FIND_SIG_LOW () {	0x9820;}
}
unless(defined(&AR_PHY_SFCORR)) {
    sub AR_PHY_SFCORR () {	0x9824;}
}
unless(defined(&AR_PHY_SFCORR_LOW)) {
    sub AR_PHY_SFCORR_LOW () {	0x9828;}
}
unless(defined(&AR_PHY_SFCORR_EXT)) {
    sub AR_PHY_SFCORR_EXT () {	0x982c;}
}
unless(defined(&AR_PHY_EXT_CCA)) {
    sub AR_PHY_EXT_CCA {
	my($i) = @_;
	eval q((0x9830 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_RADAR_0)) {
    sub AR_PHY_RADAR_0 () {	0x9834;}
}
unless(defined(&AR_PHY_RADAR_1)) {
    sub AR_PHY_RADAR_1 () {	0x9838;}
}
unless(defined(&AR_PHY_RADAR_EXT)) {
    sub AR_PHY_RADAR_EXT () {	0x983c;}
}
unless(defined(&AR_PHY_MULTICHAIN_CTRL)) {
    sub AR_PHY_MULTICHAIN_CTRL () {	0x9880;}
}
unless(defined(&AR_PHY_PERCHAIN_CSD)) {
    sub AR_PHY_PERCHAIN_CSD () {	0x9884;}
}
unless(defined(&AR_PHY_TX_CRC)) {
    sub AR_PHY_TX_CRC () {	0x98a0;}
}
unless(defined(&AR_PHY_TST_DAC_CONST)) {
    sub AR_PHY_TST_DAC_CONST () {	0x98a4;}
}
unless(defined(&AR_PHY_SPUR_REPORT_0)) {
    sub AR_PHY_SPUR_REPORT_0 () {	0x98a8;}
}
unless(defined(&AR_PHY_TX_IQCAL_CONTROL_3)) {
    sub AR_PHY_TX_IQCAL_CONTROL_3 () {	0x98b0;}
}
unless(defined(&AR_PHY_IQ_ADC_MEAS_0_B)) {
    sub AR_PHY_IQ_ADC_MEAS_0_B {
	my($i) = @_;
	eval q((0x98c0 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_IQ_ADC_MEAS_1_B)) {
    sub AR_PHY_IQ_ADC_MEAS_1_B {
	my($i) = @_;
	eval q((0x98c4 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_IQ_ADC_MEAS_2_B)) {
    sub AR_PHY_IQ_ADC_MEAS_2_B {
	my($i) = @_;
	eval q((0x98c8 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_IQ_ADC_MEAS_3_B)) {
    sub AR_PHY_IQ_ADC_MEAS_3_B {
	my($i) = @_;
	eval q((0x98cc + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TX_PHASE_RAMP_0)) {
    sub AR_PHY_TX_PHASE_RAMP_0 () {	0x98d0;}
}
unless(defined(&AR_PHY_ADC_DC_GAIN_CORR)) {
    sub AR_PHY_ADC_DC_GAIN_CORR {
	my($i) = @_;
	eval q((0x98d4 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_B)) {
    sub AR_PHY_RX_IQCAL_CORR_B {
	my($i) = @_;
	eval q((0x98dc + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_PAPRD_AM2AM)) {
    sub AR_PHY_PAPRD_AM2AM () {	0x98e4;}
}
unless(defined(&AR_PHY_PAPRD_AM2PM)) {
    sub AR_PHY_PAPRD_AM2PM () {	0x98e8;}
}
unless(defined(&AR_PHY_PAPRD_HT40)) {
    sub AR_PHY_PAPRD_HT40 () {	0x98ec;}
}
unless(defined(&AR_PHY_PAPRD_CTRL0_B)) {
    sub AR_PHY_PAPRD_CTRL0_B {
	my($i) = @_;
	eval q((0x98f0 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_PAPRD_CTRL1_B)) {
    sub AR_PHY_PAPRD_CTRL1_B {
	my($i) = @_;
	eval q((0x98f4 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_PA_GAIN123_B)) {
    sub AR_PHY_PA_GAIN123_B {
	my($i) = @_;
	eval q((0x98f8 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_PAPRD_PRE_POST_SCALE_B0)) {
    sub AR_PHY_PAPRD_PRE_POST_SCALE_B0 {
	my($i) = @_;
	eval q((0x9900 + ($i) * 4));
    }
}
unless(defined(&AR_PHY_PAPRD_MEM_TAB_B)) {
    sub AR_PHY_PAPRD_MEM_TAB_B {
	my($i, $j) = @_;
	eval q((0x9920 + ($i) * 0x1000 + ($j) * 4));
    }
}
unless(defined(&AR_PHY_CHAN_INFO_TAB)) {
    sub AR_PHY_CHAN_INFO_TAB {
	my($i, $j) = @_;
	eval q((0x9b00 + ($i) * 0x1000 + ($j) * 4));
    }
}
unless(defined(&AR_PHY_TIMING_3A)) {
    sub AR_PHY_TIMING_3A () {	0x9c00;}
}
unless(defined(&AR_PHY_LDPC_CNTL1)) {
    sub AR_PHY_LDPC_CNTL1 () {	0x9c04;}
}
unless(defined(&AR_PHY_LDPC_CNTL2)) {
    sub AR_PHY_LDPC_CNTL2 () {	0x9c08;}
}
unless(defined(&AR_PHY_PILOT_SPUR_MASK)) {
    sub AR_PHY_PILOT_SPUR_MASK () {	0x9c0c;}
}
unless(defined(&AR_PHY_CHAN_SPUR_MASK)) {
    sub AR_PHY_CHAN_SPUR_MASK () {	0x9c10;}
}
unless(defined(&AR_PHY_SGI_DELTA)) {
    sub AR_PHY_SGI_DELTA () {	0x9c14;}
}
unless(defined(&AR_PHY_ML_CNTL_1)) {
    sub AR_PHY_ML_CNTL_1 () {	0x9c18;}
}
unless(defined(&AR_PHY_ML_CNTL_2)) {
    sub AR_PHY_ML_CNTL_2 () {	0x9c1c;}
}
unless(defined(&AR_PHY_TST_ADC)) {
    sub AR_PHY_TST_ADC () {	0x9c20;}
}
unless(defined(&AR_PHY_SETTLING)) {
    sub AR_PHY_SETTLING () {	0x9e00;}
}
unless(defined(&AR_PHY_RXGAIN)) {
    sub AR_PHY_RXGAIN {
	my($i) = @_;
	eval q((0x9e04 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_GAINS_MINOFF0)) {
    sub AR_PHY_GAINS_MINOFF0 () {	0x9e08;}
}
unless(defined(&AR_PHY_DESIRED_SZ)) {
    sub AR_PHY_DESIRED_SZ () {	0x9e0c;}
}
unless(defined(&AR_PHY_FIND_SIG)) {
    sub AR_PHY_FIND_SIG () {	0x9e10;}
}
unless(defined(&AR_PHY_AGC)) {
    sub AR_PHY_AGC () {	0x9e14;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL)) {
    sub AR_PHY_EXT_ATTEN_CTL {
	my($i) = @_;
	eval q((0x9e18 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_CCA)) {
    sub AR_PHY_CCA {
	my($i) = @_;
	eval q((0x9e1c + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_CCA_CTRL)) {
    sub AR_PHY_CCA_CTRL {
	my($i) = @_;
	eval q((0x9e20 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_RESTART)) {
    sub AR_PHY_RESTART () {	0x9e24;}
}
unless(defined(&AR_PHY_MC_GAIN_CTRL)) {
    sub AR_PHY_MC_GAIN_CTRL () {	0x9e28;}
}
unless(defined(&AR_PHY_EXTCHN_PWRTHR1)) {
    sub AR_PHY_EXTCHN_PWRTHR1 () {	0x9e2c;}
}
unless(defined(&AR_PHY_EXT_CHN_WIN)) {
    sub AR_PHY_EXT_CHN_WIN () {	0x9e30;}
}
unless(defined(&AR_PHY_20_40_DET_THR)) {
    sub AR_PHY_20_40_DET_THR () {	0x9e34;}
}
unless(defined(&AR_PHY_RIFS_SRCH)) {
    sub AR_PHY_RIFS_SRCH () {	0x9e38;}
}
unless(defined(&AR_PHY_PEAK_DET_CTRL_1)) {
    sub AR_PHY_PEAK_DET_CTRL_1 () {	0x9e3c;}
}
unless(defined(&AR_PHY_PEAK_DET_CTRL_2)) {
    sub AR_PHY_PEAK_DET_CTRL_2 () {	0x9e40;}
}
unless(defined(&AR_PHY_RX_GAIN_BOUNDS_1)) {
    sub AR_PHY_RX_GAIN_BOUNDS_1 () {	0x9e44;}
}
unless(defined(&AR_PHY_RX_GAIN_BOUNDS_2)) {
    sub AR_PHY_RX_GAIN_BOUNDS_2 () {	0x9e48;}
}
unless(defined(&AR_PHY_RSSI)) {
    sub AR_PHY_RSSI {
	my($i) = @_;
	eval q((0x9f80 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_SPUR_CCK_REP0)) {
    sub AR_PHY_SPUR_CCK_REP0 () {	0x9f84;}
}
unless(defined(&AR_PHY_CCK_DETECT)) {
    sub AR_PHY_CCK_DETECT () {	0x9fc0;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK)) {
    sub AR_PHY_DAG_CTRLCCK () {	0x9fc4;}
}
unless(defined(&AR_PHY_IQCORR_CTRL_CCK)) {
    sub AR_PHY_IQCORR_CTRL_CCK () {	0x9fc8;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT)) {
    sub AR_PHY_CCK_SPUR_MIT () {	0x9fcc;}
}
unless(defined(&AR_PHY_RX_OCGAIN)) {
    sub AR_PHY_RX_OCGAIN () {	0xa000;}
}
unless(defined(&AR_PHY_D2_CHIP_ID)) {
    sub AR_PHY_D2_CHIP_ID () {	0xa200;}
}
unless(defined(&AR_PHY_GEN_CTRL)) {
    sub AR_PHY_GEN_CTRL () {	0xa204;}
}
unless(defined(&AR_PHY_MODE)) {
    sub AR_PHY_MODE () {	0xa208;}
}
unless(defined(&AR_PHY_ACTIVE)) {
    sub AR_PHY_ACTIVE () {	0xa20c;}
}
unless(defined(&AR_PHY_SPUR_MASK_A)) {
    sub AR_PHY_SPUR_MASK_A () {	0xa220;}
}
unless(defined(&AR_PHY_SPUR_MASK_B)) {
    sub AR_PHY_SPUR_MASK_B () {	0xa224;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN)) {
    sub AR_PHY_SPECTRAL_SCAN () {	0xa228;}
}
unless(defined(&AR_PHY_RADAR_BW_FILTER)) {
    sub AR_PHY_RADAR_BW_FILTER () {	0xa22c;}
}
unless(defined(&AR_PHY_SEARCH_START_DELAY)) {
    sub AR_PHY_SEARCH_START_DELAY () {	0xa230;}
}
unless(defined(&AR_PHY_MAX_RX_LEN)) {
    sub AR_PHY_MAX_RX_LEN () {	0xa234;}
}
unless(defined(&AR_PHY_FRAME_CTL)) {
    sub AR_PHY_FRAME_CTL () {	0xa238;}
}
unless(defined(&AR_PHY_RFBUS_REQ)) {
    sub AR_PHY_RFBUS_REQ () {	0xa23c;}
}
unless(defined(&AR_PHY_RFBUS_GRANT)) {
    sub AR_PHY_RFBUS_GRANT () {	0xa240;}
}
unless(defined(&AR_PHY_RIFS)) {
    sub AR_PHY_RIFS () {	0xa244;}
}
unless(defined(&AR_PHY_RX_CLR_DELAY)) {
    sub AR_PHY_RX_CLR_DELAY () {	0xa250;}
}
unless(defined(&AR_PHY_RX_DELAY)) {
    sub AR_PHY_RX_DELAY () {	0xa254;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL)) {
    sub AR_PHY_XPA_TIMING_CTL () {	0xa264;}
}
unless(defined(&AR_PHY_MISC_PA_CTL)) {
    sub AR_PHY_MISC_PA_CTL () {	0xa280;}
}
unless(defined(&AR_PHY_SWITCH_CHAIN)) {
    sub AR_PHY_SWITCH_CHAIN {
	my($i) = @_;
	eval q((0xa284 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_SWITCH_COM)) {
    sub AR_PHY_SWITCH_COM () {	0xa288;}
}
unless(defined(&AR_PHY_SWITCH_COM_2)) {
    sub AR_PHY_SWITCH_COM_2 () {	0xa28c;}
}
unless(defined(&AR_PHY_RX_CHAINMASK)) {
    sub AR_PHY_RX_CHAINMASK () {	0xa2a0;}
}
unless(defined(&AR_PHY_CAL_CHAINMASK)) {
    sub AR_PHY_CAL_CHAINMASK () {	0xa2c0;}
}
unless(defined(&AR_PHY_AGC_CONTROL)) {
    sub AR_PHY_AGC_CONTROL () {	0xa2c4;}
}
unless(defined(&AR_PHY_CALMODE)) {
    sub AR_PHY_CALMODE () {	0xa2c8;}
}
unless(defined(&AR_PHY_FCAL_1)) {
    sub AR_PHY_FCAL_1 () {	0xa2cc;}
}
unless(defined(&AR_PHY_FCAL_2_0)) {
    sub AR_PHY_FCAL_2_0 () {	0xa2d0;}
}
unless(defined(&AR_PHY_DFT_TONE_CTL_0)) {
    sub AR_PHY_DFT_TONE_CTL_0 () {	0xa2d4;}
}
unless(defined(&AR_PHY_CL_CAL_CTL)) {
    sub AR_PHY_CL_CAL_CTL () {	0xa2d8;}
}
unless(defined(&AR_PHY_CL_TAB_0)) {
    sub AR_PHY_CL_TAB_0 () {	0xa300;}
}
unless(defined(&AR_PHY_SYNTH_CONTROL)) {
    sub AR_PHY_SYNTH_CONTROL () {	0xa340;}
}
unless(defined(&AR_PHY_ADDAC_CLK_SEL)) {
    sub AR_PHY_ADDAC_CLK_SEL () {	0xa344;}
}
unless(defined(&AR_PHY_PLL_CTL)) {
    sub AR_PHY_PLL_CTL () {	0xa348;}
}
unless(defined(&AR_PHY_ANALOG_SWAP)) {
    sub AR_PHY_ANALOG_SWAP () {	0xa34c;}
}
unless(defined(&AR_PHY_ADDAC_PARA_CTL)) {
    sub AR_PHY_ADDAC_PARA_CTL () {	0xa350;}
}
unless(defined(&AR_PHY_XPA_CFG)) {
    sub AR_PHY_XPA_CFG () {	0xa358;}
}
unless(defined(&AR_PHY_TEST)) {
    sub AR_PHY_TEST () {	0xa360;}
}
unless(defined(&AR_PHY_TEST_CTL_STATUS)) {
    sub AR_PHY_TEST_CTL_STATUS () {	0xa364;}
}
unless(defined(&AR_PHY_TSTDAC)) {
    sub AR_PHY_TSTDAC () {	0xa368;}
}
unless(defined(&AR_PHY_CHAN_STATUS)) {
    sub AR_PHY_CHAN_STATUS () {	0xa36c;}
}
unless(defined(&AR_PHY_CHAN_INFO_MEMORY)) {
    sub AR_PHY_CHAN_INFO_MEMORY () {	0xa370;}
}
unless(defined(&AR_PHY_CHNINFO_NOISEPWR)) {
    sub AR_PHY_CHNINFO_NOISEPWR () {	0xa374;}
}
unless(defined(&AR_PHY_CHNINFO_GAINDIFF)) {
    sub AR_PHY_CHNINFO_GAINDIFF () {	0xa378;}
}
unless(defined(&AR_PHY_CHNINFO_FINETIM)) {
    sub AR_PHY_CHNINFO_FINETIM () {	0xa37c;}
}
unless(defined(&AR_PHY_CHAN_INFO_GAIN_0)) {
    sub AR_PHY_CHAN_INFO_GAIN_0 () {	0xa380;}
}
unless(defined(&AR_PHY_SCRAMBLER_SEED)) {
    sub AR_PHY_SCRAMBLER_SEED () {	0xa390;}
}
unless(defined(&AR_PHY_CCK_TX_CTRL)) {
    sub AR_PHY_CCK_TX_CTRL () {	0xa394;}
}
unless(defined(&AR_PHY_HEAVYCLIP_CTL)) {
    sub AR_PHY_HEAVYCLIP_CTL () {	0xa3a4;}
}
unless(defined(&AR_PHY_HEAVYCLIP_20)) {
    sub AR_PHY_HEAVYCLIP_20 () {	0xa3a8;}
}
unless(defined(&AR_PHY_HEAVYCLIP_40)) {
    sub AR_PHY_HEAVYCLIP_40 () {	0xa3ac;}
}
unless(defined(&AR_PHY_ILLEGAL_TXRATE)) {
    sub AR_PHY_ILLEGAL_TXRATE () {	0xa3b0;}
}
unless(defined(&AR_PHY_PWRTX_RATE1)) {
    sub AR_PHY_PWRTX_RATE1 () {	0xa3c0;}
}
unless(defined(&AR_PHY_PWRTX_RATE2)) {
    sub AR_PHY_PWRTX_RATE2 () {	0xa3c4;}
}
unless(defined(&AR_PHY_PWRTX_RATE3)) {
    sub AR_PHY_PWRTX_RATE3 () {	0xa3c8;}
}
unless(defined(&AR_PHY_PWRTX_RATE4)) {
    sub AR_PHY_PWRTX_RATE4 () {	0xa3cc;}
}
unless(defined(&AR_PHY_PWRTX_RATE5)) {
    sub AR_PHY_PWRTX_RATE5 () {	0xa3d0;}
}
unless(defined(&AR_PHY_PWRTX_RATE6)) {
    sub AR_PHY_PWRTX_RATE6 () {	0xa3d4;}
}
unless(defined(&AR_PHY_PWRTX_RATE7)) {
    sub AR_PHY_PWRTX_RATE7 () {	0xa3d8;}
}
unless(defined(&AR_PHY_PWRTX_RATE8)) {
    sub AR_PHY_PWRTX_RATE8 () {	0xa3dc;}
}
unless(defined(&AR_PHY_PWRTX_RATE10)) {
    sub AR_PHY_PWRTX_RATE10 () {	0xa3e4;}
}
unless(defined(&AR_PHY_PWRTX_RATE11)) {
    sub AR_PHY_PWRTX_RATE11 () {	0xa3e8;}
}
unless(defined(&AR_PHY_PWRTX_RATE12)) {
    sub AR_PHY_PWRTX_RATE12 () {	0xa3ec;}
}
unless(defined(&AR_PHY_PWRTX_MAX)) {
    sub AR_PHY_PWRTX_MAX () {	0xa3f0;}
}
unless(defined(&AR_PHY_POWER_TX_SUB)) {
    sub AR_PHY_POWER_TX_SUB () {	0xa3f4;}
}
unless(defined(&AR_PHY_TPC_1)) {
    sub AR_PHY_TPC_1 () {	0xa3f8;}
}
unless(defined(&AR_PHY_TPC_4_B)) {
    sub AR_PHY_TPC_4_B {
	my($i) = @_;
	eval q((0xa404 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TPC_5_B)) {
    sub AR_PHY_TPC_5_B {
	my($i) = @_;
	eval q((0xa408 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TPC_6_B)) {
    sub AR_PHY_TPC_6_B {
	my($i) = @_;
	eval q((0xa40c + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TPC_11_B)) {
    sub AR_PHY_TPC_11_B {
	my($i) = @_;
	eval q((0xa420 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TPC_12)) {
    sub AR_PHY_TPC_12 () {	0xa424;}
}
unless(defined(&AR_PHY_TPC_18)) {
    sub AR_PHY_TPC_18 () {	0xa43c;}
}
unless(defined(&AR_PHY_TPC_19)) {
    sub AR_PHY_TPC_19 () {	0xa440;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_1)) {
    sub AR_PHY_BB_THERM_ADC_1 () {	0xa448;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_4)) {
    sub AR_PHY_BB_THERM_ADC_4 () {	0xa454;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN)) {
    sub AR_PHY_TX_FORCED_GAIN () {	0xa458;}
}
unless(defined(&AR_PHY_PDADC_TAB)) {
    sub AR_PHY_PDADC_TAB {
	my($i) = @_;
	eval q((0xa480 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TXGAIN_TABLE)) {
    sub AR_PHY_TXGAIN_TABLE {
	my($i) = @_;
	eval q((0xa500 + ($i) * 4));
    }
}
unless(defined(&AR_PHY_TX_IQCAL_CONTROL_1)) {
    sub AR_PHY_TX_IQCAL_CONTROL_1 () {	0xa648;}
}
unless(defined(&AR_PHY_TX_IQCAL_START)) {
    sub AR_PHY_TX_IQCAL_START () {	0xa640;}
}
unless(defined(&AR_PHY_TX_IQCAL_CORR_COEFF_01_B)) {
    sub AR_PHY_TX_IQCAL_CORR_COEFF_01_B {
	my($i) = @_;
	eval q((0xa650 + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_TX_IQCAL_STATUS_B)) {
    sub AR_PHY_TX_IQCAL_STATUS_B {
	my($i) = @_;
	eval q((0xa68c + ($i) * 0x1000));
    }
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1 () {	0xa690;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL2)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL2 () {	0xa694;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3 () {	0xa698;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4 () {	0xa69c;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1 () {	0xa6a0;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2 () {	0xa6a4;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT3)) {
    sub AR_PHY_PAPRD_TRAINER_STAT3 () {	0xa6a8;}
}
unless(defined(&AR_PHY_PANIC_WD_STATUS)) {
    sub AR_PHY_PANIC_WD_STATUS () {	0xa7c0;}
}
unless(defined(&AR_PHY_PANIC_WD_CTL_1)) {
    sub AR_PHY_PANIC_WD_CTL_1 () {	0xa7c4;}
}
unless(defined(&AR_PHY_PANIC_WD_CTL_2)) {
    sub AR_PHY_PANIC_WD_CTL_2 () {	0xa7c8;}
}
unless(defined(&AR_PHY_BT_CTL)) {
    sub AR_PHY_BT_CTL () {	0xa7cc;}
}
unless(defined(&AR_PHY_ONLY_WARMRESET)) {
    sub AR_PHY_ONLY_WARMRESET () {	0xa7d0;}
}
unless(defined(&AR_PHY_ONLY_CTL)) {
    sub AR_PHY_ONLY_CTL () {	0xa7d4;}
}
unless(defined(&AR_PHY_ECO_CTRL)) {
    sub AR_PHY_ECO_CTRL () {	0xa7dc;}
}
unless(defined(&AR_IS_ANALOG_REG)) {
    sub AR_IS_ANALOG_REG {
	my($reg) = @_;
	eval q((($reg) >= 0x16000  && ($reg) <= 0x17000));
    }
}
unless(defined(&AR_PHY_65NM_CH0_SYNTH4)) {
    sub AR_PHY_65NM_CH0_SYNTH4 () {	0x1608c;}
}
unless(defined(&AR_PHY_65NM_CH0_SYNTH7)) {
    sub AR_PHY_65NM_CH0_SYNTH7 () {	0x16098;}
}
unless(defined(&AR_PHY_65NM_CH0_BIAS1)) {
    sub AR_PHY_65NM_CH0_BIAS1 () {	0x160c0;}
}
unless(defined(&AR_PHY_65NM_CH0_BIAS2)) {
    sub AR_PHY_65NM_CH0_BIAS2 () {	0x160c4;}
}
unless(defined(&AR_PHY_65NM_CH0_BIAS4)) {
    sub AR_PHY_65NM_CH0_BIAS4 () {	0x160cc;}
}
unless(defined(&AR_PHY_65NM_CH0_RXTX1)) {
    sub AR_PHY_65NM_CH0_RXTX1 () {	0x16100;}
}
unless(defined(&AR_PHY_65NM_CH0_RXTX2)) {
    sub AR_PHY_65NM_CH0_RXTX2 () {	0x16104;}
}
unless(defined(&AR_PHY_65NM_CH0_RXTX4)) {
    sub AR_PHY_65NM_CH0_RXTX4 () {	0x1610c;}
}
unless(defined(&AR_PHY_65NM_CH0_TOP)) {
    sub AR_PHY_65NM_CH0_TOP () {	0x16288;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM)) {
    sub AR_PHY_65NM_CH0_THERM () {	0x16290;}
}
unless(defined(&AR_PHY_65NM_CH1_RXTX1)) {
    sub AR_PHY_65NM_CH1_RXTX1 () {	0x16500;}
}
unless(defined(&AR_PHY_65NM_CH1_RXTX2)) {
    sub AR_PHY_65NM_CH1_RXTX2 () {	0x16504;}
}
unless(defined(&AR_PHY_65NM_CH2_RXTX1)) {
    sub AR_PHY_65NM_CH2_RXTX1 () {	0x16900;}
}
unless(defined(&AR_PHY_65NM_CH2_RXTX2)) {
    sub AR_PHY_65NM_CH2_RXTX2 () {	0x16904;}
}
unless(defined(&AR_PHY_TIMING2_FORCE_PPM_VAL_M)) {
    sub AR_PHY_TIMING2_FORCE_PPM_VAL_M () {	0xfff;}
}
unless(defined(&AR_PHY_TIMING2_FORCE_PPM_VAL_S)) {
    sub AR_PHY_TIMING2_FORCE_PPM_VAL_S () {	0;}
}
unless(defined(&AR_PHY_TIMING2_USE_FORCE_PPM)) {
    sub AR_PHY_TIMING2_USE_FORCE_PPM () {	0x1000;}
}
unless(defined(&AR_PHY_TIMING3_DSC_EXP_M)) {
    sub AR_PHY_TIMING3_DSC_EXP_M () {	0x1e000;}
}
unless(defined(&AR_PHY_TIMING3_DSC_EXP_S)) {
    sub AR_PHY_TIMING3_DSC_EXP_S () {	13;}
}
unless(defined(&AR_PHY_TIMING3_DSC_MAN_M)) {
    sub AR_PHY_TIMING3_DSC_MAN_M () {	0xfffe0000;}
}
unless(defined(&AR_PHY_TIMING3_DSC_MAN_S)) {
    sub AR_PHY_TIMING3_DSC_MAN_S () {	17;}
}
unless(defined(&AR_PHY_TIMING4_IQCAL_LOG_COUNT_MAX_M)) {
    sub AR_PHY_TIMING4_IQCAL_LOG_COUNT_MAX_M () {	0xf000;}
}
unless(defined(&AR_PHY_TIMING4_IQCAL_LOG_COUNT_MAX_S)) {
    sub AR_PHY_TIMING4_IQCAL_LOG_COUNT_MAX_S () {	12;}
}
unless(defined(&AR_PHY_TIMING4_DO_CAL)) {
    sub AR_PHY_TIMING4_DO_CAL () {	0x10000;}
}
unless(defined(&AR_PHY_TIMING4_ENABLE_PILOT_MASK)) {
    sub AR_PHY_TIMING4_ENABLE_PILOT_MASK () {	0x10000000;}
}
unless(defined(&AR_PHY_TIMING4_ENABLE_CHAN_MASK)) {
    sub AR_PHY_TIMING4_ENABLE_CHAN_MASK () {	0x20000000;}
}
unless(defined(&AR_PHY_TIMING4_ENABLE_SPUR_FILTER)) {
    sub AR_PHY_TIMING4_ENABLE_SPUR_FILTER () {	0x40000000;}
}
unless(defined(&AR_PHY_TIMING4_ENABLE_SPUR_RSSI)) {
    sub AR_PHY_TIMING4_ENABLE_SPUR_RSSI () {	0x80000000;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1_ENABLE)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1_ENABLE () {	0x1;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1_M)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1_M () {	0xfe;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1_S)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1_S () {	1;}
}
unless(defined(&AR_PHY_TIMING5_RSSI_THR1A_ENA)) {
    sub AR_PHY_TIMING5_RSSI_THR1A_ENA () {	0x8000;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1A_M)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1A_M () {	0x7f0000;}
}
unless(defined(&AR_PHY_TIMING5_CYCPWR_THR1A_S)) {
    sub AR_PHY_TIMING5_CYCPWR_THR1A_S () {	16;}
}
unless(defined(&AR_PHY_TIMING5_RSSI_THR1A_M)) {
    sub AR_PHY_TIMING5_RSSI_THR1A_M () {	0x7f0000;}
}
unless(defined(&AR_PHY_TIMING5_RSSI_THR1A_S)) {
    sub AR_PHY_TIMING5_RSSI_THR1A_S () {	16;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_DELTA_PHASE_M)) {
    sub AR_PHY_TIMING11_SPUR_DELTA_PHASE_M () {	0xfffff;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_DELTA_PHASE_S)) {
    sub AR_PHY_TIMING11_SPUR_DELTA_PHASE_S () {	0;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_FREQ_SD_M)) {
    sub AR_PHY_TIMING11_SPUR_FREQ_SD_M () {	0x3ff00000;}
}
unless(defined(&AR_PHY_TIMING11_SPUR_FREQ_SD_S)) {
    sub AR_PHY_TIMING11_SPUR_FREQ_SD_S () {	20;}
}
unless(defined(&AR_PHY_TIMING11_USE_SPUR_FILTER_IN_AGC)) {
    sub AR_PHY_TIMING11_USE_SPUR_FILTER_IN_AGC () {	0x40000000;}
}
unless(defined(&AR_PHY_TIMING11_USE_SPUR_FILTER_IN_SELFCOR)) {
    sub AR_PHY_TIMING11_USE_SPUR_FILTER_IN_SELFCOR () {	0x80000000;}
}
unless(defined(&AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_M)) {
    sub AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_M () {	0xff;}
}
unless(defined(&AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_S)) {
    sub AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_S () {	0;}
}
unless(defined(&AR_PHY_SPUR_REG_EN_VIT_SPUR_RSSI)) {
    sub AR_PHY_SPUR_REG_EN_VIT_SPUR_RSSI () {	0x100;}
}
unless(defined(&AR_PHY_SPUR_REG_ENABLE_MASK_PPM)) {
    sub AR_PHY_SPUR_REG_ENABLE_MASK_PPM () {	0x20000;}
}
unless(defined(&AR_PHY_SPUR_REG_MASK_RATE_CNTL_M)) {
    sub AR_PHY_SPUR_REG_MASK_RATE_CNTL_M () {	0x3fc0000;}
}
unless(defined(&AR_PHY_SPUR_REG_MASK_RATE_CNTL_S)) {
    sub AR_PHY_SPUR_REG_MASK_RATE_CNTL_S () {	18;}
}
unless(defined(&AR_PHY_SPUR_REG_ENABLE_NF_RSSI_SPUR_MIT)) {
    sub AR_PHY_SPUR_REG_ENABLE_NF_RSSI_SPUR_MIT () {	0x4000000;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW_RELSTEP_M)) {
    sub AR_PHY_FIND_SIG_LOW_RELSTEP_M () {	0x1f;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW_RELSTEP_S)) {
    sub AR_PHY_FIND_SIG_LOW_RELSTEP_S () {	0;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW_FIRSTEP_LOW_M)) {
    sub AR_PHY_FIND_SIG_LOW_FIRSTEP_LOW_M () {	0xfc0;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW_FIRSTEP_LOW_S)) {
    sub AR_PHY_FIND_SIG_LOW_FIRSTEP_LOW_S () {	6;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW_FIRPWR_M)) {
    sub AR_PHY_FIND_SIG_LOW_FIRPWR_M () {	0x7f000;}
}
unless(defined(&AR_PHY_FIND_SIG_LOW_FIRPWR_S)) {
    sub AR_PHY_FIND_SIG_LOW_FIRPWR_S () {	12;}
}
unless(defined(&AR_PHY_SFCORR_M2COUNT_THR_M)) {
    sub AR_PHY_SFCORR_M2COUNT_THR_M () {	0x1f;}
}
unless(defined(&AR_PHY_SFCORR_M2COUNT_THR_S)) {
    sub AR_PHY_SFCORR_M2COUNT_THR_S () {	0;}
}
unless(defined(&AR_PHY_SFCORR_M1_THRESH_M)) {
    sub AR_PHY_SFCORR_M1_THRESH_M () {	0xfe0000;}
}
unless(defined(&AR_PHY_SFCORR_M1_THRESH_S)) {
    sub AR_PHY_SFCORR_M1_THRESH_S () {	17;}
}
unless(defined(&AR_PHY_SFCORR_M2_THRESH_M)) {
    sub AR_PHY_SFCORR_M2_THRESH_M () {	0x7f000000;}
}
unless(defined(&AR_PHY_SFCORR_M2_THRESH_S)) {
    sub AR_PHY_SFCORR_M2_THRESH_S () {	24;}
}
unless(defined(&AR_PHY_SFCORR_LOW_USE_SELF_CORR_LOW)) {
    sub AR_PHY_SFCORR_LOW_USE_SELF_CORR_LOW () {	0x1;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_M)) {
    sub AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_M () {	0x3f00;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S)) {
    sub AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S () {	8;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M1_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_LOW_M1_THRESH_LOW_M () {	0x1fc000;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M1_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_LOW_M1_THRESH_LOW_S () {	14;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_LOW_M2_THRESH_LOW_M () {	0xfe00000;}
}
unless(defined(&AR_PHY_SFCORR_LOW_M2_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_LOW_M2_THRESH_LOW_S () {	21;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_M)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_M () {	0x7f;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_S)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_S () {	0;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_M)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_M () {	0x3f80;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_S)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_S () {	7;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_LOW_M () {	0x1fc000;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M1_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_EXT_M1_THRESH_LOW_S () {	14;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_LOW_M)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_LOW_M () {	0xfe00000;}
}
unless(defined(&AR_PHY_SFCORR_EXT_M2_THRESH_LOW_S)) {
    sub AR_PHY_SFCORR_EXT_M2_THRESH_LOW_S () {	21;}
}
unless(defined(&AR_PHY_SFCORR_EXT_SPUR_SUBCHANNEL_SD)) {
    sub AR_PHY_SFCORR_EXT_SPUR_SUBCHANNEL_SD () {	0x10000000;}
}
unless(defined(&AR_PHY_RADAR_0_ENA)) {
    sub AR_PHY_RADAR_0_ENA () {	0x1;}
}
unless(defined(&AR_PHY_RADAR_0_INBAND_M)) {
    sub AR_PHY_RADAR_0_INBAND_M () {	0x3e;}
}
unless(defined(&AR_PHY_RADAR_0_INBAND_S)) {
    sub AR_PHY_RADAR_0_INBAND_S () {	1;}
}
unless(defined(&AR_PHY_RADAR_0_PRSSI_M)) {
    sub AR_PHY_RADAR_0_PRSSI_M () {	0xfc0;}
}
unless(defined(&AR_PHY_RADAR_0_PRSSI_S)) {
    sub AR_PHY_RADAR_0_PRSSI_S () {	6;}
}
unless(defined(&AR_PHY_RADAR_0_HEIGHT_M)) {
    sub AR_PHY_RADAR_0_HEIGHT_M () {	0x3f000;}
}
unless(defined(&AR_PHY_RADAR_0_HEIGHT_S)) {
    sub AR_PHY_RADAR_0_HEIGHT_S () {	12;}
}
unless(defined(&AR_PHY_RADAR_0_RRSSI_M)) {
    sub AR_PHY_RADAR_0_RRSSI_M () {	0xfc0000;}
}
unless(defined(&AR_PHY_RADAR_0_RRSSI_S)) {
    sub AR_PHY_RADAR_0_RRSSI_S () {	18;}
}
unless(defined(&AR_PHY_RADAR_0_FIRPWR_M)) {
    sub AR_PHY_RADAR_0_FIRPWR_M () {	0x7f000000;}
}
unless(defined(&AR_PHY_RADAR_0_FIRPWR_S)) {
    sub AR_PHY_RADAR_0_FIRPWR_S () {	24;}
}
unless(defined(&AR_PHY_RADAR_0_FFT_ENA)) {
    sub AR_PHY_RADAR_0_FFT_ENA () {	0x80000000;}
}
unless(defined(&AR_PHY_RADAR_1_MAXLEN_M)) {
    sub AR_PHY_RADAR_1_MAXLEN_M () {	0xff;}
}
unless(defined(&AR_PHY_RADAR_1_MAXLEN_S)) {
    sub AR_PHY_RADAR_1_MAXLEN_S () {	0;}
}
unless(defined(&AR_PHY_RADAR_1_RELSTEP_THRESH_M)) {
    sub AR_PHY_RADAR_1_RELSTEP_THRESH_M () {	0x1f00;}
}
unless(defined(&AR_PHY_RADAR_1_RELSTEP_THRESH_S)) {
    sub AR_PHY_RADAR_1_RELSTEP_THRESH_S () {	8;}
}
unless(defined(&AR_PHY_RADAR_1_RELSTEP_CHECK)) {
    sub AR_PHY_RADAR_1_RELSTEP_CHECK () {	0x2000;}
}
unless(defined(&AR_PHY_RADAR_1_MAX_RRSSI)) {
    sub AR_PHY_RADAR_1_MAX_RRSSI () {	0x4000;}
}
unless(defined(&AR_PHY_RADAR_1_BLOCK_CHECK)) {
    sub AR_PHY_RADAR_1_BLOCK_CHECK () {	0x8000;}
}
unless(defined(&AR_PHY_RADAR_1_RELPWR_THRESH_M)) {
    sub AR_PHY_RADAR_1_RELPWR_THRESH_M () {	0x3f0000;}
}
unless(defined(&AR_PHY_RADAR_1_RELPWR_THRESH_S)) {
    sub AR_PHY_RADAR_1_RELPWR_THRESH_S () {	16;}
}
unless(defined(&AR_PHY_RADAR_1_USE_FIR128)) {
    sub AR_PHY_RADAR_1_USE_FIR128 () {	0x400000;}
}
unless(defined(&AR_PHY_RADAR_1_RELPWR_ENA)) {
    sub AR_PHY_RADAR_1_RELPWR_ENA () {	0x800000;}
}
unless(defined(&AR_PHY_RADAR_EXT_ENA)) {
    sub AR_PHY_RADAR_EXT_ENA () {	0x4000;}
}
unless(defined(&AR_PHY_RADAR_DC_PWR_THRESH_M)) {
    sub AR_PHY_RADAR_DC_PWR_THRESH_M () {	0x7f8000;}
}
unless(defined(&AR_PHY_RADAR_DC_PWR_THRESH_S)) {
    sub AR_PHY_RADAR_DC_PWR_THRESH_S () {	15;}
}
unless(defined(&AR_PHY_RADAR_LB_DC_CAP_M)) {
    sub AR_PHY_RADAR_LB_DC_CAP_M () {	0x7f800000;}
}
unless(defined(&AR_PHY_RADAR_LB_DC_CAP_S)) {
    sub AR_PHY_RADAR_LB_DC_CAP_S () {	23;}
}
unless(defined(&AR_PHY_TX_IQCAL_CONTROL_3_IQCORR_EN)) {
    sub AR_PHY_TX_IQCAL_CONTROL_3_IQCORR_EN () {	0x80000000;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_IQCORR_Q_Q_COFF_M)) {
    sub AR_PHY_RX_IQCAL_CORR_IQCORR_Q_Q_COFF_M () {	0x7f;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_IQCORR_Q_Q_COFF_S)) {
    sub AR_PHY_RX_IQCAL_CORR_IQCORR_Q_Q_COFF_S () {	0;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_IQCORR_Q_I_COFF_M)) {
    sub AR_PHY_RX_IQCAL_CORR_IQCORR_Q_I_COFF_M () {	0x3f80;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_IQCORR_Q_I_COFF_S)) {
    sub AR_PHY_RX_IQCAL_CORR_IQCORR_Q_I_COFF_S () {	7;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_IQCORR_ENABLE)) {
    sub AR_PHY_RX_IQCAL_CORR_IQCORR_ENABLE () {	0x4000;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_Q_COFF_M)) {
    sub AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_Q_COFF_M () {	0x3f8000;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_Q_COFF_S)) {
    sub AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_Q_COFF_S () {	15;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_I_COFF_M)) {
    sub AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_I_COFF_M () {	0x1fc00000;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_I_COFF_S)) {
    sub AR_PHY_RX_IQCAL_CORR_LOOPBACK_IQCORR_Q_I_COFF_S () {	22;}
}
unless(defined(&AR_PHY_RX_IQCAL_CORR_B0_LOOPBACK_IQCORR_EN)) {
    sub AR_PHY_RX_IQCAL_CORR_B0_LOOPBACK_IQCORR_EN () {	0x20000000;}
}
unless(defined(&AR_PHY_PAPRD_AM2AM_MASK_M)) {
    sub AR_PHY_PAPRD_AM2AM_MASK_M () {	0x1ffffff;}
}
unless(defined(&AR_PHY_PAPRD_AM2AM_MASK_S)) {
    sub AR_PHY_PAPRD_AM2AM_MASK_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_AM2PM_MASK_M)) {
    sub AR_PHY_PAPRD_AM2PM_MASK_M () {	0x1ffffff;}
}
unless(defined(&AR_PHY_PAPRD_AM2PM_MASK_S)) {
    sub AR_PHY_PAPRD_AM2PM_MASK_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_HT40_MASK_M)) {
    sub AR_PHY_PAPRD_HT40_MASK_M () {	0x1ffffff;}
}
unless(defined(&AR_PHY_PAPRD_HT40_MASK_S)) {
    sub AR_PHY_PAPRD_HT40_MASK_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_CTRL0_PAPRD_ENABLE)) {
    sub AR_PHY_PAPRD_CTRL0_PAPRD_ENABLE () {	0x1;}
}
unless(defined(&AR_PHY_PAPRD_CTRL0_USE_SINGLE_TABLE)) {
    sub AR_PHY_PAPRD_CTRL0_USE_SINGLE_TABLE () {	0x2;}
}
unless(defined(&AR_PHY_PAPRD_CTRL0_PAPRD_MAG_THRSH_M)) {
    sub AR_PHY_PAPRD_CTRL0_PAPRD_MAG_THRSH_M () {	0xf8000000;}
}
unless(defined(&AR_PHY_PAPRD_CTRL0_PAPRD_MAG_THRSH_S)) {
    sub AR_PHY_PAPRD_CTRL0_PAPRD_MAG_THRSH_S () {	27;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_ADAPTIVE_SCALING_ENA)) {
    sub AR_PHY_PAPRD_CTRL1_ADAPTIVE_SCALING_ENA () {	0x1;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2AM_ENA)) {
    sub AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2AM_ENA () {	0x2;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2PM_ENA)) {
    sub AR_PHY_PAPRD_CTRL1_ADAPTIVE_AM2PM_ENA () {	0x4;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_POWER_AT_AM2AM_CAL_M)) {
    sub AR_PHY_PAPRD_CTRL1_POWER_AT_AM2AM_CAL_M () {	0x1f8;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_POWER_AT_AM2AM_CAL_S)) {
    sub AR_PHY_PAPRD_CTRL1_POWER_AT_AM2AM_CAL_S () {	3;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_PA_GAIN_SCALE_FACT_M)) {
    sub AR_PHY_PAPRD_CTRL1_PA_GAIN_SCALE_FACT_M () {	0x1fe00;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_PA_GAIN_SCALE_FACT_S)) {
    sub AR_PHY_PAPRD_CTRL1_PA_GAIN_SCALE_FACT_S () {	9;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_MAG_SCALE_FACT_M)) {
    sub AR_PHY_PAPRD_CTRL1_MAG_SCALE_FACT_M () {	0xffe0000;}
}
unless(defined(&AR_PHY_PAPRD_CTRL1_MAG_SCALE_FACT_S)) {
    sub AR_PHY_PAPRD_CTRL1_MAG_SCALE_FACT_S () {	17;}
}
unless(defined(&AR_PHY_PA_GAIN123_PA_GAIN1_M)) {
    sub AR_PHY_PA_GAIN123_PA_GAIN1_M () {	0x3ff;}
}
unless(defined(&AR_PHY_PA_GAIN123_PA_GAIN1_S)) {
    sub AR_PHY_PA_GAIN123_PA_GAIN1_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_PRE_POST_SCALING_M)) {
    sub AR_PHY_PAPRD_PRE_POST_SCALING_M () {	0x3ffff;}
}
unless(defined(&AR_PHY_PAPRD_PRE_POST_SCALING_S)) {
    sub AR_PHY_PAPRD_PRE_POST_SCALING_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_ANGLE_M)) {
    sub AR_PHY_PAPRD_ANGLE_M () {	0x7ff;}
}
unless(defined(&AR_PHY_PAPRD_ANGLE_S)) {
    sub AR_PHY_PAPRD_ANGLE_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_PA_IN_M)) {
    sub AR_PHY_PAPRD_PA_IN_M () {	0x3ff800;}
}
unless(defined(&AR_PHY_PAPRD_PA_IN_S)) {
    sub AR_PHY_PAPRD_PA_IN_S () {	11;}
}
unless(defined(&AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_A_M)) {
    sub AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_A_M () {	0x1f;}
}
unless(defined(&AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_A_S)) {
    sub AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_A_S () {	0;}
}
unless(defined(&AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_A_M)) {
    sub AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_A_M () {	0xfe0;}
}
unless(defined(&AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_A_S)) {
    sub AR_PHY_PILOT_SPUR_MASK_CF_PILOT_MASK_IDX_A_S () {	5;}
}
unless(defined(&AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_A_M)) {
    sub AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_A_M () {	0x1f;}
}
unless(defined(&AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_A_S)) {
    sub AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_A_S () {	0;}
}
unless(defined(&AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_A_M)) {
    sub AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_A_M () {	0xfe0;}
}
unless(defined(&AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_A_S)) {
    sub AR_PHY_CHAN_SPUR_MASK_CF_CHAN_MASK_IDX_A_S () {	5;}
}
unless(defined(&AR_PHY_SGI_DSC_EXP_M)) {
    sub AR_PHY_SGI_DSC_EXP_M () {	0xf;}
}
unless(defined(&AR_PHY_SGI_DSC_EXP_S)) {
    sub AR_PHY_SGI_DSC_EXP_S () {	0;}
}
unless(defined(&AR_PHY_SGI_DSC_MAN_M)) {
    sub AR_PHY_SGI_DSC_MAN_M () {	0x7fff0;}
}
unless(defined(&AR_PHY_SGI_DSC_MAN_S)) {
    sub AR_PHY_SGI_DSC_MAN_S () {	4;}
}
unless(defined(&AR_PHY_SETTLING_SWITCH_M)) {
    sub AR_PHY_SETTLING_SWITCH_M () {	0x3f80;}
}
unless(defined(&AR_PHY_SETTLING_SWITCH_S)) {
    sub AR_PHY_SETTLING_SWITCH_S () {	7;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_ATTEN_M)) {
    sub AR_PHY_RXGAIN_TXRX_ATTEN_M () {	0x3f000;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_ATTEN_S)) {
    sub AR_PHY_RXGAIN_TXRX_ATTEN_S () {	12;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_RF_MAX_M)) {
    sub AR_PHY_RXGAIN_TXRX_RF_MAX_M () {	0x7c0000;}
}
unless(defined(&AR_PHY_RXGAIN_TXRX_RF_MAX_S)) {
    sub AR_PHY_RXGAIN_TXRX_RF_MAX_S () {	18;}
}
unless(defined(&AR_PHY_DESIRED_SZ_ADC_M)) {
    sub AR_PHY_DESIRED_SZ_ADC_M () {	0xff;}
}
unless(defined(&AR_PHY_DESIRED_SZ_ADC_S)) {
    sub AR_PHY_DESIRED_SZ_ADC_S () {	0;}
}
unless(defined(&AR_PHY_DESIRED_SZ_PGA_M)) {
    sub AR_PHY_DESIRED_SZ_PGA_M () {	0xff00;}
}
unless(defined(&AR_PHY_DESIRED_SZ_PGA_S)) {
    sub AR_PHY_DESIRED_SZ_PGA_S () {	8;}
}
unless(defined(&AR_PHY_DESIRED_SZ_TOT_DES_M)) {
    sub AR_PHY_DESIRED_SZ_TOT_DES_M () {	0xff00000;}
}
unless(defined(&AR_PHY_DESIRED_SZ_TOT_DES_S)) {
    sub AR_PHY_DESIRED_SZ_TOT_DES_S () {	20;}
}
unless(defined(&AR_PHY_FIND_SIG_RELSTEP_M)) {
    sub AR_PHY_FIND_SIG_RELSTEP_M () {	0x1f;}
}
unless(defined(&AR_PHY_FIND_SIG_RELSTEP_S)) {
    sub AR_PHY_FIND_SIG_RELSTEP_S () {	0;}
}
unless(defined(&AR_PHY_FIND_SIG_RELPWR_M)) {
    sub AR_PHY_FIND_SIG_RELPWR_M () {	0x7c0;}
}
unless(defined(&AR_PHY_FIND_SIG_RELPWR_S)) {
    sub AR_PHY_FIND_SIG_RELPWR_S () {	6;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRSTEP_M)) {
    sub AR_PHY_FIND_SIG_FIRSTEP_M () {	0x3f000;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRSTEP_S)) {
    sub AR_PHY_FIND_SIG_FIRSTEP_S () {	12;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRPWR_M)) {
    sub AR_PHY_FIND_SIG_FIRPWR_M () {	0x3fc0000;}
}
unless(defined(&AR_PHY_FIND_SIG_FIRPWR_S)) {
    sub AR_PHY_FIND_SIG_FIRPWR_S () {	18;}
}
unless(defined(&AR_PHY_AGC_COARSE_PWR_CONST_M)) {
    sub AR_PHY_AGC_COARSE_PWR_CONST_M () {	0x7f;}
}
unless(defined(&AR_PHY_AGC_COARSE_PWR_CONST_S)) {
    sub AR_PHY_AGC_COARSE_PWR_CONST_S () {	0;}
}
unless(defined(&AR_PHY_AGC_COARSE_LOW_M)) {
    sub AR_PHY_AGC_COARSE_LOW_M () {	0x7f80;}
}
unless(defined(&AR_PHY_AGC_COARSE_LOW_S)) {
    sub AR_PHY_AGC_COARSE_LOW_S () {	7;}
}
unless(defined(&AR_PHY_AGC_COARSE_HIGH_M)) {
    sub AR_PHY_AGC_COARSE_HIGH_M () {	0x3f8000;}
}
unless(defined(&AR_PHY_AGC_COARSE_HIGH_S)) {
    sub AR_PHY_AGC_COARSE_HIGH_S () {	15;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_BSW_ATTEN_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_BSW_ATTEN_M () {	0x1f;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_BSW_ATTEN_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_BSW_ATTEN_S () {	0;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN1_DB_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN1_DB_M () {	0x3f;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN1_DB_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN1_DB_S () {	0;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN2_DB_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN2_DB_M () {	0xfc0;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN2_DB_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN2_DB_S () {	6;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_BSW_MARGIN_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_BSW_MARGIN_M () {	0x3c00;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_BSW_MARGIN_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_BSW_MARGIN_S () {	10;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN1_MARGIN_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN1_MARGIN_M () {	0x1f000;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN1_MARGIN_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN1_MARGIN_S () {	12;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN2_MARGIN_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN2_MARGIN_M () {	0x3e0000;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_XATTEN2_MARGIN_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_XATTEN2_MARGIN_S () {	17;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_RXTX_MARGIN_M)) {
    sub AR_PHY_EXT_ATTEN_CTL_RXTX_MARGIN_M () {	0xfc0000;}
}
unless(defined(&AR_PHY_EXT_ATTEN_CTL_RXTX_MARGIN_S)) {
    sub AR_PHY_EXT_ATTEN_CTL_RXTX_MARGIN_S () {	18;}
}
unless(defined(&AR_PHY_MAXCCA_PWR_M)) {
    sub AR_PHY_MAXCCA_PWR_M () {	0x1ff;}
}
unless(defined(&AR_PHY_MAXCCA_PWR_S)) {
    sub AR_PHY_MAXCCA_PWR_S () {	0;}
}
unless(defined(&AR_PHY_MINCCA_PWR_M)) {
    sub AR_PHY_MINCCA_PWR_M () {	0x1ff00000;}
}
unless(defined(&AR_PHY_MINCCA_PWR_S)) {
    sub AR_PHY_MINCCA_PWR_S () {	20;}
}
unless(defined(&AR_PHY_EXT_MAXCCA_PWR_M)) {
    sub AR_PHY_EXT_MAXCCA_PWR_M () {	0x1ff;}
}
unless(defined(&AR_PHY_EXT_MAXCCA_PWR_S)) {
    sub AR_PHY_EXT_MAXCCA_PWR_S () {	0;}
}
unless(defined(&AR_PHY_EXT_MINCCA_PWR_M)) {
    sub AR_PHY_EXT_MINCCA_PWR_M () {	0x1ff0000;}
}
unless(defined(&AR_PHY_EXT_MINCCA_PWR_S)) {
    sub AR_PHY_EXT_MINCCA_PWR_S () {	16;}
}
unless(defined(&AR_PHY_RESTART_ENA)) {
    sub AR_PHY_RESTART_ENA () {	0x1;}
}
unless(defined(&AR_PHY_RESTART_DIV_GC_M)) {
    sub AR_PHY_RESTART_DIV_GC_M () {	0x1c0000;}
}
unless(defined(&AR_PHY_RESTART_DIV_GC_S)) {
    sub AR_PHY_RESTART_DIV_GC_S () {	18;}
}
unless(defined(&AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_M)) {
    sub AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_M () {	0x3f;}
}
unless(defined(&AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S)) {
    sub AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S () {	0;}
}
unless(defined(&AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_M)) {
    sub AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_M () {	0x1fc0;}
}
unless(defined(&AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_S)) {
    sub AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_S () {	6;}
}
unless(defined(&AR_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV)) {
    sub AR_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV () {	0x2000;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK_EN_RSSI_THR)) {
    sub AR_PHY_DAG_CTRLCCK_EN_RSSI_THR () {	0x200;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK_RSSI_THR_M)) {
    sub AR_PHY_DAG_CTRLCCK_RSSI_THR_M () {	0x1fc00;}
}
unless(defined(&AR_PHY_DAG_CTRLCCK_RSSI_THR_S)) {
    sub AR_PHY_DAG_CTRLCCK_RSSI_THR_S () {	10;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_USE_CCK_SPUR_MIT)) {
    sub AR_PHY_CCK_SPUR_MIT_USE_CCK_SPUR_MIT () {	0x1;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_SPUR_RSSI_THR_M)) {
    sub AR_PHY_CCK_SPUR_MIT_SPUR_RSSI_THR_M () {	0x1fe;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_SPUR_RSSI_THR_S)) {
    sub AR_PHY_CCK_SPUR_MIT_SPUR_RSSI_THR_S () {	1;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_CCK_SPUR_FREQ_M)) {
    sub AR_PHY_CCK_SPUR_MIT_CCK_SPUR_FREQ_M () {	0x1ffffe00;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_CCK_SPUR_FREQ_S)) {
    sub AR_PHY_CCK_SPUR_MIT_CCK_SPUR_FREQ_S () {	9;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_SPUR_FILTER_TYPE_M)) {
    sub AR_PHY_CCK_SPUR_MIT_SPUR_FILTER_TYPE_M () {	0x60000000;}
}
unless(defined(&AR_PHY_CCK_SPUR_MIT_SPUR_FILTER_TYPE_S)) {
    sub AR_PHY_CCK_SPUR_MIT_SPUR_FILTER_TYPE_S () {	29;}
}
unless(defined(&AR_PHY_GC_TURBO_MODE)) {
    sub AR_PHY_GC_TURBO_MODE () {	0x1;}
}
unless(defined(&AR_PHY_GC_TURBO_SHORT)) {
    sub AR_PHY_GC_TURBO_SHORT () {	0x2;}
}
unless(defined(&AR_PHY_GC_DYN2040_EN)) {
    sub AR_PHY_GC_DYN2040_EN () {	0x4;}
}
unless(defined(&AR_PHY_GC_DYN2040_PRI_ONLY)) {
    sub AR_PHY_GC_DYN2040_PRI_ONLY () {	0x8;}
}
unless(defined(&AR_PHY_GC_DYN2040_PRI_CH)) {
    sub AR_PHY_GC_DYN2040_PRI_CH () {	0x10;}
}
unless(defined(&AR_PHY_GC_DYN2040_EXT_CH)) {
    sub AR_PHY_GC_DYN2040_EXT_CH () {	0x20;}
}
unless(defined(&AR_PHY_GC_HT_EN)) {
    sub AR_PHY_GC_HT_EN () {	0x40;}
}
unless(defined(&AR_PHY_GC_SHORT_GI_40)) {
    sub AR_PHY_GC_SHORT_GI_40 () {	0x80;}
}
unless(defined(&AR_PHY_GC_WALSH)) {
    sub AR_PHY_GC_WALSH () {	0x100;}
}
unless(defined(&AR_PHY_GC_SINGLE_HT_LTF1)) {
    sub AR_PHY_GC_SINGLE_HT_LTF1 () {	0x200;}
}
unless(defined(&AR_PHY_GC_GF_DETECT_EN)) {
    sub AR_PHY_GC_GF_DETECT_EN () {	0x400;}
}
unless(defined(&AR_PHY_GC_ENABLE_DAC_FIFO)) {
    sub AR_PHY_GC_ENABLE_DAC_FIFO () {	0x800;}
}
unless(defined(&AR_PHY_MODE_OFDM)) {
    sub AR_PHY_MODE_OFDM () {	0x;}
}
unless(defined(&AR_PHY_MODE_CCK)) {
    sub AR_PHY_MODE_CCK () {	0x1;}
}
unless(defined(&AR_PHY_MODE_DYNAMIC)) {
    sub AR_PHY_MODE_DYNAMIC () {	0x4;}
}
unless(defined(&AR_PHY_MODE_HALF)) {
    sub AR_PHY_MODE_HALF () {	0x20;}
}
unless(defined(&AR_PHY_MODE_QUARTER)) {
    sub AR_PHY_MODE_QUARTER () {	0x40;}
}
unless(defined(&AR_PHY_MODE_DYN_CCK_DISABLE)) {
    sub AR_PHY_MODE_DYN_CCK_DISABLE () {	0x100;}
}
unless(defined(&AR_PHY_MODE_SVD_HALF)) {
    sub AR_PHY_MODE_SVD_HALF () {	0x200;}
}
unless(defined(&AR_PHY_ACTIVE_DIS)) {
    sub AR_PHY_ACTIVE_DIS () {	0x;}
}
unless(defined(&AR_PHY_ACTIVE_EN)) {
    sub AR_PHY_ACTIVE_EN () {	0x1;}
}
unless(defined(&AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_A_M)) {
    sub AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_A_M () {	0x3ff;}
}
unless(defined(&AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_A_S)) {
    sub AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_A_S () {	0;}
}
unless(defined(&AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_IDX_A_M)) {
    sub AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_IDX_A_M () {	0x1fc00;}
}
unless(defined(&AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_IDX_A_S)) {
    sub AR_PHY_SPUR_MASK_A_CF_PUNC_MASK_IDX_A_S () {	10;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_ENABLE)) {
    sub AR_PHY_SPECTRAL_SCAN_ENABLE () {	0x1;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_ACTIVE)) {
    sub AR_PHY_SPECTRAL_SCAN_ACTIVE () {	0x2;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_FFT_PERIOD_M)) {
    sub AR_PHY_SPECTRAL_SCAN_FFT_PERIOD_M () {	0xf0;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_FFT_PERIOD_S)) {
    sub AR_PHY_SPECTRAL_SCAN_FFT_PERIOD_S () {	4;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_PERIOD_M)) {
    sub AR_PHY_SPECTRAL_SCAN_PERIOD_M () {	0xff00;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_PERIOD_S)) {
    sub AR_PHY_SPECTRAL_SCAN_PERIOD_S () {	8;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_COUNT_M)) {
    sub AR_PHY_SPECTRAL_SCAN_COUNT_M () {	0xff0000;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_COUNT_S)) {
    sub AR_PHY_SPECTRAL_SCAN_COUNT_S () {	16;}
}
unless(defined(&AR_PHY_SPECTRAL_SCAN_SHORT_REPEAT)) {
    sub AR_PHY_SPECTRAL_SCAN_SHORT_REPEAT () {	0x1000000;}
}
unless(defined(&AR_PHY_RFBUS_REQ_EN)) {
    sub AR_PHY_RFBUS_REQ_EN () {	0x1;}
}
unless(defined(&AR_PHY_RFBUS_GRANT_EN)) {
    sub AR_PHY_RFBUS_GRANT_EN () {	0x1;}
}
unless(defined(&AR_PHY_RIFS_INIT_DELAY)) {
    sub AR_PHY_RIFS_INIT_DELAY () {	0x3ff0000;}
}
unless(defined(&AR_PHY_RX_DELAY_DELAY_M)) {
    sub AR_PHY_RX_DELAY_DELAY_M () {	0x3fff;}
}
unless(defined(&AR_PHY_RX_DELAY_DELAY_S)) {
    sub AR_PHY_RX_DELAY_DELAY_S () {	0;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_FRAME_XPAA_ON_M)) {
    sub AR_PHY_XPA_TIMING_CTL_FRAME_XPAA_ON_M () {	0xff;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_FRAME_XPAA_ON_S)) {
    sub AR_PHY_XPA_TIMING_CTL_FRAME_XPAA_ON_S () {	0;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_FRAME_XPAB_ON_M)) {
    sub AR_PHY_XPA_TIMING_CTL_FRAME_XPAB_ON_M () {	0xff00;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_FRAME_XPAB_ON_S)) {
    sub AR_PHY_XPA_TIMING_CTL_FRAME_XPAB_ON_S () {	8;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_TX_END_XPAA_OFF_M)) {
    sub AR_PHY_XPA_TIMING_CTL_TX_END_XPAA_OFF_M () {	0xff0000;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_TX_END_XPAA_OFF_S)) {
    sub AR_PHY_XPA_TIMING_CTL_TX_END_XPAA_OFF_S () {	16;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_TX_END_XPAB_OFF_M)) {
    sub AR_PHY_XPA_TIMING_CTL_TX_END_XPAB_OFF_M () {	0xff000000;}
}
unless(defined(&AR_PHY_XPA_TIMING_CTL_TX_END_XPAB_OFF_S)) {
    sub AR_PHY_XPA_TIMING_CTL_TX_END_XPAB_OFF_S () {	24;}
}
unless(defined(&AR_SWITCH_TABLE_ALL_M)) {
    sub AR_SWITCH_TABLE_ALL_M () {	0xfff;}
}
unless(defined(&AR_SWITCH_TABLE_ALL_S)) {
    sub AR_SWITCH_TABLE_ALL_S () {	0;}
}
unless(defined(&AR_SWITCH_TABLE_COM_ALL_M)) {
    sub AR_SWITCH_TABLE_COM_ALL_M () {	0xffff;}
}
unless(defined(&AR_SWITCH_TABLE_COM_ALL_S)) {
    sub AR_SWITCH_TABLE_COM_ALL_S () {	0;}
}
unless(defined(&AR_SWITCH_TABLE_COM_2_ALL_M)) {
    sub AR_SWITCH_TABLE_COM_2_ALL_M () {	0xffffff;}
}
unless(defined(&AR_SWITCH_TABLE_COM_2_ALL_S)) {
    sub AR_SWITCH_TABLE_COM_2_ALL_S () {	0;}
}
unless(defined(&AR_PHY_AGC_CONTROL_CAL)) {
    sub AR_PHY_AGC_CONTROL_CAL () {	0x1;}
}
unless(defined(&AR_PHY_AGC_CONTROL_NF)) {
    sub AR_PHY_AGC_CONTROL_NF () {	0x2;}
}
unless(defined(&AR_PHY_AGC_CONTROL_YCOK_MAX_M)) {
    sub AR_PHY_AGC_CONTROL_YCOK_MAX_M () {	0x3c0;}
}
unless(defined(&AR_PHY_AGC_CONTROL_YCOK_MAX_S)) {
    sub AR_PHY_AGC_CONTROL_YCOK_MAX_S () {	6;}
}
unless(defined(&AR_PHY_AGC_CONTROL_OFFSET_CAL)) {
    sub AR_PHY_AGC_CONTROL_OFFSET_CAL () {	0x800;}
}
unless(defined(&AR_PHY_AGC_CONTROL_ENABLE_NF)) {
    sub AR_PHY_AGC_CONTROL_ENABLE_NF () {	0x8000;}
}
unless(defined(&AR_PHY_AGC_CONTROL_FLTR_CAL)) {
    sub AR_PHY_AGC_CONTROL_FLTR_CAL () {	0x10000;}
}
unless(defined(&AR_PHY_AGC_CONTROL_NO_UPDATE_NF)) {
    sub AR_PHY_AGC_CONTROL_NO_UPDATE_NF () {	0x20000;}
}
unless(defined(&AR_PHY_AGC_CONTROL_EXT_NF_PWR_MEAS)) {
    sub AR_PHY_AGC_CONTROL_EXT_NF_PWR_MEAS () {	0x40000;}
}
unless(defined(&AR_PHY_AGC_CONTROL_CLC_SUCCESS)) {
    sub AR_PHY_AGC_CONTROL_CLC_SUCCESS () {	0x80000;}
}
unless(defined(&AR_PHY_CALMODE_IQ)) {
    sub AR_PHY_CALMODE_IQ () {	0x;}
}
unless(defined(&AR_PHY_CALMODE_ADC_GAIN)) {
    sub AR_PHY_CALMODE_ADC_GAIN () {	0x1;}
}
unless(defined(&AR_PHY_CALMODE_ADC_DC_PER)) {
    sub AR_PHY_CALMODE_ADC_DC_PER () {	0x2;}
}
unless(defined(&AR_PHY_CALMODE_ADC_DC_INIT)) {
    sub AR_PHY_CALMODE_ADC_DC_INIT () {	0x3;}
}
unless(defined(&AR_PHY_FCAL20_CAP_STATUS_0_M)) {
    sub AR_PHY_FCAL20_CAP_STATUS_0_M () {	0x1f00000;}
}
unless(defined(&AR_PHY_FCAL20_CAP_STATUS_0_S)) {
    sub AR_PHY_FCAL20_CAP_STATUS_0_S () {	20;}
}
unless(defined(&AR9380_BMODE)) {
    sub AR9380_BMODE () {	0x20000000;}
}
unless(defined(&AR_PHY_SWAP_ALT_CHAIN)) {
    sub AR_PHY_SWAP_ALT_CHAIN () {	0x40;}
}
unless(defined(&AR_PHY_ADDAC_PARACTL_OFF_PWDADC)) {
    sub AR_PHY_ADDAC_PARACTL_OFF_PWDADC () {	0x8000;}
}
unless(defined(&AR_PHY_TEST_RFSILENT_BB)) {
    sub AR_PHY_TEST_RFSILENT_BB () {	0x2000;}
}
unless(defined(&AR_PHY_TEST_BBB_OBS_SEL_M)) {
    sub AR_PHY_TEST_BBB_OBS_SEL_M () {	0x780000;}
}
unless(defined(&AR_PHY_TEST_BBB_OBS_SEL_S)) {
    sub AR_PHY_TEST_BBB_OBS_SEL_S () {	19;}
}
unless(defined(&AR_PHY_TEST_RX_OBS_SEL_BIT5)) {
    sub AR_PHY_TEST_RX_OBS_SEL_BIT5 () {	0x800000;}
}
unless(defined(&AR_PHY_TEST_CHAIN_SEL_M)) {
    sub AR_PHY_TEST_CHAIN_SEL_M () {	0xc0000000;}
}
unless(defined(&AR_PHY_TEST_CHAIN_SEL_S)) {
    sub AR_PHY_TEST_CHAIN_SEL_S () {	30;}
}
unless(defined(&AR_PHY_TEST_CTL_TSTDAC_EN)) {
    sub AR_PHY_TEST_CTL_TSTDAC_EN () {	0x1;}
}
unless(defined(&AR_PHY_TEST_CTL_TX_OBS_SEL_M)) {
    sub AR_PHY_TEST_CTL_TX_OBS_SEL_M () {	0x1c;}
}
unless(defined(&AR_PHY_TEST_CTL_TX_OBS_SEL_S)) {
    sub AR_PHY_TEST_CTL_TX_OBS_SEL_S () {	2;}
}
unless(defined(&AR_PHY_TEST_CTL_TX_OBS_MUX_SEL_M)) {
    sub AR_PHY_TEST_CTL_TX_OBS_MUX_SEL_M () {	0x60;}
}
unless(defined(&AR_PHY_TEST_CTL_TX_OBS_MUX_SEL_S)) {
    sub AR_PHY_TEST_CTL_TX_OBS_MUX_SEL_S () {	5;}
}
unless(defined(&AR_PHY_TEST_CTL_TSTADC_EN)) {
    sub AR_PHY_TEST_CTL_TSTADC_EN () {	0x100;}
}
unless(defined(&AR_PHY_TEST_CTL_RX_OBS_SEL_M)) {
    sub AR_PHY_TEST_CTL_RX_OBS_SEL_M () {	0x3c00;}
}
unless(defined(&AR_PHY_TEST_CTL_RX_OBS_SEL_S)) {
    sub AR_PHY_TEST_CTL_RX_OBS_SEL_S () {	10;}
}
unless(defined(&AR_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK)) {
    sub AR_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK () {	0x1;}
}
unless(defined(&AR_PHY_CHAN_INFO_TAB_S2_READ)) {
    sub AR_PHY_CHAN_INFO_TAB_S2_READ () {	0x8;}
}
unless(defined(&AR_PHY_CHAN_INFO_GAIN_DIFF_PPM_MASK)) {
    sub AR_PHY_CHAN_INFO_GAIN_DIFF_PPM_MASK () {	0xfff;}
}
unless(defined(&AR_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT)) {
    sub AR_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT () {	320;}
}
unless(defined(&AR_PHY_CCK_TX_CTRL_JAPAN)) {
    sub AR_PHY_CCK_TX_CTRL_JAPAN () {	0x10;}
}
unless(defined(&AR_PHY_PWRTX_RATE5_POWERTXHT20_0_M)) {
    sub AR_PHY_PWRTX_RATE5_POWERTXHT20_0_M () {	0x3f;}
}
unless(defined(&AR_PHY_PWRTX_RATE5_POWERTXHT20_0_S)) {
    sub AR_PHY_PWRTX_RATE5_POWERTXHT20_0_S () {	0;}
}
unless(defined(&AR_PHY_POWER_TX_RATE_MAX_TPC_ENABLE)) {
    sub AR_PHY_POWER_TX_RATE_MAX_TPC_ENABLE () {	0x40;}
}
unless(defined(&AR_PHY_TPC_1_FORCE_DAC_GAIN)) {
    sub AR_PHY_TPC_1_FORCE_DAC_GAIN () {	0x1;}
}
unless(defined(&AR_PHY_TPC_1_FORCED_DAC_GAIN_M)) {
    sub AR_PHY_TPC_1_FORCED_DAC_GAIN_M () {	0x3e;}
}
unless(defined(&AR_PHY_TPC_1_FORCED_DAC_GAIN_S)) {
    sub AR_PHY_TPC_1_FORCED_DAC_GAIN_S () {	1;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_OVERLAP_M)) {
    sub AR_PHY_TPC_5_PD_GAIN_OVERLAP_M () {	0xf;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_OVERLAP_S)) {
    sub AR_PHY_TPC_5_PD_GAIN_OVERLAP_S () {	0;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_1_M)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_1_M () {	0x3f0;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_1_S)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_1_S () {	4;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_2_M)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_2_M () {	0xfc00;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_2_S)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_2_S () {	10;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_3_M)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_3_M () {	0x3f0000;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_3_S)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_3_S () {	16;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_4_M)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_4_M () {	0xfc00000;}
}
unless(defined(&AR_PHY_TPC_5_PD_GAIN_BOUNDARY_4_S)) {
    sub AR_PHY_TPC_5_PD_GAIN_BOUNDARY_4_S () {	22;}
}
unless(defined(&AR_PHY_TPC_6_ERROR_EST_MODE_M)) {
    sub AR_PHY_TPC_6_ERROR_EST_MODE_M () {	0x3000000;}
}
unless(defined(&AR_PHY_TPC_6_ERROR_EST_MODE_S)) {
    sub AR_PHY_TPC_6_ERROR_EST_MODE_S () {	24;}
}
unless(defined(&AR_PHY_TPC_11_OLPC_GAIN_DELTA_M)) {
    sub AR_PHY_TPC_11_OLPC_GAIN_DELTA_M () {	0xff0000;}
}
unless(defined(&AR_PHY_TPC_11_OLPC_GAIN_DELTA_S)) {
    sub AR_PHY_TPC_11_OLPC_GAIN_DELTA_S () {	16;}
}
unless(defined(&AR_PHY_TPC_11_OLPC_GAIN_DELTA_PAL_ON_M)) {
    sub AR_PHY_TPC_11_OLPC_GAIN_DELTA_PAL_ON_M () {	0xff000000;}
}
unless(defined(&AR_PHY_TPC_11_OLPC_GAIN_DELTA_PAL_ON_S)) {
    sub AR_PHY_TPC_11_OLPC_GAIN_DELTA_PAL_ON_S () {	24;}
}
unless(defined(&AR_PHY_TPC_12_DESIRED_SCALE_HT40_5_M)) {
    sub AR_PHY_TPC_12_DESIRED_SCALE_HT40_5_M () {	0x3e000000;}
}
unless(defined(&AR_PHY_TPC_12_DESIRED_SCALE_HT40_5_S)) {
    sub AR_PHY_TPC_12_DESIRED_SCALE_HT40_5_S () {	25;}
}
unless(defined(&AR_PHY_TPC_18_THERM_CAL_M)) {
    sub AR_PHY_TPC_18_THERM_CAL_M () {	0xff;}
}
unless(defined(&AR_PHY_TPC_18_THERM_CAL_S)) {
    sub AR_PHY_TPC_18_THERM_CAL_S () {	0;}
}
unless(defined(&AR_PHY_TPC_18_VOLT_CAL_M)) {
    sub AR_PHY_TPC_18_VOLT_CAL_M () {	0xff00;}
}
unless(defined(&AR_PHY_TPC_18_VOLT_CAL_S)) {
    sub AR_PHY_TPC_18_VOLT_CAL_S () {	8;}
}
unless(defined(&AR_PHY_TPC_19_ALPHA_THERM_M)) {
    sub AR_PHY_TPC_19_ALPHA_THERM_M () {	0xff;}
}
unless(defined(&AR_PHY_TPC_19_ALPHA_THERM_S)) {
    sub AR_PHY_TPC_19_ALPHA_THERM_S () {	0;}
}
unless(defined(&AR_PHY_TPC_19_ALPHA_VOLT_M)) {
    sub AR_PHY_TPC_19_ALPHA_VOLT_M () {	0x1f0000;}
}
unless(defined(&AR_PHY_TPC_19_ALPHA_VOLT_S)) {
    sub AR_PHY_TPC_19_ALPHA_VOLT_S () {	16;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_1_INIT_THERM_M)) {
    sub AR_PHY_BB_THERM_ADC_1_INIT_THERM_M () {	0xff;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_1_INIT_THERM_S)) {
    sub AR_PHY_BB_THERM_ADC_1_INIT_THERM_S () {	0;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_4_LATEST_THERM_M)) {
    sub AR_PHY_BB_THERM_ADC_4_LATEST_THERM_M () {	0xff;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_4_LATEST_THERM_S)) {
    sub AR_PHY_BB_THERM_ADC_4_LATEST_THERM_S () {	0;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_4_LATEST_VOLT_M)) {
    sub AR_PHY_BB_THERM_ADC_4_LATEST_VOLT_M () {	0xff00;}
}
unless(defined(&AR_PHY_BB_THERM_ADC_4_LATEST_VOLT_S)) {
    sub AR_PHY_BB_THERM_ADC_4_LATEST_VOLT_S () {	8;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_FORCE_TX_GAIN)) {
    sub AR_PHY_TX_FORCED_GAIN_FORCE_TX_GAIN () {	0x1;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_TXBB1DBGAIN_M)) {
    sub AR_PHY_TX_FORCED_GAIN_TXBB1DBGAIN_M () {	0xe;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_TXBB1DBGAIN_S)) {
    sub AR_PHY_TX_FORCED_GAIN_TXBB1DBGAIN_S () {	1;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_TXBB6DBGAIN_M)) {
    sub AR_PHY_TX_FORCED_GAIN_TXBB6DBGAIN_M () {	0x30;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_TXBB6DBGAIN_S)) {
    sub AR_PHY_TX_FORCED_GAIN_TXBB6DBGAIN_S () {	4;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_TXMXRGAIN_M)) {
    sub AR_PHY_TX_FORCED_GAIN_TXMXRGAIN_M () {	0x3c0;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_TXMXRGAIN_S)) {
    sub AR_PHY_TX_FORCED_GAIN_TXMXRGAIN_S () {	6;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGNA_M)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGNA_M () {	0x3c00;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGNA_S)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGNA_S () {	10;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGNB_M)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGNB_M () {	0x3c000;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGNB_S)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGNB_S () {	14;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGNC_M)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGNC_M () {	0x3c0000;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGNC_S)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGNC_S () {	18;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGND_M)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGND_M () {	0xc00000;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_PADRVGND_S)) {
    sub AR_PHY_TX_FORCED_GAIN_PADRVGND_S () {	22;}
}
unless(defined(&AR_PHY_TX_FORCED_GAIN_ENABLE_PAL)) {
    sub AR_PHY_TX_FORCED_GAIN_ENABLE_PAL () {	0x1000000;}
}
unless(defined(&AR_PHY_TXGAIN_TXBB1DBGAIN_M)) {
    sub AR_PHY_TXGAIN_TXBB1DBGAIN_M () {	0x7;}
}
unless(defined(&AR_PHY_TXGAIN_TXBB1DBGAIN_S)) {
    sub AR_PHY_TXGAIN_TXBB1DBGAIN_S () {	0;}
}
unless(defined(&AR_PHY_TXGAIN_TXBB6DBGAIN_M)) {
    sub AR_PHY_TXGAIN_TXBB6DBGAIN_M () {	0x18;}
}
unless(defined(&AR_PHY_TXGAIN_TXBB6DBGAIN_S)) {
    sub AR_PHY_TXGAIN_TXBB6DBGAIN_S () {	3;}
}
unless(defined(&AR_PHY_TXGAIN_TXMXRGAIN_M)) {
    sub AR_PHY_TXGAIN_TXMXRGAIN_M () {	0x1e0;}
}
unless(defined(&AR_PHY_TXGAIN_TXMXRGAIN_S)) {
    sub AR_PHY_TXGAIN_TXMXRGAIN_S () {	5;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGNA_M)) {
    sub AR_PHY_TXGAIN_PADRVGNA_M () {	0x1e00;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGNA_S)) {
    sub AR_PHY_TXGAIN_PADRVGNA_S () {	9;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGNB_M)) {
    sub AR_PHY_TXGAIN_PADRVGNB_M () {	0x1e000;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGNB_S)) {
    sub AR_PHY_TXGAIN_PADRVGNB_S () {	13;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGNC_M)) {
    sub AR_PHY_TXGAIN_PADRVGNC_M () {	0x1e0000;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGNC_S)) {
    sub AR_PHY_TXGAIN_PADRVGNC_S () {	17;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGND_M)) {
    sub AR_PHY_TXGAIN_PADRVGND_M () {	0x600000;}
}
unless(defined(&AR_PHY_TXGAIN_PADRVGND_S)) {
    sub AR_PHY_TXGAIN_PADRVGND_S () {	21;}
}
unless(defined(&AR_PHY_TXGAIN_INDEX_M)) {
    sub AR_PHY_TXGAIN_INDEX_M () {	0xff000000;}
}
unless(defined(&AR_PHY_TXGAIN_INDEX_S)) {
    sub AR_PHY_TXGAIN_INDEX_S () {	24;}
}
unless(defined(&AR_PHY_TX_IQCAQL_CONTROL_1_IQCORR_I_Q_COFF_DELPT_M)) {
    sub AR_PHY_TX_IQCAQL_CONTROL_1_IQCORR_I_Q_COFF_DELPT_M () {	0x1fc0000;}
}
unless(defined(&AR_PHY_TX_IQCAQL_CONTROL_1_IQCORR_I_Q_COFF_DELPT_S)) {
    sub AR_PHY_TX_IQCAQL_CONTROL_1_IQCORR_I_Q_COFF_DELPT_S () {	18;}
}
unless(defined(&AR_PHY_TX_IQCAL_START_DO_CAL)) {
    sub AR_PHY_TX_IQCAL_START_DO_CAL () {	0x1;}
}
unless(defined(&AR_PHY_TX_IQCAL_CORR_COEFF_01_COEFF_TABLE_M)) {
    sub AR_PHY_TX_IQCAL_CORR_COEFF_01_COEFF_TABLE_M () {	0x3fff;}
}
unless(defined(&AR_PHY_TX_IQCAL_CORR_COEFF_01_COEFF_TABLE_S)) {
    sub AR_PHY_TX_IQCAL_CORR_COEFF_01_COEFF_TABLE_S () {	0;}
}
unless(defined(&AR_PHY_TX_IQCAL_STATUS_FAILED)) {
    sub AR_PHY_TX_IQCAL_STATUS_FAILED () {	0x1;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_TRAIN_ENABLE)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_TRAIN_ENABLE () {	0x1;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_AGC2_SETTLING_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_AGC2_SETTLING_M () {	0x7e;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_AGC2_SETTLING_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_AGC2_SETTLING_S () {	1;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_IQCORR_ENABLE)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_IQCORR_ENABLE () {	0x100;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_RX_BB_GAIN_FORCE)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_RX_BB_GAIN_FORCE () {	0x200;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_TX_GAIN_FORCE)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_TX_GAIN_FORCE () {	0x400;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_LB_ENABLE)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_LB_ENABLE () {	0x800;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_LB_SKIP_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_LB_SKIP_M () {	0x3f000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL1_LB_SKIP_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL1_LB_SKIP_S () {	12;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_ADC_DESIRED_SIZE_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_ADC_DESIRED_SIZE_M () {	0x3f;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_ADC_DESIRED_SIZE_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_ADC_DESIRED_SIZE_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_QUICK_DROP_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_QUICK_DROP_M () {	0xfc0;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_QUICK_DROP_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_QUICK_DROP_S () {	6;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_MIN_LOOPBACK_DEL_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_MIN_LOOPBACK_DEL_M () {	0x1f000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_MIN_LOOPBACK_DEL_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_MIN_LOOPBACK_DEL_S () {	12;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_NUM_CORR_STAGES_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_NUM_CORR_STAGES_M () {	0xe0000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_NUM_CORR_STAGES_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_NUM_CORR_STAGES_S () {	17;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_COARSE_CORR_LEN_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_COARSE_CORR_LEN_M () {	0xf00000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_COARSE_CORR_LEN_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_COARSE_CORR_LEN_S () {	20;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_FINE_CORR_LEN_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_FINE_CORR_LEN_M () {	0xf000000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_FINE_CORR_LEN_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_FINE_CORR_LEN_S () {	24;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL3_BBTXMIX_DISABLE)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL3_BBTXMIX_DISABLE () {	0x20000000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4_MIN_CORR_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4_MIN_CORR_M () {	0xfff;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4_MIN_CORR_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4_MIN_CORR_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4_SAFETY_DELTA_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4_SAFETY_DELTA_M () {	0xf000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4_SAFETY_DELTA_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4_SAFETY_DELTA_S () {	12;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4_NUM_TRAIN_SAMPLES_M)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4_NUM_TRAIN_SAMPLES_M () {	0x3ff0000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_CNTL4_NUM_TRAIN_SAMPLES_S)) {
    sub AR_PHY_PAPRD_TRAINER_CNTL4_NUM_TRAIN_SAMPLES_S () {	16;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_TRAIN_DONE)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_TRAIN_DONE () {	0x1;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_TRAIN_INCOMPLETE)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_TRAIN_INCOMPLETE () {	0x2;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_CORR_ERR)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_CORR_ERR () {	0x4;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_TRAIN_ACTIVE)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_TRAIN_ACTIVE () {	0x8;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_RX_GAIN_IDX_M)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_RX_GAIN_IDX_M () {	0x1f0;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_RX_GAIN_IDX_S)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_RX_GAIN_IDX_S () {	4;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_AGC2_PWR_M)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_AGC2_PWR_M () {	0x1fe00;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT1_AGC2_PWR_S)) {
    sub AR_PHY_PAPRD_TRAINER_STAT1_AGC2_PWR_S () {	9;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2_FINE_VAL_M)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2_FINE_VAL_M () {	0xffff;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2_FINE_VAL_S)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2_FINE_VAL_S () {	0;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2_COARSE_IDX_M)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2_COARSE_IDX_M () {	0x1f0000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2_COARSE_IDX_S)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2_COARSE_IDX_S () {	16;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2_FINE_IDX_M)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2_FINE_IDX_M () {	0x600000;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT2_FINE_IDX_S)) {
    sub AR_PHY_PAPRD_TRAINER_STAT2_FINE_IDX_S () {	21;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT3_TRAIN_SAMPLES_CNT_M)) {
    sub AR_PHY_PAPRD_TRAINER_STAT3_TRAIN_SAMPLES_CNT_M () {	0xfffff;}
}
unless(defined(&AR_PHY_PAPRD_TRAINER_STAT3_TRAIN_SAMPLES_CNT_S)) {
    sub AR_PHY_PAPRD_TRAINER_STAT3_TRAIN_SAMPLES_CNT_S () {	0;}
}
unless(defined(&AR_PHY_SYNTH4_LONG_SHIFT_SELECT)) {
    sub AR_PHY_SYNTH4_LONG_SHIFT_SELECT () {	0x2;}
}
unless(defined(&AR9380_FRACMODE)) {
    sub AR9380_FRACMODE () {	0x40000000;}
}
unless(defined(&AR9380_LOAD_SYNTH)) {
    sub AR9380_LOAD_SYNTH () {	0x80000000;}
}
unless(defined(&AR_PHY_65NM_CH0_RXTX4_THERM_ON)) {
    sub AR_PHY_65NM_CH0_RXTX4_THERM_ON () {	0x10000000;}
}
unless(defined(&AR_PHY_65NM_CH0_TOP_XPABIASLVL_M)) {
    sub AR_PHY_65NM_CH0_TOP_XPABIASLVL_M () {	0x3;}
}
unless(defined(&AR_PHY_65NM_CH0_TOP_XPABIASLVL_S)) {
    sub AR_PHY_65NM_CH0_TOP_XPABIASLVL_S () {	0;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM_SPARE_M)) {
    sub AR_PHY_65NM_CH0_THERM_SPARE_M () {	0x3f;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM_SPARE_S)) {
    sub AR_PHY_65NM_CH0_THERM_SPARE_S () {	0;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM_SAR_ADC_OUT_M)) {
    sub AR_PHY_65NM_CH0_THERM_SAR_ADC_OUT_M () {	0xff00;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM_SAR_ADC_OUT_S)) {
    sub AR_PHY_65NM_CH0_THERM_SAR_ADC_OUT_S () {	8;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM_START)) {
    sub AR_PHY_65NM_CH0_THERM_START () {	0x20000000;}
}
unless(defined(&AR_PHY_65NM_CH0_THERM_LOCAL)) {
    sub AR_PHY_65NM_CH0_THERM_LOCAL () {	0x80000000;}
}
unless(defined(&AR9003_MAX_CHAINS)) {
    sub AR9003_MAX_CHAINS () {	3;}
}
unless(defined(&AR9003_TX_QDEPTH)) {
    sub AR9003_TX_QDEPTH () {	8;}
}
unless(defined(&AR9003_RX_LP_QDEPTH)) {
    sub AR9003_RX_LP_QDEPTH () {	128;}
}
unless(defined(&AR9003_RX_HP_QDEPTH)) {
    sub AR9003_RX_HP_QDEPTH () {	16;}
}
unless(defined(&AR9003_NTXSTATUS)) {
    sub AR9003_NTXSTATUS () {	64;}
}
unless(defined(&AR9003_MAX_SCATTER)) {
    sub AR9003_MAX_SCATTER () {	4;}
}
unless(defined(&AR_TXI_DESC_NDWORDS_M)) {
    sub AR_TXI_DESC_NDWORDS_M () {	0xff;}
}
unless(defined(&AR_TXI_DESC_NDWORDS_S)) {
    sub AR_TXI_DESC_NDWORDS_S () {	0;}
}
unless(defined(&AR_TXI_QCU_NUM_M)) {
    sub AR_TXI_QCU_NUM_M () {	0xf00;}
}
unless(defined(&AR_TXI_QCU_NUM_S)) {
    sub AR_TXI_QCU_NUM_S () {	8;}
}
unless(defined(&AR_TXI_CTRL_STAT)) {
    sub AR_TXI_CTRL_STAT () {	0x4000;}
}
unless(defined(&AR_TXI_DESC_TX)) {
    sub AR_TXI_DESC_TX () {	0x8000;}
}
unless(defined(&AR_TXI_DESC_ID_M)) {
    sub AR_TXI_DESC_ID_M () {	0xffff0000;}
}
unless(defined(&AR_TXI_DESC_ID_S)) {
    sub AR_TXI_DESC_ID_S () {	16;}
}
unless(defined(&AR_VENDOR_ATHEROS)) {
    sub AR_VENDOR_ATHEROS () {	0x168c;}
}
unless(defined(&AR_TXC_BUF_LEN_M)) {
    sub AR_TXC_BUF_LEN_M () {	0xfff0000;}
}
unless(defined(&AR_TXC_BUF_LEN_S)) {
    sub AR_TXC_BUF_LEN_S () {	16;}
}
unless(defined(&AR_TXC10_PTR_CHK_SUM_M)) {
    sub AR_TXC10_PTR_CHK_SUM_M () {	0xffff;}
}
unless(defined(&AR_TXC10_PTR_CHK_SUM_S)) {
    sub AR_TXC10_PTR_CHK_SUM_S () {	0;}
}
unless(defined(&AR_TXC11_FRAME_LEN_M)) {
    sub AR_TXC11_FRAME_LEN_M () {	0xfff;}
}
unless(defined(&AR_TXC11_FRAME_LEN_S)) {
    sub AR_TXC11_FRAME_LEN_S () {	0;}
}
unless(defined(&AR_TXC11_XMIT_POWER_M)) {
    sub AR_TXC11_XMIT_POWER_M () {	0x3f0000;}
}
unless(defined(&AR_TXC11_XMIT_POWER_S)) {
    sub AR_TXC11_XMIT_POWER_S () {	16;}
}
unless(defined(&AR_TXC11_RTS_ENABLE)) {
    sub AR_TXC11_RTS_ENABLE () {	0x400000;}
}
unless(defined(&AR_TXC11_CLR_DEST_MASK)) {
    sub AR_TXC11_CLR_DEST_MASK () {	0x1000000;}
}
unless(defined(&AR_TXC11_DEST_IDX_VALID)) {
    sub AR_TXC11_DEST_IDX_VALID () {	0x40000000;}
}
unless(defined(&AR_TXC11_CTS_ENABLE)) {
    sub AR_TXC11_CTS_ENABLE () {	0x80000000;}
}
unless(defined(&AR_TXC12_PAPRD_CHAIN_MASK_M)) {
    sub AR_TXC12_PAPRD_CHAIN_MASK_M () {	0xe00;}
}
unless(defined(&AR_TXC12_PAPRD_CHAIN_MASK_S)) {
    sub AR_TXC12_PAPRD_CHAIN_MASK_S () {	9;}
}
unless(defined(&AR_TXC12_DEST_IDX_M)) {
    sub AR_TXC12_DEST_IDX_M () {	0xfe000;}
}
unless(defined(&AR_TXC12_DEST_IDX_S)) {
    sub AR_TXC12_DEST_IDX_S () {	13;}
}
unless(defined(&AR_TXC12_FRAME_TYPE_M)) {
    sub AR_TXC12_FRAME_TYPE_M () {	0xf00000;}
}
unless(defined(&AR_TXC12_FRAME_TYPE_S)) {
    sub AR_TXC12_FRAME_TYPE_S () {	20;}
}
unless(defined(&AR_FRAME_TYPE_NORMAL)) {
    sub AR_FRAME_TYPE_NORMAL () {	0;}
}
unless(defined(&AR_FRAME_TYPE_ATIM)) {
    sub AR_FRAME_TYPE_ATIM () {	1;}
}
unless(defined(&AR_FRAME_TYPE_PSPOLL)) {
    sub AR_FRAME_TYPE_PSPOLL () {	2;}
}
unless(defined(&AR_FRAME_TYPE_BEACON)) {
    sub AR_FRAME_TYPE_BEACON () {	3;}
}
unless(defined(&AR_FRAME_TYPE_PROBE_RESP)) {
    sub AR_FRAME_TYPE_PROBE_RESP () {	4;}
}
unless(defined(&AR_TXC12_NO_ACK)) {
    sub AR_TXC12_NO_ACK () {	0x1000000;}
}
unless(defined(&AR_TXC13_BURST_DUR_M)) {
    sub AR_TXC13_BURST_DUR_M () {	0x7fff;}
}
unless(defined(&AR_TXC13_BURST_DUR_S)) {
    sub AR_TXC13_BURST_DUR_S () {	0;}
}
unless(defined(&AR_TXC13_DUR_UPDATE_ENA)) {
    sub AR_TXC13_DUR_UPDATE_ENA () {	0x8000;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES0_M)) {
    sub AR_TXC13_XMIT_DATA_TRIES0_M () {	0xf0000;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES0_S)) {
    sub AR_TXC13_XMIT_DATA_TRIES0_S () {	16;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES1_M)) {
    sub AR_TXC13_XMIT_DATA_TRIES1_M () {	0xf00000;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES1_S)) {
    sub AR_TXC13_XMIT_DATA_TRIES1_S () {	20;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES2_M)) {
    sub AR_TXC13_XMIT_DATA_TRIES2_M () {	0xf000000;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES2_S)) {
    sub AR_TXC13_XMIT_DATA_TRIES2_S () {	24;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES3_M)) {
    sub AR_TXC13_XMIT_DATA_TRIES3_M () {	0xf0000000;}
}
unless(defined(&AR_TXC13_XMIT_DATA_TRIES3_S)) {
    sub AR_TXC13_XMIT_DATA_TRIES3_S () {	28;}
}
unless(defined(&AR_TXC14_XMIT_RATE0_M)) {
    sub AR_TXC14_XMIT_RATE0_M () {	0xff;}
}
unless(defined(&AR_TXC14_XMIT_RATE0_S)) {
    sub AR_TXC14_XMIT_RATE0_S () {	0;}
}
unless(defined(&AR_TXC14_XMIT_RATE1_M)) {
    sub AR_TXC14_XMIT_RATE1_M () {	0xff00;}
}
unless(defined(&AR_TXC14_XMIT_RATE1_S)) {
    sub AR_TXC14_XMIT_RATE1_S () {	8;}
}
unless(defined(&AR_TXC14_XMIT_RATE2_M)) {
    sub AR_TXC14_XMIT_RATE2_M () {	0xff0000;}
}
unless(defined(&AR_TXC14_XMIT_RATE2_S)) {
    sub AR_TXC14_XMIT_RATE2_S () {	16;}
}
unless(defined(&AR_TXC14_XMIT_RATE3_M)) {
    sub AR_TXC14_XMIT_RATE3_M () {	0xff000000;}
}
unless(defined(&AR_TXC14_XMIT_RATE3_S)) {
    sub AR_TXC14_XMIT_RATE3_S () {	24;}
}
unless(defined(&AR_TXC15_PACKET_DUR0_M)) {
    sub AR_TXC15_PACKET_DUR0_M () {	0x7fff;}
}
unless(defined(&AR_TXC15_PACKET_DUR0_S)) {
    sub AR_TXC15_PACKET_DUR0_S () {	0;}
}
unless(defined(&AR_TXC15_RTSCTS_QUAL0)) {
    sub AR_TXC15_RTSCTS_QUAL0 () {	0x8000;}
}
unless(defined(&AR_TXC15_PACKET_DUR1_M)) {
    sub AR_TXC15_PACKET_DUR1_M () {	0x7fff0000;}
}
unless(defined(&AR_TXC15_PACKET_DUR1_S)) {
    sub AR_TXC15_PACKET_DUR1_S () {	16;}
}
unless(defined(&AR_TXC15_RTSCTS_QUAL1)) {
    sub AR_TXC15_RTSCTS_QUAL1 () {	0x80000000;}
}
unless(defined(&AR_TXC15_RTSCTS_QUAL01)) {
    sub AR_TXC15_RTSCTS_QUAL01 () {	( &AR_TXC15_RTSCTS_QUAL0 |  &AR_TXC15_RTSCTS_QUAL1);}
}
unless(defined(&AR_TXC16_PACKET_DUR2_M)) {
    sub AR_TXC16_PACKET_DUR2_M () {	0x7fff;}
}
unless(defined(&AR_TXC16_PACKET_DUR2_S)) {
    sub AR_TXC16_PACKET_DUR2_S () {	0;}
}
unless(defined(&AR_TXC16_RTSCTS_QUAL2)) {
    sub AR_TXC16_RTSCTS_QUAL2 () {	0x8000;}
}
unless(defined(&AR_TXC16_PACKET_DUR3_M)) {
    sub AR_TXC16_PACKET_DUR3_M () {	0x7fff0000;}
}
unless(defined(&AR_TXC16_PACKET_DUR3_S)) {
    sub AR_TXC16_PACKET_DUR3_S () {	16;}
}
unless(defined(&AR_TXC16_RTSCTS_QUAL3)) {
    sub AR_TXC16_RTSCTS_QUAL3 () {	0x80000000;}
}
unless(defined(&AR_TXC16_RTSCTS_QUAL23)) {
    sub AR_TXC16_RTSCTS_QUAL23 () {	( &AR_TXC16_RTSCTS_QUAL2 |  &AR_TXC16_RTSCTS_QUAL3);}
}
unless(defined(&AR_TXC17_ENCR_TYPE_M)) {
    sub AR_TXC17_ENCR_TYPE_M () {	0xc000000;}
}
unless(defined(&AR_TXC17_ENCR_TYPE_S)) {
    sub AR_TXC17_ENCR_TYPE_S () {	26;}
}
unless(defined(&AR_ENCR_TYPE_CLEAR)) {
    sub AR_ENCR_TYPE_CLEAR () {	0;}
}
unless(defined(&AR_ENCR_TYPE_WEP)) {
    sub AR_ENCR_TYPE_WEP () {	1;}
}
unless(defined(&AR_ENCR_TYPE_AES)) {
    sub AR_ENCR_TYPE_AES () {	2;}
}
unless(defined(&AR_ENCR_TYPE_TKIP)) {
    sub AR_ENCR_TYPE_TKIP () {	3;}
}
unless(defined(&AR_TXC18_2040_0)) {
    sub AR_TXC18_2040_0 () {	0x1;}
}
unless(defined(&AR_TXC18_GI0)) {
    sub AR_TXC18_GI0 () {	0x2;}
}
unless(defined(&AR_TXC18_CHAIN_SEL0_M)) {
    sub AR_TXC18_CHAIN_SEL0_M () {	0x1c;}
}
unless(defined(&AR_TXC18_CHAIN_SEL0_S)) {
    sub AR_TXC18_CHAIN_SEL0_S () {	2;}
}
unless(defined(&AR_TXC18_2040_1)) {
    sub AR_TXC18_2040_1 () {	0x20;}
}
unless(defined(&AR_TXC18_GI1)) {
    sub AR_TXC18_GI1 () {	0x40;}
}
unless(defined(&AR_TXC18_CHAIN_SEL1_M)) {
    sub AR_TXC18_CHAIN_SEL1_M () {	0x380;}
}
unless(defined(&AR_TXC18_CHAIN_SEL1_S)) {
    sub AR_TXC18_CHAIN_SEL1_S () {	7;}
}
unless(defined(&AR_TXC18_2040_2)) {
    sub AR_TXC18_2040_2 () {	0x400;}
}
unless(defined(&AR_TXC18_GI2)) {
    sub AR_TXC18_GI2 () {	0x800;}
}
unless(defined(&AR_TXC18_CHAIN_SEL2_M)) {
    sub AR_TXC18_CHAIN_SEL2_M () {	0x7000;}
}
unless(defined(&AR_TXC18_CHAIN_SEL2_S)) {
    sub AR_TXC18_CHAIN_SEL2_S () {	12;}
}
unless(defined(&AR_TXC18_2040_3)) {
    sub AR_TXC18_2040_3 () {	0x8000;}
}
unless(defined(&AR_TXC18_GI3)) {
    sub AR_TXC18_GI3 () {	0x10000;}
}
unless(defined(&AR_TXC18_CHAIN_SEL3_M)) {
    sub AR_TXC18_CHAIN_SEL3_M () {	0xe0000;}
}
unless(defined(&AR_TXC18_CHAIN_SEL3_S)) {
    sub AR_TXC18_CHAIN_SEL3_S () {	17;}
}
unless(defined(&AR_TXC18_RTSCTS_RATE_M)) {
    sub AR_TXC18_RTSCTS_RATE_M () {	0xff00000;}
}
unless(defined(&AR_TXC18_RTSCTS_RATE_S)) {
    sub AR_TXC18_RTSCTS_RATE_S () {	20;}
}
unless(defined(&AR_TXC18_2040_0123)) {
    sub AR_TXC18_2040_0123 () {	( &AR_TXC18_2040_0 |  &AR_TXC18_2040_1 |  &AR_TXC18_2040_2 |  &AR_TXC18_2040_3);}
}
unless(defined(&AR_TXC18_GI0123)) {
    sub AR_TXC18_GI0123 () {	( &AR_TXC18_GI0 |  &AR_TXC18_GI1 |  &AR_TXC18_GI2 |  &AR_TXC18_GI3);}
}
unless(defined(&AR_TXC19_NOT_SOUNDING)) {
    sub AR_TXC19_NOT_SOUNDING () {	0x20000000;}
}
unless(defined(&AR_TXS3_EXCESSIVE_RETRIES)) {
    sub AR_TXS3_EXCESSIVE_RETRIES () {	0x2;}
}
unless(defined(&AR_TXS3_FIFO_UNDERRUN)) {
    sub AR_TXS3_FIFO_UNDERRUN () {	0x4;}
}
unless(defined(&AR_TXS3_RTS_FAIL_CNT_M)) {
    sub AR_TXS3_RTS_FAIL_CNT_M () {	0xf0;}
}
unless(defined(&AR_TXS3_RTS_FAIL_CNT_S)) {
    sub AR_TXS3_RTS_FAIL_CNT_S () {	4;}
}
unless(defined(&AR_TXS3_DATA_FAIL_CNT_M)) {
    sub AR_TXS3_DATA_FAIL_CNT_M () {	0xf00;}
}
unless(defined(&AR_TXS3_DATA_FAIL_CNT_S)) {
    sub AR_TXS3_DATA_FAIL_CNT_S () {	8;}
}
unless(defined(&AR_TXS3_TX_DELIM_UNDERRUN)) {
    sub AR_TXS3_TX_DELIM_UNDERRUN () {	0x10000;}
}
unless(defined(&AR_TXS3_TX_DATA_UNDERRUN)) {
    sub AR_TXS3_TX_DATA_UNDERRUN () {	0x20000;}
}
unless(defined(&AR_TXS3_UNDERRUN)) {
    sub AR_TXS3_UNDERRUN () {	( &AR_TXS3_FIFO_UNDERRUN |  &AR_TXS3_TX_DELIM_UNDERRUN |  &AR_TXS3_TX_DATA_UNDERRUN);}
}
unless(defined(&AR_TXS8_DONE)) {
    sub AR_TXS8_DONE () {	0x1;}
}
unless(defined(&AR_TXS8_FINAL_IDX_M)) {
    sub AR_TXS8_FINAL_IDX_M () {	0x600000;}
}
unless(defined(&AR_TXS8_FINAL_IDX_S)) {
    sub AR_TXS8_FINAL_IDX_S () {	21;}
}
unless(defined(&AR_RXI_CTRL_STAT)) {
    sub AR_RXI_CTRL_STAT () {	0x4000;}
}
unless(defined(&AR_RXI_DESC_TX)) {
    sub AR_RXI_DESC_TX () {	0x8000;}
}
unless(defined(&AR_RXI_DESC_ID_M)) {
    sub AR_RXI_DESC_ID_M () {	0xffff0000;}
}
unless(defined(&AR_RXI_DESC_ID_S)) {
    sub AR_RXI_DESC_ID_S () {	16;}
}
unless(defined(&AR_RXS1_DONE)) {
    sub AR_RXS1_DONE () {	0x1;}
}
unless(defined(&AR_RXS1_RATE_M)) {
    sub AR_RXS1_RATE_M () {	0x3fc;}
}
unless(defined(&AR_RXS1_RATE_S)) {
    sub AR_RXS1_RATE_S () {	2;}
}
unless(defined(&AR_RXS2_DATA_LEN_M)) {
    sub AR_RXS2_DATA_LEN_M () {	0xfff;}
}
unless(defined(&AR_RXS2_DATA_LEN_S)) {
    sub AR_RXS2_DATA_LEN_S () {	0;}
}
unless(defined(&AR_RXS4_GI)) {
    sub AR_RXS4_GI () {	0x1;}
}
unless(defined(&AR_RXS4_ANTENNA_M)) {
    sub AR_RXS4_ANTENNA_M () {	0xffffff00;}
}
unless(defined(&AR_RXS4_ANTENNA_S)) {
    sub AR_RXS4_ANTENNA_S () {	8;}
}
unless(defined(&AR_RXS5_RSSI_COMBINED_M)) {
    sub AR_RXS5_RSSI_COMBINED_M () {	0xff000000;}
}
unless(defined(&AR_RXS5_RSSI_COMBINED_S)) {
    sub AR_RXS5_RSSI_COMBINED_S () {	24;}
}
unless(defined(&AR_RXS11_FRAME_OK)) {
    sub AR_RXS11_FRAME_OK () {	0x2;}
}
unless(defined(&AR_RXS11_CRC_ERR)) {
    sub AR_RXS11_CRC_ERR () {	0x4;}
}
unless(defined(&AR_RXS11_DECRYPT_CRC_ERR)) {
    sub AR_RXS11_DECRYPT_CRC_ERR () {	0x8;}
}
unless(defined(&AR_RXS11_PHY_ERR)) {
    sub AR_RXS11_PHY_ERR () {	0x10;}
}
unless(defined(&AR_RXS11_PHY_ERR_CODE_M)) {
    sub AR_RXS11_PHY_ERR_CODE_M () {	0xff00;}
}
unless(defined(&AR_RXS11_PHY_ERR_CODE_S)) {
    sub AR_RXS11_PHY_ERR_CODE_S () {	8;}
}
unless(defined(&AR_RXS11_MICHAEL_ERR)) {
    sub AR_RXS11_MICHAEL_ERR () {	0x20;}
}
unless(defined(&AR_EEP_COMPRESS_NONE)) {
    sub AR_EEP_COMPRESS_NONE () {	0;}
}
unless(defined(&AR_EEP_COMPRESS_LZMA)) {
    sub AR_EEP_COMPRESS_LZMA () {	1;}
}
unless(defined(&AR_EEP_COMPRESS_PAIRS)) {
    sub AR_EEP_COMPRESS_PAIRS () {	2;}
}
unless(defined(&AR_EEP_COMPRESS_BLOCK)) {
    sub AR_EEP_COMPRESS_BLOCK () {	3;}
}
1;
