require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_XMMINTRIN_H_INCLUDED)) {
    eval 'sub _XMMINTRIN_H_INCLUDED () {1;}' unless defined(&_XMMINTRIN_H_INCLUDED);
    unless(defined(&__SSE__)) {
	die("SSE instruction set not enabled");
    } else {
	require 'mmintrin.ph';
	require 'mm_malloc.ph';
	eval 'sub _MM_SHUFFLE {
	    my($fp3,$fp2,$fp1,$fp0) = @_;
    	    eval q(((($fp3) << 6) | (($fp2) << 4) | (($fp1) << 2) | ($fp0)));
	}' unless defined(&_MM_SHUFFLE);
	eval("sub _MM_HINT_T0 () { 3; }") unless defined(&_MM_HINT_T0);
	eval("sub _MM_HINT_T1 () { 2; }") unless defined(&_MM_HINT_T1);
	eval("sub _MM_HINT_T2 () { 1; }") unless defined(&_MM_HINT_T2);
	eval("sub _MM_HINT_NTA () { 0; }") unless defined(&_MM_HINT_NTA);
	eval 'sub _MM_EXCEPT_MASK () {0x3f;}' unless defined(&_MM_EXCEPT_MASK);
	eval 'sub _MM_EXCEPT_INVALID () {0x1;}' unless defined(&_MM_EXCEPT_INVALID);
	eval 'sub _MM_EXCEPT_DENORM () {0x2;}' unless defined(&_MM_EXCEPT_DENORM);
	eval 'sub _MM_EXCEPT_DIV_ZERO () {0x4;}' unless defined(&_MM_EXCEPT_DIV_ZERO);
	eval 'sub _MM_EXCEPT_OVERFLOW () {0x8;}' unless defined(&_MM_EXCEPT_OVERFLOW);
	eval 'sub _MM_EXCEPT_UNDERFLOW () {0x10;}' unless defined(&_MM_EXCEPT_UNDERFLOW);
	eval 'sub _MM_EXCEPT_INEXACT () {0x20;}' unless defined(&_MM_EXCEPT_INEXACT);
	eval 'sub _MM_MASK_MASK () {0x1f80;}' unless defined(&_MM_MASK_MASK);
	eval 'sub _MM_MASK_INVALID () {0x80;}' unless defined(&_MM_MASK_INVALID);
	eval 'sub _MM_MASK_DENORM () {0x100;}' unless defined(&_MM_MASK_DENORM);
	eval 'sub _MM_MASK_DIV_ZERO () {0x200;}' unless defined(&_MM_MASK_DIV_ZERO);
	eval 'sub _MM_MASK_OVERFLOW () {0x400;}' unless defined(&_MM_MASK_OVERFLOW);
	eval 'sub _MM_MASK_UNDERFLOW () {0x800;}' unless defined(&_MM_MASK_UNDERFLOW);
	eval 'sub _MM_MASK_INEXACT () {0x1000;}' unless defined(&_MM_MASK_INEXACT);
	eval 'sub _MM_ROUND_MASK () {0x6000;}' unless defined(&_MM_ROUND_MASK);
	eval 'sub _MM_ROUND_NEAREST () {0x;}' unless defined(&_MM_ROUND_NEAREST);
	eval 'sub _MM_ROUND_DOWN () {0x2000;}' unless defined(&_MM_ROUND_DOWN);
	eval 'sub _MM_ROUND_UP () {0x4000;}' unless defined(&_MM_ROUND_UP);
	eval 'sub _MM_ROUND_TOWARD_ZERO () {0x6000;}' unless defined(&_MM_ROUND_TOWARD_ZERO);
	eval 'sub _MM_FLUSH_ZERO_MASK () {0x8000;}' unless defined(&_MM_FLUSH_ZERO_MASK);
	eval 'sub _MM_FLUSH_ZERO_ON () {0x8000;}' unless defined(&_MM_FLUSH_ZERO_ON);
	eval 'sub _MM_FLUSH_ZERO_OFF () {0x;}' unless defined(&_MM_FLUSH_ZERO_OFF);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_sub_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_subss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_mul_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_mulss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_div_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_divss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_sqrt_ss ( &__m128  &__A) { ( &__m128)  &__builtin_ia32_sqrtss (( &__v4sf) &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_rcp_ss ( &__m128  &__A) { ( &__m128)  &__builtin_ia32_rcpss (( &__v4sf) &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_rsqrt_ss ( &__m128  &__A) { ( &__m128)  &__builtin_ia32_rsqrtss (( &__v4sf) &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_min_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_minss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_max_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_maxss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_sub_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_subps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_mul_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_mulps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_div_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_divps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_sqrt_ps ( &__m128  &__A) { ( &__m128)  &__builtin_ia32_sqrtps (( &__v4sf) &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_rcp_ps ( &__m128  &__A) { ( &__m128)  &__builtin_ia32_rcpps (( &__v4sf) &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_rsqrt_ps ( &__m128  &__A) { ( &__m128)  &__builtin_ia32_rsqrtps (( &__v4sf) &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_min_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_minps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_max_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_maxps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_andnot_ps ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_andnps ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_or_ps ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_orps ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_xor_ps ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_xorps ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmplt_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpltss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmple_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpless (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpgt_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_movss (( &__v4sf)  &__A, ( &__v4sf)  &__builtin_ia32_cmpltss (( &__v4sf)  &__B, ( &__v4sf)  &__A)); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpge_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_movss (( &__v4sf)  &__A, ( &__v4sf)  &__builtin_ia32_cmpless (( &__v4sf)  &__B, ( &__v4sf)  &__A)); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpneq_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpneqss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpnlt_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpnltss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpnle_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpnless (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpngt_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_movss (( &__v4sf)  &__A, ( &__v4sf)  &__builtin_ia32_cmpnltss (( &__v4sf)  &__B, ( &__v4sf)  &__A)); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpnge_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_movss (( &__v4sf)  &__A, ( &__v4sf)  &__builtin_ia32_cmpnless (( &__v4sf)  &__B, ( &__v4sf)  &__A)); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpord_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpordss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpunord_ss ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpunordss (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmplt_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpltps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmple_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpleps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpgt_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpgtps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpge_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpgeps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpneq_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpneqps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpnlt_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpnltps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpnle_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpnleps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpngt_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpngtps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpnge_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpngeps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpord_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpordps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cmpunord_ps ( &__m128  &__A,  &__m128  &__B) { ( &__m128)  &__builtin_ia32_cmpunordps (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_comilt_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_comilt (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_comile_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_comile (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_comigt_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_comigt (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_comige_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_comige (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_comineq_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_comineq (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_ucomieq_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_ucomieq (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_ucomilt_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_ucomilt (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_ucomile_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_ucomile (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_ucomigt_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_ucomigt (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_ucomige_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_ucomige (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_ucomineq_ss ( &__m128  &__A,  &__m128  &__B) {  &__builtin_ia32_ucomineq (( &__v4sf) &__A, ( &__v4sf) &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvt_ss2si ( &__m128  &__A) {  &_mm_cvtss_si32 ( &__A); });
	}' unless defined(&__attribute__);
	if(defined(&__x86_64__)) {
	}
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvt_ps2pi ( &__m128  &__A) {  &_mm_cvtps_pi32 ( &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvtt_ss2si ( &__m128  &__A) {  &_mm_cvttss_si32 ( &__A); });
	}' unless defined(&__attribute__);
	if(defined(&__x86_64__)) {
	}
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvtt_ps2pi ( &__m128  &__A) {  &_mm_cvttps_pi32 ( &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvt_si2ss ( &__m128  &__A, \'int\'  &__B) {  &_mm_cvtsi32_ss ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	if(defined(&__x86_64__)) {
	}
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvt_pi2ps ( &__m128  &__A,  &__m64  &__B) {  &_mm_cvtpi32_ps ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	if(0) {
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_mm_shuffle_ps ( &__m128  &__A,  &__m128  &__B, \'int\'  &__mask) { ( &__m128)  &__builtin_ia32_shufps (( &__v4sf) &__A, ( &__v4sf) &__B,  &__mask); });
	    }' unless defined(&__attribute__);
	} else {
	    eval 'sub _mm_shuffle_ps {
	        my($A, $B, $MASK) = @_;
    		eval q((( &__m128)  &__builtin_ia32_shufps (( &__v4sf)($A), ( &__v4sf)($B), ($MASK))));
	    }' unless defined(&_mm_shuffle_ps);
	}
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_MM_GET_EXCEPTION_MASK ( &void) {  &_mm_getcsr() &  &_MM_MASK_MASK; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_MM_GET_ROUNDING_MODE ( &void) {  &_mm_getcsr() &  &_MM_ROUND_MASK; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_MM_GET_FLUSH_ZERO_MODE ( &void) {  &_mm_getcsr() &  &_MM_FLUSH_ZERO_MASK; });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_MM_SET_EXCEPTION_MASK  {  &_mm_setcsr(( &_mm_getcsr() & ~ &_MM_MASK_MASK) |  &__mask); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_MM_SET_ROUNDING_MODE  {  &_mm_setcsr(( &_mm_getcsr() & ~ &_MM_ROUND_MASK) |  &__mode); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_MM_SET_FLUSH_ZERO_MODE  {  &_mm_setcsr(( &_mm_getcsr() & ~ &_MM_FLUSH_ZERO_MASK) |  &__mode); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_set_ps1 (\'float\'  &__F) {  &_mm_set1_ps ( &__F); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_load_ps1 (\'float\'  &const * &__P) {  &_mm_load1_ps ( &__P); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_cvtss_f32 ( &__m128  &__A) {  &__builtin_ia32_vec_ext_v4sf (( &__v4sf) &__A, 0); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_mm_store_ps1 (\'float\' * &__P,  &__m128  &__A) {  &_mm_store1_ps ( &__P,  &__A); });
	}' unless defined(&__attribute__);
	if(0) {
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_mm_extract_pi16 ( &__m64  &const  &__A, \'int\'  &const  &__N) {  &__builtin_ia32_vec_ext_v4hi (( &__v4hi) &__A,  &__N); });
	    }' unless defined(&__attribute__);
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_m_pextrw ( &__m64  &const  &__A, \'int\'  &const  &__N) {  &_mm_extract_pi16 ( &__A,  &__N); });
	    }' unless defined(&__attribute__);
	} else {
	    eval 'sub _mm_extract_pi16 {
	        my($A, $N) = @_;
    		eval q( &__builtin_ia32_vec_ext_v4hi (( &__v4hi)($A), ($N)));
	    }' unless defined(&_mm_extract_pi16);
	    eval 'sub _m_pextrw {
	        my($A, $N) = @_;
    		eval q( &_mm_extract_pi16(($A), ($N)));
	    }' unless defined(&_m_pextrw);
	}
	if(0) {
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_mm_insert_pi16 ( &__m64  &const  &__A, \'int\'  &const  &__D, \'int\'  &const  &__N) { ( &__m64)  &__builtin_ia32_vec_set_v4hi (( &__v4hi) &__A,  &__D,  &__N); });
	    }' unless defined(&__attribute__);
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_m_pinsrw ( &__m64  &const  &__A, \'int\'  &const  &__D, \'int\'  &const  &__N) {  &_mm_insert_pi16 ( &__A,  &__D,  &__N); });
	    }' unless defined(&__attribute__);
	} else {
	    eval 'sub _mm_insert_pi16 {
	        my($A, $D, $N) = @_;
    		eval q((( &__m64)  &__builtin_ia32_vec_set_v4hi (( &__v4hi)($A), ($D), ($N))));
	    }' unless defined(&_mm_insert_pi16);
	    eval 'sub _m_pinsrw {
	        my($A, $D, $N) = @_;
    		eval q( &_mm_insert_pi16(($A), ($D), ($N)));
	    }' unless defined(&_m_pinsrw);
	}
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pmaxsw ( &__m64  &__A,  &__m64  &__B) {  &_mm_max_pi16 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pmaxub ( &__m64  &__A,  &__m64  &__B) {  &_mm_max_pu8 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pminsw ( &__m64  &__A,  &__m64  &__B) {  &_mm_min_pi16 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pminub ( &__m64  &__A,  &__m64  &__B) {  &_mm_min_pu8 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pmovmskb ( &__m64  &__A) {  &_mm_movemask_pi8 ( &__A); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pmulhuw ( &__m64  &__A,  &__m64  &__B) {  &_mm_mulhi_pu16 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	if(0) {
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_mm_shuffle_pi16 ( &__m64  &__A, \'int\'  &__N) { ( &__m64)  &__builtin_ia32_pshufw (( &__v4hi) &__A,  &__N); });
	    }' unless defined(&__attribute__);
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_m_pshufw ( &__m64  &__A, \'int\'  &__N) {  &_mm_shuffle_pi16 ( &__A,  &__N); });
	    }' unless defined(&__attribute__);
	} else {
	    eval 'sub _mm_shuffle_pi16 {
	        my($A, $N) = @_;
    		eval q((( &__m64)  &__builtin_ia32_pshufw (( &__v4hi)($A), ($N))));
	    }' unless defined(&_mm_shuffle_pi16);
	    eval 'sub _m_pshufw {
	        my($A, $N) = @_;
    		eval q( &_mm_shuffle_pi16 (($A), ($N)));
	    }' unless defined(&_m_pshufw);
	}
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_maskmovq ( &__m64  &__A,  &__m64  &__N, \'char\' * &__P) {  &_mm_maskmove_si64 ( &__A,  &__N,  &__P); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pavgb ( &__m64  &__A,  &__m64  &__B) {  &_mm_avg_pu8 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_pavgw ( &__m64  &__A,  &__m64  &__B) {  &_mm_avg_pu16 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	eval 'sub __attribute__ {
	    eval q((( &__always_inline__))  &_m_psadbw ( &__m64  &__A,  &__m64  &__B) {  &_mm_sad_pu8 ( &__A,  &__B); });
	}' unless defined(&__attribute__);
	if(0) {
	    eval 'sub __attribute__ {
	        eval q((( &__always_inline__))  &_mm_prefetch ( &void * &__P,  &enum  &_mm_hint  &__I) {  &__builtin_prefetch ( &__P, 0,  &__I); });
	    }' unless defined(&__attribute__);
	} else {
	    eval 'sub _mm_prefetch {
	        my($P, $I) = @_;
    		eval q( &__builtin_prefetch (($P), 0, ($I)));
	    }' unless defined(&_mm_prefetch);
	}
	eval 'sub _MM_TRANSPOSE4_PS {
	    my($row0, $row1, $row2, $row3) = @_;
    	    eval q( &do {  &__v4sf  &__r0 = ($row0),  &__r1 = ($row1),  &__r2 = ($row2),  &__r3 = ($row3);  &__v4sf  &__t0 =  &__builtin_ia32_unpcklps ( &__r0,  &__r1);  &__v4sf  &__t1 =  &__builtin_ia32_unpcklps ( &__r2,  &__r3);  &__v4sf  &__t2 =  &__builtin_ia32_unpckhps ( &__r0,  &__r1);  &__v4sf  &__t3 =  &__builtin_ia32_unpckhps ( &__r2,  &__r3); ($row0) =  &__builtin_ia32_movlhps ( &__t0,  &__t1); ($row1) =  &__builtin_ia32_movhlps ( &__t1,  &__t0); ($row2) =  &__builtin_ia32_movlhps ( &__t2,  &__t3); ($row3) =  &__builtin_ia32_movhlps ( &__t3,  &__t2); }  &while (0));
	}' unless defined(&_MM_TRANSPOSE4_PS);
	require 'emmintrin.ph';
    }
}
1;
