# NOTE: Derived from lib/Zoidberg/Fish/Commands.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Zoidberg::Fish::Commands;

#line 539 "lib/Zoidberg/Fish/Commands.pm (autosplit into blib/lib/auto/Zoidberg/Fish/Commands/symbols.al)"
sub symbols {
	no strict 'refs';
	my $self = shift;
	my ($opts, $class) = getopt 'all,a @', @_;
	error 'to many arguments' if @$class > 1;
	$class = shift(@$class)
       		|| $$self{shell}{settings}{perl}{namespace} || 'Zoidberg::Eval';
	my @sym;
	for (keys %{$class.'::'}) {
		unless ($$opts{all}) {
			next if /::/;
			next unless /[a-z]/i;
		}
		push @sym, '$'.$_ if defined ${$class.'::'.$_};
		push @sym, '@'.$_ if *{$class.'::'.$_}{ARRAY};
		push @sym, '%'.$_ if *{$class.'::'.$_}{HASH};
		push @sym, '&'.$_ if *{$class.'::'.$_}{CODE};
		push @sym, '*'.$_ if *{$class.'::'.$_}{IO};
	}
	output [sort @sym];
}

# end of Zoidberg::Fish::Commands::symbols
1;
