/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IDatabaseFactory;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisCache
implements IAnalysisCache {
    private static final int CACHE_SIZE = 5;
    private IClassPath classPath;
    private IErrorLogger errorLogger;
    private Map<Class<?>, IClassAnalysisEngine> classAnalysisEngineMap;
    private Map<Class<?>, IMethodAnalysisEngine> methodAnalysisEngineMap;
    private Map<Class<?>, IDatabaseFactory<?>> databaseFactoryMap;
    private Map<Class<?>, Map<ClassDescriptor, Object>> classAnalysisMap;
    private Map<Class<?>, Map<MethodDescriptor, Object>> methodAnalysisMap;
    private Map<Class<?>, Object> databaseMap;

    AnalysisCache(IClassPath classPath, IErrorLogger errorLogger) {
        this.classPath = classPath;
        this.errorLogger = errorLogger;
        this.classAnalysisEngineMap = new HashMap();
        this.methodAnalysisEngineMap = new HashMap();
        this.databaseFactoryMap = new HashMap();
        this.classAnalysisMap = new HashMap();
        this.methodAnalysisMap = new HashMap();
        this.databaseMap = new HashMap();
    }

    @Override
    public IClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    public <E> E getClassAnalysis(Class<E> analysisClass, ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        return AnalysisCache.analyzeClassOrMethod(this, this.classAnalysisMap, this.classAnalysisEngineMap, classDescriptor, analysisClass);
    }

    @Override
    public <E> E probeClassAnalysis(Class<E> analysisClass, ClassDescriptor classDescriptor) {
        Map<ClassDescriptor, Object> descriptorMap = this.classAnalysisMap.get(analysisClass);
        if (descriptorMap == null) {
            return null;
        }
        return (E)descriptorMap.get(classDescriptor);
    }

    @Override
    public <E> E getMethodAnalysis(Class<E> analysisClass, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        return AnalysisCache.analyzeClassOrMethod(this, this.methodAnalysisMap, this.methodAnalysisEngineMap, methodDescriptor, analysisClass);
    }

    static <DescriptorType, E> E analyzeClassOrMethod(AnalysisCache analysisCache, Map<Class<?>, Map<DescriptorType, Object>> analysisClassToDescriptorMapMap, final Map<Class<?>, ? extends IAnalysisEngine<DescriptorType>> engineMap, DescriptorType descriptor, final Class<E> analysisClass) throws CheckedAnalysisException {
        Object analysisResult;
        MapCache descriptorMap = analysisClassToDescriptorMapMap.get(analysisClass);
        if (descriptorMap == null) {
            descriptorMap = new MapCache<DescriptorType, Object>(5){
                IAnalysisEngine<DescriptorType> engine;
                {
                    super(x0);
                    this.engine = (IAnalysisEngine)engineMap.get(analysisClass);
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<DescriptorType, Object> eldest) {
                    if (this.engine.retainAnalysisResults()) {
                        return false;
                    }
                    return super.removeEldestEntry(eldest);
                }
            };
            analysisClassToDescriptorMapMap.put(analysisClass, descriptorMap);
        }
        if ((analysisResult = descriptorMap.get(descriptor)) == null) {
            IAnalysisEngine<DescriptorType> engine = engineMap.get(analysisClass);
            if (engine == null) {
                throw new IllegalArgumentException(new StringBuffer().append("No analysis engine registered to produce ").append(analysisClass.getName()).toString());
            }
            try {
                analysisResult = engine.analyze(analysisCache, descriptor);
            }
            catch (CheckedAnalysisException e) {
                analysisResult = new AnalysisError(e);
            }
            descriptorMap.put(descriptor, analysisResult);
        }
        if (analysisResult instanceof AnalysisError) {
            throw ((AnalysisError)analysisResult).exception;
        }
        return (E)analysisResult;
    }

    @Override
    public <E> void registerClassAnalysisEngine(Class<E> analysisResultType, IClassAnalysisEngine classAnalysisEngine) {
        this.classAnalysisEngineMap.put(analysisResultType, classAnalysisEngine);
    }

    @Override
    public <E> void registerMethodAnalysisEngine(Class<E> analysisResultType, IMethodAnalysisEngine methodAnalysisEngine) {
        this.methodAnalysisEngineMap.put(analysisResultType, methodAnalysisEngine);
    }

    @Override
    public <E> void registerDatabaseFactory(Class<E> databaseClass, IDatabaseFactory<E> databaseFactory) {
        this.databaseFactoryMap.put(databaseClass, databaseFactory);
    }

    @Override
    public <E> E getDatabase(Class<E> databaseClass) throws CheckedAnalysisException {
        Object database = this.databaseMap.get(databaseClass);
        if (database == null) {
            try {
                IDatabaseFactory<?> databaseFactory = this.databaseFactoryMap.get(databaseClass);
                if (databaseFactory == null) {
                    throw new IllegalArgumentException(new StringBuffer().append("No database factory registered for ").append(databaseClass.getName()).toString());
                }
                database = databaseFactory.createDatabase();
            }
            catch (CheckedAnalysisException e) {
                database = new AnalysisError(e);
            }
            this.databaseMap.put(databaseClass, database);
        }
        if (database instanceof AnalysisError) {
            throw ((AnalysisError)database).exception;
        }
        return (E)database;
    }

    @Override
    public IErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    static class AnalysisError {
        CheckedAnalysisException exception;

        public AnalysisError(CheckedAnalysisException exception) {
            this.exception = exception;
        }
    }
}

