/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.plugin.eclipse.ExtendedPreferences;
import edu.umd.cs.findbugs.workflow.Update;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsWorker {
    private static final boolean INCREMENTAL_UPDATE = false;
    public static boolean DEBUG;
    private IProgressMonitor monitor;
    private UserPreferences userPrefs;
    private ExtendedPreferences extendedPrefs;
    private IProject project;

    public FindBugsWorker(IProject project, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        try {
            this.userPrefs = FindbugsPlugin.getUserPreferences(project);
            this.extendedPrefs = FindbugsPlugin.getExtendedPreferences(project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not get selected detectors for project");
        }
    }

    public void work(Collection files, boolean incremental) throws CoreException {
        if (files == null) {
            FindbugsPlugin.getDefault().logError("No files to build");
            return;
        }
        String findBugsHome = FindbugsPlugin.getFindBugsEnginePluginLocation();
        if (DEBUG) {
            FindbugsPlugin.getDefault().logInfo(new StringBuffer().append("Looking for detectors in: ").append(findBugsHome).toString());
        }
        System.setProperty("findbugs.home", findBugsHome);
        Set<IPath> outLocations = this.createOutputLocations();
        Project findBugsProject = new Project();
        Iterator iter = files.iterator();
        HashMap<File, String> outputFiles = new HashMap<File, String>();
        while (iter.hasNext()) {
            IResource res = (IResource)iter.next();
            if (res == null) continue;
            if (Util.isJavaArtifact(res)) {
                res.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
            }
            IPath location = res.getLocation();
            if (Util.isClassFile(res) && this.containsIn(outLocations, location)) {
                String fileName = location.toOSString();
                res.refreshLocal(2, null);
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Resource: ").append(fileName).append(": in sync: ").append(res.isSynchronized(2)).toString());
                }
                findBugsProject.addFile(fileName);
                continue;
            }
            if (!Util.isJavaFile(res)) continue;
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)res));
            if (cu == null) {
                if (!DEBUG) continue;
                FindbugsPlugin.getDefault().logError(new StringBuffer().append("NULL Compilation Unit for ").append(res.getName()).toString());
                continue;
            }
            IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)cu.getAncestor(3);
            if (pkgRoot == null) {
                if (!DEBUG) continue;
                FindbugsPlugin.getDefault().logError(new StringBuffer().append("NULL Package Root for: ").append(res.getName()).toString());
                continue;
            }
            IClasspathEntry cpe = pkgRoot.getRawClasspathEntry();
            if (cpe == null) {
                if (!DEBUG) continue;
                FindbugsPlugin.getDefault().logError(new StringBuffer().append("NULL Classpath Entry for: ").append(res.getName()).toString());
                continue;
            }
            IPath outLocation = this.getAbsoluteOutputLocation(pkgRoot, cpe);
            IPath relativePath = this.getRelativeFilePath(res, cpe);
            IPath pkgPath = relativePath.removeLastSegments(1);
            String fName = relativePath.lastSegment();
            fName = fName.substring(0, fName.lastIndexOf(46));
            IPath clzLocation = outLocation.append(pkgPath);
            String exp = new StringBuffer().append(fName).append("\\.class").append("|").append(fName).append("\\$.*\\.class").toString();
            File clzDir = clzLocation.toFile();
            String oldExp = (String)outputFiles.get(clzDir);
            if (oldExp != null) {
                exp = new StringBuffer().append(oldExp).append("|").append(exp).toString();
            }
            outputFiles.put(clzDir, exp);
        }
        this.addOutputFiles(findBugsProject, outputFiles);
        outputFiles.clear();
        Reporter bugReporter = new Reporter(this.project, this.monitor, findBugsProject);
        bugReporter.setPriorityThreshold(3);
        String[] classPathEntries = this.createClassPathEntries();
        for (int i = 0; i < classPathEntries.length; ++i) {
            findBugsProject.addAuxClasspathEntry(classPathEntries[i]);
        }
        FindBugs2 engine = new FindBugs2();
        engine.setBugReporter((BugReporter)bugReporter);
        engine.setProject(findBugsProject);
        engine.setProgressCallback((FindBugsProgress)bugReporter);
        engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        FindBugs2 findBugs = engine;
        findBugs.setUserPreferences(this.userPrefs);
        this.configureExtended((IFindBugsEngine)findBugs);
        try {
            findBugs.execute();
            this.updateBugCollection(findBugsProject, bugReporter, incremental);
            Iterator it = files.iterator();
            if (it.hasNext()) {
                IResource res = (IResource)it.next();
                MarkerUtil.redisplayMarkersWithoutProgressDialog(res.getProject());
            }
        }
        catch (InterruptedException e) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logException(e, "Worker interrupted");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs analysis");
        }
    }

    private void addOutputFiles(Project findBugsProject, Map<File, String> outputFiles) {
        for (Map.Entry<File, String> entry : outputFiles.entrySet()) {
            File[] clzs;
            File clzDir = entry.getKey();
            final Pattern pat = Pattern.compile(entry.getValue());
            if (!clzDir.exists() || !clzDir.isDirectory()) continue;
            for (File cl : clzs = clzDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return pat.matcher(name).find();
                }
            })) {
                findBugsProject.addFile(cl.getAbsolutePath());
            }
        }
    }

    private IPath getRelativeFilePath(IResource res, IClasspathEntry cpe) {
        IPath cpePath = cpe.getPath();
        IPath javaFilePath = res.getFullPath();
        IPath relativePath = javaFilePath.removeFirstSegments(cpePath.matchingFirstSegments(javaFilePath));
        return relativePath;
    }

    private IPath getAbsoluteOutputLocation(IPackageFragmentRoot pkgRoot, IClasspathEntry cpe) throws JavaModelException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath outLocation = cpe.getOutputLocation();
        IJavaProject proj = pkgRoot.getJavaProject();
        if (outLocation == null) {
            outLocation = proj.getOutputLocation();
        }
        IResource resource = root.findMember(outLocation);
        return resource.getLocation();
    }

    private void updateBugCollection(Project findBugsProject, Reporter bugReporter, boolean incremental) throws CoreException, IOException, DocumentException {
        SortedBugCollection oldBugCollection = FindbugsPlugin.getBugCollection(this.project, this.monitor);
        SortedBugCollection newBugCollection = bugReporter.getBugCollection();
        SortedBugCollection resultCollection = this.mergeBugCollections(oldBugCollection, newBugCollection, incremental);
        resultCollection.setTimestamp(System.currentTimeMillis());
        FindbugsPlugin.storeBugCollection(this.project, resultCollection, findBugsProject, this.monitor);
    }

    private SortedBugCollection mergeBugCollections(SortedBugCollection firstCollection, SortedBugCollection secondCollection, boolean incremental) {
        Update update = new Update();
        return (SortedBugCollection)update.mergeCollections((BugCollection)firstCollection, (BugCollection)secondCollection, false, incremental);
    }

    private void updateBugCollectionIncrementally(Reporter bugReporter, SortedBugCollection oldBugCollection, SortedBugCollection newBugCollection) {
        throw new UnsupportedOperationException();
    }

    private void updateBugCollectionDestructively(Reporter bugReporter, SortedBugCollection oldBugCollection, SortedBugCollection newBugCollection) {
        ArrayList<BugInstance> toRemove = new ArrayList<BugInstance>();
        if (oldBugCollection != null) {
            Set<String> analyzedClassNameSet = bugReporter.getAnalyzedClassNames();
            for (BugInstance oldWarning : oldBugCollection) {
                ClassAnnotation warningClass = oldWarning.getPrimaryClass();
                if (warningClass == null || !analyzedClassNameSet.contains(warningClass.getClassName())) continue;
                toRemove.add(oldWarning);
            }
            for (BugInstance removeMe : toRemove) {
                oldBugCollection.remove(removeMe);
            }
        } else {
            oldBugCollection = new SortedBugCollection();
        }
        for (BugInstance newWarning : newBugCollection) {
            oldBugCollection.add(newWarning);
        }
    }

    private void configureExtended(IFindBugsEngine findBugs) {
        String filterName;
        IFile file;
        findBugs.setAnalysisFeatureSettings(this.extendedPrefs.getAnalysisFeatureSettings());
        for (String fileName : this.extendedPrefs.getIncludeFilterFiles()) {
            file = this.project.getFile(fileName);
            if (!file.exists()) continue;
            filterName = file.getLocation().toOSString();
            try {
                findBugs.addFilter(filterName, true);
            }
            catch (RuntimeException e) {
                FindbugsPlugin.getDefault().logException(e, new StringBuffer().append("Error while loading filter \"").append(filterName).append("\".").toString());
            }
            catch (FilterException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), new StringBuffer().append("Error while loading filter \"").append(filterName).append("\".").toString());
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, new StringBuffer().append("Error while reading filter \"").append(filterName).append("\".").toString());
            }
        }
        for (String fileName : this.extendedPrefs.getExcludeFilterFiles()) {
            file = this.project.getFile(fileName);
            if (!file.exists()) continue;
            filterName = file.getLocation().toOSString();
            try {
                findBugs.addFilter(filterName, false);
            }
            catch (FilterException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), new StringBuffer().append("Error while loading filter \"").append(filterName).append("\".").toString());
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, new StringBuffer().append("Error while reading filter \"").append(filterName).append("\".").toString());
            }
        }
    }

    private String[] createClassPathEntries() {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        catch (CoreException e) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not compute classpath for project");
            }
            return new String[0];
        }
    }

    private Set<IPath> createOutputLocations() throws CoreException {
        IPath def;
        IResource resource;
        HashSet<IPath> set = new HashSet<IPath>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        if (javaProject.exists() && javaProject.getProject().isOpen()) {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            for (int i = 0; i < entries.length; ++i) {
                IResource resource2;
                IClasspathEntry classpathEntry = entries[i];
                IPath path = classpathEntry.getOutputLocation();
                if (path == null || classpathEntry.getEntryKind() != 3 || (resource2 = root.findMember(path)) == null) continue;
                set.add(resource2.getLocation());
            }
        }
        if ((resource = root.findMember(def = javaProject.getOutputLocation())) != null) {
            IPath location = resource.getLocation();
            set.add(location);
        }
        return set;
    }

    private boolean containsIn(Set<IPath> outputLocations, IPath path) {
        for (IPath dir : outputLocations) {
            if (!dir.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }
}

