/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.subscriber.ShowHistorySynchronizeOperation;

public class ShowHistorySynchronizeAction
extends SynchronizeModelAction {
    public ShowHistorySynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                IStructuredSelection selection = ShowHistorySynchronizeAction.this.getStructuredSelection();
                if (selection.size() != 1) {
                    return false;
                }
                ISynchronizeModelElement element = (ISynchronizeModelElement)selection.getFirstElement();
                IResource resource = element.getResource();
                if (resource == null) {
                    return false;
                }
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    return !resource.exists() || svnResource.getStatus().isManaged() && !svnResource.getStatus().isAdded();
                }
                catch (SVNException sVNException) {
                    return false;
                }
            }
        };
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        ISynchronizeModelElement element = (ISynchronizeModelElement)this.getStructuredSelection().getFirstElement();
        IResource resource = element.getResource();
        if (!resource.exists()) {
            try {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                return new ShowHistorySynchronizeOperation(configuration, elements, svnResource.getLatestRemoteResource());
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }
        return new ShowHistorySynchronizeOperation(configuration, elements, resource);
    }
}

