/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.sse.core.internal.Logger;

public class JarUtilities {
    public static final String JSP11_TAGLIB = "META-INF/taglib.tld";

    public static void closeJarFile(ZipFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException ioe) {
            Logger.logException("JarUtilities: Could not close file " + file.getName(), ioe);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static InputStream getCachedInputStream(String jarFilename, String entryName) {
        File testFile = new File(jarFilename);
        if (!testFile.exists()) {
            return null;
        }
        ByteArrayInputStream cache = null;
        ZipFile jarfile = null;
        try {
            jarfile = new ZipFile(jarFilename);
        }
        catch (IOException ioExc) {
            Logger.logException("JarUtilities: " + jarFilename, ioExc);
            JarUtilities.closeJarFile(jarfile);
        }
        if (jarfile == null) return cache;
        try {
            ZipEntry zentry = jarfile.getEntry(entryName);
            if (zentry != null) {
                InputStream entryInputStream = null;
                try {
                    entryInputStream = jarfile.getInputStream(zentry);
                }
                catch (IOException ioExc) {
                    Logger.logException("JarUtilities: " + jarFilename, ioExc);
                }
                if (entryInputStream != null) {
                    ByteArrayOutputStream buffer = null;
                    buffer = zentry.getSize() > 0L ? new ByteArrayOutputStream((int)zentry.getSize()) : new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    try {
                        try {
                            while (true) {
                                int c;
                                if ((c = entryInputStream.read(bytes)) < 0) {
                                    cache = new ByteArrayInputStream(buffer.toByteArray());
                                    JarUtilities.closeJarFile(jarfile);
                                }
                                buffer.write(bytes, 0, c);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        try {
                            entryInputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        Object var10_14 = null;
                        try {}
                        catch (IOException iOException) {}
                        entryInputStream.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            JarUtilities.closeJarFile(jarfile);
            throw throwable;
        }
        {
            Object var12_17 = null;
        }
        JarUtilities.closeJarFile(jarfile);
        return cache;
    }

    public static String[] getEntryNames(IResource jarResource) {
        if (jarResource == null || jarResource.getLocation() == null) {
            return new String[0];
        }
        return JarUtilities.getEntryNames(jarResource.getLocation().toString());
    }

    public static String[] getEntryNames(String jarFilename) {
        return JarUtilities.getEntryNames(jarFilename, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getEntryNames(String jarFilename, boolean excludeDirectories) {
        ZipFile jarfile = null;
        ArrayList<String> entryNames = new ArrayList<String>();
        try {
            try {
                jarfile = new ZipFile(jarFilename);
                Enumeration<? extends ZipEntry> entries = jarfile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry z = entries.nextElement();
                    if (z.isDirectory() && excludeDirectories) continue;
                    entryNames.add(z.getName());
                }
            }
            catch (ZipException zExc) {
                Logger.log(2, "JarUtilities ZipException: " + jarFilename + " " + zExc.getMessage());
            }
            catch (IOException ioExc) {
                Logger.log(2, "JarUtilities IOException: " + jarFilename + " " + ioExc.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            JarUtilities.closeJarFile(jarfile);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        JarUtilities.closeJarFile(jarfile);
        return entryNames.toArray(new String[0]);
    }

    public static InputStream getInputStream(IResource jarResource, String entryName) {
        if (jarResource == null) {
            return null;
        }
        return JarUtilities.getInputStream(jarResource.getLocation().toString(), entryName);
    }

    public static InputStream getInputStream(String jarFilename, String entryName) {
        if (jarFilename == null || jarFilename.length() < 1 || entryName == null || entryName.length() < 1) {
            return null;
        }
        String internalName = null;
        internalName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        return JarUtilities.getCachedInputStream(jarFilename, internalName);
    }
}

