/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.UpdateCore;

public class InstallRegistry
extends Properties {
    private static final long serialVersionUID = 1L;
    private File file = null;
    private static final String REGISTRY = "registry";
    private static InstallRegistry instance;
    private HashMap justInstalledPlugins = new HashMap();

    private InstallRegistry() {
        String configFile = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation().getFile();
        this.file = new File(configFile);
        this.file = this.file.getParentFile();
        this.file = new File(this.file, REGISTRY);
        this.restore();
    }

    public static InstallRegistry getInstance() {
        if (instance == null) {
            instance = new InstallRegistry();
        }
        return instance;
    }

    public boolean restore() {
        boolean loaded;
        block16: {
            FileInputStream in;
            block15: {
                in = null;
                loaded = false;
                this.clear();
                if (!this.file.exists()) {
                    return loaded;
                }
                try {
                    try {
                        in = new FileInputStream(this.file);
                        super.load(in);
                        loaded = true;
                    }
                    catch (IOException e) {
                        UpdateCore.log(e);
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                break block16;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return loaded;
    }

    public synchronized boolean save() {
        boolean ret;
        block15: {
            FileOutputStream out;
            block14: {
                out = null;
                ret = false;
                try {
                    try {
                        out = new FileOutputStream(this.file);
                        super.store(out, "This is a generated file; do not edit.");
                        ret = true;
                    }
                    catch (IOException e) {
                        UpdateCore.log(e);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    break block15;
                }
                catch (IOException iOException) {}
                break block15;
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    public static synchronized void registerFeature(IFeature feature) {
        String name = "feature_" + feature.getVersionedIdentifier();
        if (InstallRegistry.getInstance().get(name) == null) {
            InstallRegistry.getInstance().put(name, name);
            InstallRegistry.getInstance().save();
        }
    }

    public static synchronized void registerPlugin(IPluginEntry pluginEntry) {
        String name = "plugin_" + pluginEntry.getVersionedIdentifier();
        if (InstallRegistry.getInstance().get(name) == null) {
            InstallRegistry.getInstance().put(name, name);
            InstallRegistry.getInstance().save();
        }
        InstallRegistry.getInstance().justInstalledPlugins.put(name, name);
    }

    public static synchronized void unregisterFeature(IFeature feature) {
        String name = "feature_" + feature.getVersionedIdentifier();
        InstallRegistry.getInstance().remove(name);
    }

    public static synchronized void unregisterPlugin(IPluginEntry pluginEntry) {
        String name = "plugin_" + pluginEntry.getVersionedIdentifier();
        InstallRegistry.getInstance().remove(name);
        InstallRegistry.getInstance().justInstalledPlugins.remove(name);
    }

    public boolean isPluginJustInstalled(IPluginEntry pluginEntry) {
        String name = "plugin_" + pluginEntry.getVersionedIdentifier();
        return InstallRegistry.getInstance().justInstalledPlugins.get(name) != null;
    }

    public static void cleanup() {
        InstallRegistry.getInstance().justInstalledPlugins.clear();
    }
}

