/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.CheatSheetViewerFactory;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.cheatsheets.state.MementoStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskEditor;

public class CheatsheetTaskEditor
extends TaskEditor {
    private CheatSheetViewer viewer;
    private IEditableTask task;

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.viewer = (CheatSheetViewer)CheatSheetViewerFactory.createCheatSheetView();
        this.viewer.createPartControl(parent);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setInput(IEditableTask task, IMemento memento) {
        this.task = task;
        Dictionary params = task.getParameters();
        String id = (String)params.get("id");
        String path = (String)params.get("path");
        boolean showIntro = true;
        String showIntroParam = (String)params.get("showIntro");
        if (showIntroParam != null) {
            showIntro = showIntroParam.equalsIgnoreCase("true");
        }
        MementoStateManager stateManager = new MementoStateManager(memento, task.getCompositeCheatSheet().getCheatSheetManager());
        if (path != null) {
            try {
                URL url = task.getInputUrl(path);
                if (id == null) {
                    id = task.getId();
                }
                this.viewer.setInput(id, task.getName(), url, stateManager);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
        } else {
            this.viewer.setInput(id, stateManager);
        }
        if (!showIntro) {
            this.viewer.advanceIntroItem();
        }
        this.viewer.addListener(new TaskListener());
    }

    public void saveState(IMemento memento) {
        this.viewer.saveState(memento);
    }

    private class TaskListener
    extends CheatSheetListener {
        private TaskListener() {
        }

        public void cheatSheetEvent(ICheatSheetEvent event) {
            if (event.getEventType() == 4) {
                CheatsheetTaskEditor.this.task.complete();
            }
        }
    }
}

