/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionRemoveMarker
extends MarkerSelectionProviderAction {
    private IWorkbenchPart part;

    public ActionRemoveMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, MarkerMessages.deleteAction_title);
        this.part = part;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setToolTipText(MarkerMessages.deleteAction_tooltip);
        this.setEnabled(false);
    }

    public void run() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker[] markers = ActionRemoveMarker.this.getSelectedMarkers();
                    int i = 0;
                    while (i < markers.length) {
                        markers[i].delete();
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)MarkerMessages.RemoveMarker_errorTitle, null, (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object obj : selection) {
            if (!(obj instanceof ConcreteMarker)) {
                return;
            }
            if (Util.isEditable(((ConcreteMarker)obj).getMarker())) continue;
            return;
        }
        this.setEnabled(true);
    }
}

