/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.util.Util;
import gnu.java.security.x509.X500DistinguishedName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class GenKeyCmd
extends Command {
    private static final Logger log = Logger.getLogger(GenKeyCmd.class$("gnu.classpath.tools.keytool.GenKeyCmd").getName());
    private static final int DEFAULT_KEY_SIZE = 1024;
    protected String _alias;
    protected String _keyAlgorithm;
    protected String _keySizeStr;
    protected String _sigAlgorithm;
    protected String _dName;
    protected String _password;
    protected String _validityStr;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private int keySize;
    private X500DistinguishedName distinguishedName;
    private Parser cmdOptionsParser;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setKeyalg(String string) {
        this._keyAlgorithm = string;
    }

    public void setKeysize(String string) {
        this._validityStr = string;
    }

    public void setSigalg(String string) {
        this._sigAlgorithm = string;
    }

    public void setDname(String string) {
        this._dName = string;
    }

    public void setKeypass(String string) {
        this._password = string;
    }

    public void setValidity(String string) {
        this._validityStr = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(true, this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordParam(this._password);
        this.setAlgorithmParams(this._keyAlgorithm, this._sigAlgorithm);
        this.setKeySize(this._keySizeStr);
        this.setDName(this._dName);
        this.setValidityParam(this._validityStr);
        if (Configuration.DEBUG) {
            log.fine("-genkey handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -keyalg=" + this.keyPairGenerator.getAlgorithm());
            log.fine("  -keysize=" + this.keySize);
            log.fine("  -sigalg=" + this.signatureAlgorithm.getAlgorithm());
            log.fine("  -dname=" + this.distinguishedName);
            log.fine("  -validity=" + this.validityInDays);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException, KeyStoreException, InvalidKeyException, SignatureException, IOException, NoSuchAlgorithmException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
            log.fine("About to generate key-pair...");
        }
        this.keyPairGenerator.initialize(this.keySize);
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (Configuration.DEBUG) {
            log.fine("About to generate a self-signed certificate...");
        }
        byte[] byArray = this.getSelfSignedCertificate(this.distinguishedName, publicKey, privateKey);
        if (Configuration.DEBUG) {
            log.fine(Util.dumpString((byte[])byArray, (String)"derBytes "));
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        Certificate[] certificateArray = new Certificate[]{certificate};
        if (Configuration.DEBUG) {
            log.fine("About to store newly generated material in key store...");
        }
        this.store.setKeyEntry(this.alias, privateKey, this.keyPasswordChars, certificateArray);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("genkey", true);
        classpathToolParser.setHeader(Messages.getString("GenKeyCmd.57"));
        classpathToolParser.setFooter(Messages.getString("GenKeyCmd.58"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("GenKeyCmd.59"));
        optionGroup.add(new Option(this, "alias", Messages.getString("GenKeyCmd.60"), Messages.getString("GenKeyCmd.61")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "keyalg", Messages.getString("GenKeyCmd.62"), Messages.getString("GenKeyCmd.63")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._keyAlgorithm = string;
            }
        });
        optionGroup.add(new Option(this, "keysize", Messages.getString("GenKeyCmd.64"), Messages.getString("GenKeyCmd.65")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._keySizeStr = string;
            }
        });
        optionGroup.add(new Option(this, "sigalg", Messages.getString("GenKeyCmd.66"), Messages.getString("GenKeyCmd.63")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._sigAlgorithm = string;
            }
        });
        optionGroup.add(new Option(this, "dname", Messages.getString("GenKeyCmd.68"), Messages.getString("GenKeyCmd.69")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._dName = string;
            }
        });
        optionGroup.add(new Option(this, "keypass", Messages.getString("GenKeyCmd.70"), Messages.getString("GenKeyCmd.71")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._password = string;
            }
        });
        optionGroup.add(new Option(this, "validity", Messages.getString("GenKeyCmd.72"), Messages.getString("GenKeyCmd.73")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._validityStr = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("GenKeyCmd.74"), Messages.getString("GenKeyCmd.75")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("GenKeyCmd.76"), Messages.getString("GenKeyCmd.77")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("GenKeyCmd.78"), Messages.getString("GenKeyCmd.71")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("GenKeyCmd.80"), Messages.getString("GenKeyCmd.81")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("GenKeyCmd.82")){
            private /* synthetic */ GenKeyCmd this$0;
            {
                this.this$0 = genKeyCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private void setKeySize(String string) {
        if (string == null || string.trim().length() == 0) {
            this.keySize = 1024;
        } else {
            string = string.trim();
            this.keySize = Integer.parseInt(string);
            if (this.keySize < 1) {
                throw new IllegalArgumentException(Messages.getString("GenKeyCmd.54"));
            }
        }
    }

    private void setDName(String string) throws IOException, UnsupportedCallbackException {
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
        } else {
            String string2 = Messages.getString("GenKeyCmd.0");
            String string3 = Messages.getString("GenKeyCmd.6");
            String string4 = Messages.getString("GenKeyCmd.7");
            String string5 = Messages.getString("GenKeyCmd.8");
            String string6 = Messages.getString("GenKeyCmd.9");
            String string7 = Messages.getString("GenKeyCmd.10");
            String string8 = Messages.getFormattedString("GenKeyCmd.11", string3);
            String string9 = Messages.getString("GenKeyCmd.13");
            String string10 = Messages.getFormattedString("GenKeyCmd.14", string4);
            String string11 = Messages.getFormattedString("GenKeyCmd.16", string5);
            String string12 = Messages.getFormattedString("GenKeyCmd.18", string6);
            TextOutputCallback textOutputCallback = new TextOutputCallback(0, string2);
            TextInputCallback textInputCallback = new TextInputCallback(string7);
            TextInputCallback textInputCallback2 = new TextInputCallback(string8, string3);
            TextInputCallback textInputCallback3 = new TextInputCallback(string9);
            TextInputCallback textInputCallback4 = new TextInputCallback(string10, string4);
            TextInputCallback textInputCallback5 = new TextInputCallback(string11, string5);
            TextInputCallback textInputCallback6 = new TextInputCallback(string12, string6);
            this.getCallbackHandler().handle(new Callback[]{textOutputCallback, textInputCallback, textInputCallback2, textInputCallback3, textInputCallback4, textInputCallback5, textInputCallback6});
            StringBuilder stringBuilder = new StringBuilder();
            string = this.parseUserPrompt(textInputCallback);
            if (string != null && string.length() > 0) {
                stringBuilder.append("CN=").append(string);
            }
            if ((string = this.parseUserPrompt(textInputCallback2)) != null && string.length() > 0) {
                stringBuilder.append(",O=").append(string);
            }
            if ((string = this.parseUserPrompt(textInputCallback3)) != null && string.length() > 0) {
                stringBuilder.append(",OU=").append(string.trim());
            }
            if ((string = this.parseUserPrompt(textInputCallback4)) != null && string.length() > 0) {
                stringBuilder.append(",L=").append(string.trim());
            }
            if ((string = this.parseUserPrompt(textInputCallback5)) != null && string.length() > 0) {
                stringBuilder.append(",ST=").append(string.trim());
            }
            if ((string = this.parseUserPrompt(textInputCallback6)) != null && string.length() > 0) {
                stringBuilder.append(",C=").append(string.trim());
            }
            string = stringBuilder.toString().trim();
        }
        if (Configuration.DEBUG) {
            log.fine("dName=[" + string + "]");
        }
        this.distinguishedName = new X500DistinguishedName(string);
    }

    private String parseUserPrompt(TextInputCallback textInputCallback) {
        Object object = textInputCallback.getText();
        object = object == null || ((String)object).trim().length() == 0 ? textInputCallback.getDefaultText() : (((String)object).trim().equals(".") ? null : ((String)object).trim());
        return object;
    }

    GenKeyCmd() {
    }
}

