/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.FlavorMap;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.TooManyListenersException;

public class DropTarget
implements DropTargetListener,
EventListener,
Serializable {
    private static final long serialVersionUID = -6283860791671019047L;
    private Component component;
    private FlavorMap flavorMap;
    private int actions;
    private DropTargetPeer peer;
    private DropTargetContext dropTargetContext;
    private DropTargetListener dropTargetListener;
    private DropTargetAutoScroller autoscroller;
    private boolean active;

    private /* synthetic */ void finit$() {
        this.active = true;
    }

    public DropTarget() {
        this(null, 0, null, true, null);
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) {
        this(component, 0, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener) {
        this(component, n, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl) {
        this(component, n, dropTargetListener, bl, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl, FlavorMap flavorMap) {
        this.finit$();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.setComponent(component);
        this.setDefaultActions(n);
        this.dropTargetListener = dropTargetListener;
        this.flavorMap = flavorMap;
        this.setActive(bl);
        if (component != null) {
            component.setDropTarget(this);
        }
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setDefaultActions(int n) {
        this.actions = n;
    }

    public int getDefaultActions() {
        return this.actions;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.dropTargetListener != null) {
            throw new TooManyListenersException();
        }
        this.dropTargetListener = dropTargetListener;
    }

    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener = null;
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener.dragEnter(dropTargetDragEvent);
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener.dragOver(dropTargetDragEvent);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener.dropActionChanged(dropTargetDragEvent);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener.dragExit(dropTargetEvent);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener.drop(dropTargetDropEvent);
        }
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public void setFlavorMap(FlavorMap flavorMap) {
        this.flavorMap = flavorMap;
    }

    public void addNotify(ComponentPeer componentPeer) {
        for (Component component = this.component; component != null && componentPeer instanceof LightweightPeer; component = component.getParent()) {
            componentPeer = component.getPeer();
        }
        if (componentPeer instanceof DropTargetPeer) {
            this.peer = (DropTargetPeer)((Object)componentPeer);
            this.peer.addDropTarget(this);
        } else {
            this.peer = null;
        }
    }

    public void removeNotify(ComponentPeer componentPeer) {
        this.peer.removeDropTarget(this);
        this.peer = null;
        componentPeer = null;
    }

    public DropTargetContext getDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = this.createDropTargetContext();
        }
        return this.dropTargetContext;
    }

    protected DropTargetContext createDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = new DropTargetContext(this);
        }
        return this.dropTargetContext;
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component component, Point point) {
        if (this.autoscroller == null) {
            this.autoscroller = new DropTargetAutoScroller(component, point);
        }
        return this.autoscroller;
    }

    protected void initializeAutoscrolling(Point point) {
        this.createDropTargetAutoScroller(this.component, point);
    }

    protected void updateAutoscroll(Point point) {
        if (this.autoscroller != null) {
            this.autoscroller.updateLocation(point);
        }
    }

    protected void clearAutoscroll() {
        this.autoscroller = null;
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Point point;

        protected DropTargetAutoScroller(Component component, Point point) {
            this.component = component;
            this.point = point;
        }

        protected void updateLocation(Point point) {
            this.point = point;
        }

        protected void stop() throws NotImplementedException {
        }

        public void actionPerformed(ActionEvent actionEvent) throws NotImplementedException {
        }
    }
}

