/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import gnu.java.util.EmptyEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    static final int ENDNRD = 4;
    private final String name;
    private final RandomAccessFile raf;
    private LinkedHashMap entries;
    private boolean closed;

    private /* synthetic */ void finit$() {
        this.closed = false;
    }

    private RandomAccessFile openFile(String string, File file) throws ZipException, IOException {
        try {
            if (string != null) {
                return new RandomAccessFile(string, "r");
            }
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            ZipException zipException = new ZipException(fileNotFoundException.getMessage());
            zipException.initCause(fileNotFoundException);
            throw zipException;
        }
    }

    public ZipFile(String string) throws ZipException, IOException {
        this.finit$();
        this.raf = this.openFile(string, null);
        this.name = string;
        this.checkZipFile();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this.finit$();
        this.raf = this.openFile(null, file);
        this.name = file.getPath();
        this.checkZipFile();
    }

    public ZipFile(File file, int n) throws ZipException, IOException {
        this.finit$();
        if (n != 1 && n != 5) {
            throw new IllegalArgumentException("invalid mode");
        }
        if ((n & 4) != 0) {
            file.deleteOnExit();
        }
        this.raf = this.openFile(null, file);
        this.name = file.getPath();
        this.checkZipFile();
    }

    private void checkZipFile() throws ZipException {
        boolean bl = false;
        try {
            byte[] byArray = new byte[4];
            this.raf.readFully(byArray);
            int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
            bl = (long)n == 67324752L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ZipException("Not a valid zip file");
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ZipFile has closed: " + this.name);
        }
    }

    private void readEntries() throws ZipException, IOException {
        PartialInputStream partialInputStream = new PartialInputStream(this.raf, 4096);
        long l = this.raf.length() - (long)22;
        long l2 = Math.max(0L, l - 65536L);
        do {
            if (l < l2) {
                throw new ZipException("central directory not found, probably not a zip file: " + this.name);
            }
            partialInputStream.seek(l--);
        } while ((long)partialInputStream.readLeInt() != 101010256L);
        if (partialInputStream.skip(6) != (long)6) {
            throw new EOFException(this.name);
        }
        int n = partialInputStream.readLeShort();
        if (partialInputStream.skip(4) != (long)4) {
            throw new EOFException(this.name);
        }
        int n2 = partialInputStream.readLeInt();
        this.entries = new LinkedHashMap(n + n / 2);
        partialInputStream.seek(n2);
        for (int i = 0; i < n; ++i) {
            if ((long)partialInputStream.readLeInt() != 33639248L) {
                throw new ZipException("Wrong Central Directory signature: " + this.name);
            }
            partialInputStream.skip(6);
            int n3 = partialInputStream.readLeShort();
            int n4 = partialInputStream.readLeInt();
            int n5 = partialInputStream.readLeInt();
            int n6 = partialInputStream.readLeInt();
            int n7 = partialInputStream.readLeInt();
            int n8 = partialInputStream.readLeShort();
            int n9 = partialInputStream.readLeShort();
            int n10 = partialInputStream.readLeShort();
            partialInputStream.skip(8);
            int n11 = partialInputStream.readLeInt();
            String string = partialInputStream.readString(n8);
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(n3);
            zipEntry.setCrc((long)n5 & 0xFFFFFFFFL);
            zipEntry.setSize((long)n7 & 0xFFFFFFFFL);
            zipEntry.setCompressedSize((long)n6 & 0xFFFFFFFFL);
            zipEntry.setDOSTime(n4);
            if (n9 > 0) {
                byte[] byArray = new byte[n9];
                partialInputStream.readFully(byArray);
                zipEntry.setExtra(byArray);
            }
            if (n10 > 0) {
                zipEntry.setComment(partialInputStream.readString(n10));
            }
            zipEntry.offset = n11;
            this.entries.put(string, zipEntry);
        }
    }

    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        if (randomAccessFile == null) {
            return;
        }
        RandomAccessFile randomAccessFile2 = randomAccessFile;
        synchronized (randomAccessFile2) {
            try {
                this.closed = true;
                this.entries = null;
                randomAccessFile.close();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed && this.raf != null) {
            this.close();
        }
    }

    public Enumeration entries() {
        this.checkClosed();
        try {
            return new ZipEntryEnumeration(this.getEntries().values().iterator());
        }
        catch (IOException iOException) {
            return EmptyEnumeration.getInstance();
        }
    }

    private LinkedHashMap getEntries() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                this.checkClosed();
                if (this.entries == null) {
                    this.readEntries();
                }
                LinkedHashMap linkedHashMap = this.entries;
                Object var3_3 = null;
                return linkedHashMap;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public ZipEntry getEntry(String string) {
        this.checkClosed();
        try {
            LinkedHashMap linkedHashMap = this.getEntries();
            ZipEntry zipEntry = (ZipEntry)linkedHashMap.get(string);
            if (zipEntry == null && !string.endsWith("/")) {
                zipEntry = (ZipEntry)linkedHashMap.get(string + '/');
            }
            if (zipEntry != null) {
                return new ZipEntry(zipEntry, string);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.checkClosed();
        LinkedHashMap linkedHashMap = this.getEntries();
        String string = zipEntry.getName();
        ZipEntry zipEntry2 = (ZipEntry)linkedHashMap.get(string);
        if (zipEntry2 == null) {
            return null;
        }
        PartialInputStream partialInputStream = new PartialInputStream(this.raf, 1024);
        partialInputStream.seek(zipEntry2.offset);
        if ((long)partialInputStream.readLeInt() != 67324752L) {
            throw new ZipException("Wrong Local header signature: " + string);
        }
        partialInputStream.skip(4);
        if (zipEntry2.getMethod() != partialInputStream.readLeShort()) {
            throw new ZipException("Compression method mismatch: " + string);
        }
        partialInputStream.skip(16);
        int n = partialInputStream.readLeShort();
        int n2 = partialInputStream.readLeShort();
        partialInputStream.skip(n + n2);
        partialInputStream.setLength(zipEntry2.getCompressedSize());
        int n3 = zipEntry2.getMethod();
        switch (n3) {
            case 0: {
                return partialInputStream;
            }
            case 8: {
                partialInputStream.addDummyByte();
                Inflater inflater = new Inflater(true);
                int n4 = (int)zipEntry.getSize();
                return new InflaterInputStream(this, n4, inflater, partialInputStream, inflater){
                    private /* synthetic */ ZipFile this$0;
                    private /* synthetic */ int val$sz;
                    private /* synthetic */ Inflater val$inf;
                    {
                        this.this$0 = zipFile;
                        super(partialInputStream, inflater2);
                        this.finit$(n, inflater);
                    }

                    private /* synthetic */ void finit$(int n, Inflater inflater) {
                        this.val$inf = inflater;
                        this.val$sz = n;
                    }

                    public int available() throws IOException {
                        if (this.val$sz == -1) {
                            return super.available();
                        }
                        if (super.available() != 0) {
                            return this.val$sz - this.val$inf.getTotalOut();
                        }
                        return 0;
                    }
                };
            }
        }
        throw new ZipException("Unknown compression method " + n3);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        this.checkClosed();
        try {
            return this.getEntries().size();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static final class PartialInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        private final byte[] buffer;
        private long bufferOffset;
        private int pos;
        private long end;
        private int dummyByteCount;

        public PartialInputStream(RandomAccessFile randomAccessFile, int n) throws IOException {
            this.raf = randomAccessFile;
            this.buffer = new byte[n];
            this.bufferOffset = -this.buffer.length;
            this.pos = this.buffer.length;
            this.end = randomAccessFile.length();
        }

        void setLength(long l) {
            this.end = this.bufferOffset + (long)this.pos + l;
        }

        private void fillBuffer() throws IOException {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                block4: {
                    try {
                        long l = this.end - this.bufferOffset;
                        if (l == 0L && this.dummyByteCount > 0) {
                            this.buffer[0] = 0;
                            this.dummyByteCount = 0;
                            break block4;
                        }
                        this.raf.seek(this.bufferOffset);
                        this.raf.readFully(this.buffer, 0, (int)Math.min((long)this.buffer.length, l));
                    }
                    catch (Throwable throwable) {
                        Object var2_4 = null;
                        throw throwable;
                    }
                }
                Object var2_3 = null;
            }
        }

        public int available() {
            long l = this.end - (this.bufferOffset + (long)this.pos);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        public int read() throws IOException {
            if (this.bufferOffset + (long)this.pos >= this.end + (long)this.dummyByteCount) {
                return -1;
            }
            if (this.pos == this.buffer.length) {
                this.bufferOffset += (long)this.buffer.length;
                this.pos = 0;
                this.fillBuffer();
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((long)n2 > this.end + (long)this.dummyByteCount - (this.bufferOffset + (long)this.pos) && (n2 = (int)this.end + this.dummyByteCount - ((int)this.bufferOffset + this.pos)) == 0) {
                return -1;
            }
            int n3 = Math.min(this.buffer.length - this.pos, n2);
            System.arraycopy(this.buffer, this.pos, byArray, n, n3);
            this.pos += n3;
            n += n3;
            n2 -= n3;
            while (n2 > 0) {
                this.bufferOffset += (long)this.buffer.length;
                this.pos = 0;
                this.fillBuffer();
                int n4 = Math.min(this.buffer.length, n2);
                System.arraycopy(this.buffer, this.pos, byArray, n, n4);
                this.pos += n4;
                n += n4;
                n2 -= n4;
                n3 += n4;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l < 0L) {
                return 0L;
            }
            if (l > this.end - (this.bufferOffset + (long)this.pos)) {
                l = this.end - (this.bufferOffset + (long)this.pos);
            }
            this.seek(this.bufferOffset + (long)this.pos + l);
            return l;
        }

        void seek(long l) throws IOException {
            long l2 = l - this.bufferOffset;
            if (l2 >= 0L && l2 <= (long)this.buffer.length) {
                this.pos = (int)l2;
            } else {
                this.bufferOffset = l;
                this.pos = 0;
                this.fillBuffer();
            }
        }

        void readFully(byte[] byArray) throws IOException {
            if (this.read(byArray, 0, byArray.length) != byArray.length) {
                throw new EOFException();
            }
        }

        void readFully(byte[] byArray, int n, int n2) throws IOException {
            if (this.read(byArray, n, n2) != n2) {
                throw new EOFException();
            }
        }

        int readLeShort() throws IOException {
            int n = this.read();
            int n2 = this.read();
            if (n2 == -1) {
                throw new EOFException();
            }
            return n & 0xFF | (n2 & 0xFF) << 8;
        }

        int readLeInt() throws IOException {
            int n = this.read();
            int n2 = this.read();
            int n3 = this.read();
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            return n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF | (n4 & 0xFF) << 8) << 16;
        }

        String readString(int n) throws IOException {
            if ((long)n > this.end - (this.bufferOffset + (long)this.pos)) {
                throw new EOFException();
            }
            try {
                if (this.buffer.length - this.pos >= n) {
                    String string = new String(this.buffer, this.pos, n, "UTF-8");
                    this.pos += n;
                    return string;
                }
                byte[] byArray = new byte[n];
                this.readFully(byArray);
                return new String(byArray, 0, n, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }

        public void addDummyByte() {
            this.dummyByteCount = 1;
        }
    }

    private static class ZipEntryEnumeration
    implements Enumeration {
        private final Iterator elements;

        public ZipEntryEnumeration(Iterator iterator) {
            this.elements = iterator;
        }

        public boolean hasMoreElements() {
            return this.elements.hasNext();
        }

        public Object nextElement() {
            return ((ZipEntry)this.elements.next()).clone();
        }
    }
}

