#!/bin/sh
echo 'name: convertible
version: 1.0.9
id: convertible-1.0.9-1c30cbab1e84de8cc498d231c145d142

license: LGPL
copyright: Copyright (c) 2009-2010 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Time
hidden-modules:
import-dirs: /usr/local/lib/convertible-1.0.9/ghc-6.12.3
library-dirs: /usr/local/lib/convertible-1.0.9/ghc-6.12.3
hs-libraries: HSconvertible-1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         bytestring-0.9.1.7-352f069cca85cb3f9e4c06bb76ec4cec
         containers-0.3.0.0-7be04792060ce1514c52e2cb13a5c18a
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         old-locale-1.0.0.2-0c1a4b40f2d3b9f6b725f54c00fe0923
         old-time-1.0.0.5-56dd504e1de073228be3dcc82225ab48
         time-1.1.4-668ce7f110e803952c4ceda6e172096c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/convertible-1.0.9/html/convertible.haddock
haddock-html: /usr/local/share/doc/convertible-1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
