/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.annotate.AnnotationListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.IdeaSubversionConfigurationDirectory;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnServerFileManager;
import org.jetbrains.idea.svn.SvnServerFileManagerImpl;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.SvnAuthenticationProvider;
import org.jetbrains.idea.svn.dialogs.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.update.MergeRootInfo;
import org.jetbrains.idea.svn.update.UpdateRootInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnConfiguration
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnConfiguration");
    public static final int ourMaxAnnotateRevisionsDefault = 500;
    private static final String SERVERS_FILE_NAME = "servers";
    public static final String UPGRADE_AUTO = "auto";
    public static final String UPGRADE_AUTO_15 = "auto1.5";
    public static final String UPGRADE_AUTO_16 = "auto1.6";
    public static final String UPGRADE_NONE = "none";
    public String USER = "";
    public String PASSWORD = "";
    public String[] ADD_PATHS = null;
    private String myConfigurationDirectory;
    private boolean myIsUseDefaultConfiguration;
    private boolean myIsUseDefaultProxy;
    private ISVNOptions myOptions;
    private boolean myIsKeepLocks;
    private boolean myRemoteStatus;
    private final Project myProject;
    private SvnAuthenticationManager myAuthManager;
    private SvnAuthenticationManager myPassiveAuthManager;
    private SvnAuthenticationManager myInteractiveManager;
    private String myUpgradeMode;
    private SvnSupportOptions mySupportOptions;
    private int myMaxAnnotateRevisions = 500;
    public static final AuthStorage RUNTIME_AUTH_CACHE = new AuthStorage();
    public String LAST_MERGED_REVISION = null;
    public boolean UPDATE_RUN_STATUS = false;
    public SVNDepth UPDATE_DEPTH = SVNDepth.INFINITY;
    public boolean MERGE_DRY_RUN = false;
    public boolean MERGE_DIFF_USE_ANCESTRY = true;
    public boolean UPDATE_LOCK_ON_DEMAND = false;
    public boolean IGNORE_SPACES_IN_MERGE = false;
    public boolean DETECT_NESTED_COPIES = true;
    public boolean CHECK_NESTED_FOR_QUICK_MERGE = false;
    public boolean IGNORE_SPACES_IN_ANNOTATE = true;
    public boolean SHOW_MERGE_SOURCES_IN_ANNOTATE = true;
    private final Map<File, MergeRootInfo> myMergeRootInfos = new HashMap<File, MergeRootInfo>();
    private final Map<File, UpdateRootInfo> myUpdateRootInfos = new HashMap<File, UpdateRootInfo>();
    private final List<AnnotationListener> myAnnotationListeners;
    private static final List<String> ourAuthKinds = Arrays.asList("svn.simple", "svn.ssh", "svn.ssl.client-passphrase", "svn.username", "svn.ssl.server");

    public static SvnConfiguration getInstance(Project project) {
        return (SvnConfiguration)project.getComponent(SvnConfiguration.class);
    }

    public static SvnConfiguration getInstanceChecked(final Project project) {
        return (SvnConfiguration)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SvnConfiguration>(){

            public SvnConfiguration compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (SvnConfiguration)project.getComponent(SvnConfiguration.class);
            }
        });
    }

    public SvnConfiguration(Project project) {
        this.myProject = project;
        this.myAnnotationListeners = new ArrayList<AnnotationListener>();
    }

    public void addAnnotationListener(AnnotationListener listener) {
        this.myAnnotationListeners.add(listener);
    }

    public void removeAnnotationListener(AnnotationListener listener) {
        this.myAnnotationListeners.remove(listener);
    }

    public void setIgnoreSpacesInAnnotate(boolean value) {
        boolean changed = this.IGNORE_SPACES_IN_ANNOTATE != value;
        this.IGNORE_SPACES_IN_ANNOTATE = value;
        if (changed) {
            this.fireForAnnotationListeners();
        }
    }

    private void fireForAnnotationListeners() {
        final AnnotationListener[] listeners = this.myAnnotationListeners.toArray(new AnnotationListener[this.myAnnotationListeners.size()]);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < listeners.length; ++i) {
                    AnnotationListener listener = listeners[i];
                    listener.onAnnotationChanged();
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public SvnSupportOptions getSupportOptions() {
        if (this.mySupportOptions == null) {
            this.mySupportOptions = new SvnSupportOptions(SvnBranchConfigurationManager.getInstance(this.myProject).getSupportValue());
        }
        return this.mySupportOptions;
    }

    public String getConfigurationDirectory() {
        if (this.myConfigurationDirectory == null || this.isUseDefaultConfiguation()) {
            this.myConfigurationDirectory = IdeaSubversionConfigurationDirectory.getPath();
        }
        return this.myConfigurationDirectory;
    }

    public boolean isUseDefaultConfiguation() {
        return this.myIsUseDefaultConfiguration;
    }

    public void setConfigurationDirectory(String path) {
        this.myConfigurationDirectory = path;
        File dir = path == null ? new File(IdeaSubversionConfigurationDirectory.getPath()) : new File(path);
        SVNConfigFile.createDefaultConfiguration((File)dir);
        this.myOptions = null;
        this.myAuthManager = null;
        this.myPassiveAuthManager = null;
        this.myInteractiveManager = null;
        RUNTIME_AUTH_CACHE.clear();
    }

    public void setUseDefaultConfiguation(boolean useDefault) {
        this.myIsUseDefaultConfiguration = useDefault;
        this.myOptions = null;
        this.myAuthManager = null;
        this.myPassiveAuthManager = null;
        this.myInteractiveManager = null;
        RUNTIME_AUTH_CACHE.clear();
    }

    public ISVNOptions getOptions(Project project) {
        if (this.myOptions == null) {
            File path = new File(this.getConfigurationDirectory());
            this.myOptions = SVNWCUtil.createDefaultOptions((File)path.getAbsoluteFile(), (boolean)true);
        }
        return this.myOptions;
    }

    public SvnAuthenticationManager getAuthenticationManager(SvnVcs svnVcs) {
        if (this.myAuthManager == null) {
            this.myAuthManager = new SvnAuthenticationManager(this.myProject, new File(this.getConfigurationDirectory()));
            this.myAuthManager.setAuthenticationProvider(new SvnAuthenticationProvider(svnVcs, this.getInteractiveManager(svnVcs)));
            this.myAuthManager.setRuntimeStorage(RUNTIME_AUTH_CACHE);
        }
        return this.myAuthManager;
    }

    public SvnAuthenticationManager getPassiveAuthenticationManager() {
        if (this.myPassiveAuthManager == null) {
            this.myPassiveAuthManager = new SvnAuthenticationManager(this.myProject, new File(this.getConfigurationDirectory()));
            this.myPassiveAuthManager.setRuntimeStorage(RUNTIME_AUTH_CACHE);
        }
        return this.myPassiveAuthManager;
    }

    public SvnAuthenticationManager getInteractiveManager(SvnVcs svnVcs) {
        if (this.myInteractiveManager == null) {
            this.myInteractiveManager = new SvnAuthenticationManager(this.myProject, new File(this.getConfigurationDirectory()));
            this.myInteractiveManager.setRuntimeStorage(RUNTIME_AUTH_CACHE);
            this.myInteractiveManager.setAuthenticationProvider(new SvnInteractiveAuthenticationProvider(svnVcs, this.myInteractiveManager));
        }
        return this.myInteractiveManager;
    }

    public void getServerFilesManagers(Ref<SvnServerFileManager> systemManager, Ref<SvnServerFileManager> userManager) {
        SVNConfigFile.createDefaultConfiguration((File)new File(this.getConfigurationDirectory()));
        systemManager.set((Object)new SvnServerFileManagerImpl(new IdeaSVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), SERVERS_FILE_NAME))));
        userManager.set((Object)new SvnServerFileManagerImpl(new IdeaSVNConfigFile(new File(this.getConfigurationDirectory(), SERVERS_FILE_NAME))));
    }

    public String getUpgradeMode() {
        return this.myUpgradeMode;
    }

    public void setUpgradeMode(String upgradeMode) {
        this.myUpgradeMode = upgradeMode;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Attribute maxAnnotateRevisions;
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        List elems = element.getChildren("addpath");
        LOG.debug(elems.toString());
        this.ADD_PATHS = new String[elems.size()];
        for (int i = 0; i < elems.size(); ++i) {
            Element elem = (Element)elems.get(i);
            this.ADD_PATHS[i] = elem.getAttributeValue("path");
        }
        Element configurationDirectory = element.getChild("configuration");
        if (configurationDirectory != null) {
            this.myConfigurationDirectory = configurationDirectory.getText();
            Attribute defaultAttr = configurationDirectory.getAttribute("useDefault");
            try {
                this.myIsUseDefaultConfiguration = defaultAttr != null && defaultAttr.getBooleanValue();
            }
            catch (DataConversionException e) {
                this.myIsUseDefaultConfiguration = false;
            }
        } else {
            this.myIsUseDefaultConfiguration = true;
        }
        List urls = element.getChildren("checkoutURL");
        for (Object url1 : urls) {
            Element child = (Element)url1;
            String url = child.getText();
            if (url == null) continue;
            SvnApplicationSettings.getInstance().addCheckoutURL(url);
        }
        this.myIsKeepLocks = element.getChild("keepLocks") != null;
        this.myRemoteStatus = element.getChild("remoteStatus") != null;
        this.myUpgradeMode = element.getChild("upgradeMode") != null ? element.getChild("upgradeMode").getText() : null;
        Element useProxy = element.getChild("myIsUseDefaultProxy");
        this.myIsUseDefaultProxy = useProxy == null ? false : Boolean.parseBoolean(useProxy.getText());
        Element supportedVersion = element.getChild("supportedVersion");
        if (supportedVersion != null) {
            try {
                this.mySupportOptions = new SvnSupportOptions(Long.parseLong(supportedVersion.getText().trim()));
            }
            catch (NumberFormatException e) {
                this.mySupportOptions = new SvnSupportOptions(null);
            }
        }
        if ((maxAnnotateRevisions = element.getAttribute("maxAnnotateRevisions")) != null) {
            try {
                this.myMaxAnnotateRevisions = maxAnnotateRevisions.getIntValue();
            }
            catch (DataConversionException e) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        if (this.ADD_PATHS != null) {
            for (String aADD_PATHS : this.ADD_PATHS) {
                Element elem = new Element("addpath");
                elem.setAttribute("path", aADD_PATHS);
                element.addContent(elem);
            }
        }
        if (this.myConfigurationDirectory != null) {
            Element configurationDirectory = new Element("configuration");
            configurationDirectory.setText(this.myConfigurationDirectory);
            configurationDirectory.setAttribute("useDefault", this.myIsUseDefaultConfiguration ? "true" : "false");
            element.addContent(configurationDirectory);
        }
        if (this.myIsKeepLocks) {
            element.addContent(new Element("keepLocks"));
        }
        if (this.myRemoteStatus) {
            element.addContent(new Element("remoteStatus"));
        }
        if (this.myUpgradeMode != null) {
            element.addContent(new Element("upgradeMode").setText(this.myUpgradeMode));
        }
        element.addContent(new Element("myIsUseDefaultProxy").setText(this.myIsUseDefaultProxy ? "true" : "false"));
        if (this.mySupportOptions != null) {
            element.addContent(new Element("supportedVersion").setText("" + this.mySupportOptions.myVersion));
        }
        element.setAttribute("maxAnnotateRevisions", "" + this.myMaxAnnotateRevisions);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public String getComponentName() {
        return "SvnConfiguration";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public boolean isKeepLocks() {
        return this.myIsKeepLocks;
    }

    public void setKeepLocks(boolean keepLocks) {
        this.myIsKeepLocks = keepLocks;
    }

    public boolean isRemoteStatus() {
        return this.myRemoteStatus;
    }

    public void setRemoteStatus(boolean remote) {
        this.myRemoteStatus = remote;
    }

    public boolean isIsUseDefaultProxy() {
        return this.myIsUseDefaultProxy;
    }

    public void setIsUseDefaultProxy(boolean isUseDefaultProxy) {
        this.myIsUseDefaultProxy = isUseDefaultProxy;
    }

    public MergeRootInfo getMergeRootInfo(File file, SvnVcs svnVcs) {
        if (!this.myMergeRootInfos.containsKey(file)) {
            this.myMergeRootInfos.put(file, new MergeRootInfo(file, svnVcs));
        }
        return this.myMergeRootInfos.get(file);
    }

    public UpdateRootInfo getUpdateRootInfo(File file, SvnVcs svnVcs) {
        if (!this.myUpdateRootInfos.containsKey(file)) {
            this.myUpdateRootInfos.put(file, new UpdateRootInfo(file, svnVcs));
        }
        return this.myUpdateRootInfos.get(file);
    }

    public Map<File, UpdateRootInfo> getUpdateInfosMap() {
        return Collections.unmodifiableMap(this.myUpdateRootInfos);
    }

    public void clearAuthenticationDirectory() {
        final File authDir = new File(this.getConfigurationDirectory(), "auth");
        if (authDir.exists()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    File[] files;
                    ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
                    if (ind != null) {
                        ind.setIndeterminate(true);
                        ind.setText("Clearing stored credentials in " + authDir.getAbsolutePath());
                    }
                    for (File dir : files = authDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return ourAuthKinds.contains(name);
                        }
                    })) {
                        if (ind != null) {
                            ind.setText("Deleting " + dir.getAbsolutePath());
                        }
                        FileUtil.delete((File)dir);
                    }
                }
            }, "button.text.clear.authentication.cache", false, this.myProject);
        }
    }

    public boolean haveCredentialsFor(String kind, String realm) {
        return RUNTIME_AUTH_CACHE.getData(kind, realm) != null;
    }

    public void acknowledge(String kind, String realm, Object object) {
        RUNTIME_AUTH_CACHE.putData(kind, realm, object);
    }

    public void clearCredentials(String kind, String realm) {
        RUNTIME_AUTH_CACHE.putData(kind, realm, null);
    }

    public int getMaxAnnotateRevisions() {
        return this.myMaxAnnotateRevisions;
    }

    public void setMaxAnnotateRevisions(int maxAnnotateRevisions) {
        this.myMaxAnnotateRevisions = maxAnnotateRevisions;
    }

    public static class AuthStorage
    implements ISVNAuthenticationStorage {
        private final Map<String, Object> myStorage = new Hashtable<String, Object>();

        public void clear() {
            this.myStorage.clear();
        }

        public void putData(String kind, String realm, Object data) {
            if (data == null) {
                this.myStorage.remove(kind + "$" + realm);
            } else {
                this.myStorage.put(kind + "$" + realm, data);
            }
        }

        public Object getData(String kind, String realm) {
            return this.myStorage.get(kind + "$" + realm);
        }
    }

    public class SvnSupportOptions {
        private Long myVersion;
        private static final long UPGRADE_TO_15_VERSION_ASKED = 123L;
        private static final long CHANGELIST_SUPPORT = 124L;
        private static final long UPGRADE_TO_16_VERSION_ASKED = 125L;

        public SvnSupportOptions(Long version) {
            this.myVersion = version;
            if (this.myVersion == null || this.myVersion < 124L) {
                this.myVersion = 123L;
            }
        }

        public boolean upgradeTo16Asked() {
            return this.myVersion != null && 125L <= this.myVersion;
        }

        public boolean changeListsSynchronized() {
            return this.myVersion != null && 124L <= this.myVersion;
        }

        public void upgrade() {
            this.myVersion = 125L;
        }
    }
}

