/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.openapi.ui.InputException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ProxySettingsPanel {
    private JPanel myPanel;
    private JTextField myProxyPort;
    private JTextField myProxyHost;
    private JCheckBox myUseProxy;
    private JRadioButton mySocks5;
    private JRadioButton mySocks4;
    private JRadioButton myHTTP;
    private JPasswordField myPassword;
    private JTextField myLogin;

    public ProxySettingsPanel() {
        this.$$$setupUI$$$();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myHTTP);
        buttonGroup.add(this.mySocks4);
        buttonGroup.add(this.mySocks5);
        this.disableAll(false);
        this.myUseProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ProxySettingsPanel.this.myUseProxy.isSelected()) {
                    ProxySettingsPanel.this.enableAll(false);
                } else {
                    ProxySettingsPanel.this.disableAll(false);
                }
            }
        });
    }

    public void disableAll(boolean disableUseProxyButton) {
        if (disableUseProxyButton) {
            this.myUseProxy.setEnabled(false);
        }
        this.myHTTP.setEnabled(false);
        this.mySocks4.setEnabled(false);
        this.mySocks5.setEnabled(false);
        this.myLogin.setEnabled(false);
        this.myPassword.setEnabled(false);
        this.myProxyHost.setEnabled(false);
        this.myProxyPort.setEnabled(false);
    }

    public void enableAll(boolean enableUseProxyButton) {
        if (enableUseProxyButton) {
            this.myUseProxy.setEnabled(true);
        }
        if (this.myUseProxy.isEnabled()) {
            this.myHTTP.setEnabled(true);
            this.mySocks4.setEnabled(true);
            this.mySocks5.setEnabled(true);
            this.myLogin.setEnabled(true);
            this.myPassword.setEnabled(true);
            this.myProxyHost.setEnabled(true);
            this.myProxyPort.setEnabled(true);
        }
    }

    public Component getPanel() {
        return this.myPanel;
    }

    public void updateFrom(CvsRootData cvsRootData) {
        this.myUseProxy.setSelected(true);
        this.myProxyHost.setText(cvsRootData.PROXY_HOST);
        this.myProxyPort.setText(cvsRootData.PROXY_PORT);
        this.myHTTP.setSelected(true);
    }

    public void updateFrom(ProxySettings proxy_settings) {
        this.myUseProxy.setSelected(proxy_settings.USE_PROXY);
        this.myProxyHost.setText(proxy_settings.PROXY_HOST);
        this.myProxyPort.setText(this.getStringPortValue(proxy_settings.PROXY_PORT));
        if (proxy_settings.getType() == ProxySettings.HTTP) {
            this.myHTTP.setSelected(true);
        } else if (proxy_settings.getType() == ProxySettings.SOCKS4) {
            this.mySocks4.setSelected(true);
        } else {
            this.mySocks5.setSelected(true);
        }
        this.myLogin.setText(proxy_settings.getLogin());
        this.myPassword.setText(proxy_settings.getPassword());
        if (proxy_settings.USE_PROXY) {
            this.enableAll(true);
        } else {
            this.disableAll(false);
        }
    }

    private String getStringPortValue(int proxy_port) {
        return String.valueOf(proxy_port);
    }

    public boolean equalsTo(ProxySettings proxy_settings) {
        try {
            return this.myUseProxy.isSelected() == proxy_settings.USE_PROXY && this.myProxyHost.getText().equals(proxy_settings.PROXY_HOST) && this.getIntPortValue(this.myProxyPort.getText(), this.myProxyPort) == proxy_settings.PROXY_PORT && this.getSelectedType() == proxy_settings.getType() && proxy_settings.getLogin().equals(this.myLogin.getText()) && proxy_settings.getPassword().equals(new String(this.myPassword.getPassword()));
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getSelectedType() {
        if (this.myHTTP.isSelected()) {
            return ProxySettings.HTTP;
        }
        if (this.mySocks4.isSelected()) {
            return ProxySettings.SOCKS4;
        }
        return ProxySettings.SOCKS5;
    }

    private int getIntPortValue(String text, JComponent component) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new InputException(CvsBundle.message((String)"exception.text.invalid.port.value", (Object[])new Object[]{text}), component);
        }
    }

    public void saveTo(ProxySettings proxy_settings) {
        proxy_settings.USE_PROXY = this.myUseProxy.isSelected();
        proxy_settings.PROXY_HOST = this.myProxyHost.getText();
        proxy_settings.PROXY_PORT = this.getIntPortValue(this.myProxyPort.getText(), this.myProxyPort);
        proxy_settings.TYPE = this.getSelectedType();
        proxy_settings.LOGIN = this.myLogin.getText();
        proxy_settings.PASSWORD = new String(this.myPassword.getPassword());
    }

    public void disablePanel() {
        this.disableAll(true);
    }

    public void enablePanel() {
        this.enableAll(true);
        if (!this.myUseProxy.isSelected()) {
            this.disableAll(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPasswordField jPasswordField;
        JTextField jTextField3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.configure.proxy.proxy.settings"), 0, 0, null, null));
        this.myUseProxy = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.configure.proxy.use.proxy"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHTTP = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.configure.proxy.protocol.http"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySocks4 = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.configure.proxy.protocol.socks4"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySocks5 = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.configure.proxy.protocol.socks5"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLogin = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, 20), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.proxy.login"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.proxy.password"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassword = jPasswordField = new JPasswordField();
        jPanel3.add((Component)jPasswordField, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, 20), null));
        this.myProxyHost = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.proxy.proxy.host"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.proxy.proxy.port"));
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProxyPort = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setEditable(true);
        jTextField.setColumns(4);
        jPanel4.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

