/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;

public class GroovyEditorActionUtil {
    public static TokenSet GSTRING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_LITERAL, GroovyTokenTypes.mDOLLAR});
    public static TokenSet GSTRING_TOKENS_INNER = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mDOLLAR});

    private GroovyEditorActionUtil() {
    }

    public static void insertSpacesByGroovyContinuationIndent(Editor editor, Project project) {
        int indentSize = CodeStyleSettingsManager.getSettings((Project)project).getContinuationIndentSize((FileType)GroovyFileType.GROOVY_FILE_TYPE);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < indentSize; ++i) {
            buffer.append(" ");
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)buffer.toString());
    }

    public static boolean isPlainStringLiteral(ASTNode node) {
        String text = node.getText();
        return text.length() < 3 && text.equals("''") || text.length() > 3 && !text.startsWith("'''");
    }

    public static boolean isPlainGString(ASTNode node) {
        String text = node.getText();
        return text.length() < 3 && text.equals("\"\"") || text.length() > 3 && !text.startsWith("\"\"\"");
    }

    public static boolean isMultilineStringElement(ASTNode node) {
        PsiElement element = node.getPsi();
        if (element instanceof GrLiteral) {
            if (element instanceof GrString) {
                return !((GrString)element).isPlainString();
            }
            return GroovyEditorActionUtil.isSimpleStringLiteral((GrLiteral)element) && !GroovyEditorActionUtil.isPlainStringLiteral(node) || GroovyEditorActionUtil.isSimpleGStringLiteral((GrLiteral)element) && !GroovyEditorActionUtil.isPlainGString(node);
        }
        return false;
    }

    public static boolean isSimpleStringLiteral(GrLiteral literal) {
        PsiElement child = literal.getFirstChild();
        if (child != null && child.getNode() != null) {
            ASTNode node = child.getNode();
            assert (node != null);
            return node.getElementType() == GroovyTokenTypes.mSTRING_LITERAL;
        }
        return false;
    }

    public static boolean isSimpleGStringLiteral(GrLiteral literal) {
        PsiElement child = literal.getFirstChild();
        if (child != null && child.getNode() != null) {
            ASTNode node = child.getNode();
            assert (node != null);
            return node.getElementType() == GroovyTokenTypes.mGSTRING_LITERAL;
        }
        return false;
    }
}

