/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.EclipseJDOMUtil;

public class DotProjectFileHelper {
    private static final Logger LOG = Logger.getInstance((String)("#" + DotProjectFileHelper.class.getName()));

    private DotProjectFileHelper() {
    }

    public static void saveDotProjectFile(Module module, String storageRoot) throws IOException {
        try {
            Document doc = module.getModuleType() instanceof JavaModuleType ? JDOMUtil.loadDocument((URL)DotProjectFileHelper.class.getResource("template.project.xml")) : JDOMUtil.loadDocument((URL)DotProjectFileHelper.class.getResource("template.empty.project.xml"));
            Element nameElement = doc.getRootElement().getChild("name");
            nameElement.setText(module.getName());
            final File projectFile = new File(storageRoot, ".project");
            if (!FileUtil.createIfDoesntExist((File)projectFile)) {
                return;
            }
            EclipseJDOMUtil.output(doc, projectFile, module.getProject());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)projectFile.getPath()));
                }
            });
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
    }
}

