/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.EclipseModuleManager;
import org.jetbrains.idea.eclipse.conversion.ConversionException;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.util.ErrorLog;

public class EclipseClasspathReader {
    private final String myRootPath;
    private final Project myProject;
    @Nullable
    private final List<String> myCurrentRoots;
    private ContentEntry myContentEntry;

    public EclipseClasspathReader(String rootPath, Project project, @Nullable List<String> currentRoots) {
        this.myRootPath = rootPath;
        this.myProject = project;
        this.myCurrentRoots = currentRoots;
    }

    public void init(ModifiableRootModel model) {
        this.myContentEntry = model.addContentEntry(VfsUtil.pathToUrl((String)this.myRootPath));
    }

    public static void collectVariables(Set<String> usedVariables, Element classpathElement, String rootPath) {
        for (Object o : classpathElement.getChildren("classpathentry")) {
            Element element = (Element)o;
            String path = element.getAttributeValue("path");
            if (path == null) continue;
            String kind = element.getAttributeValue("kind");
            if (Comparing.strEqual((String)kind, (String)"var")) {
                EclipseClasspathReader.createEPathVariable(usedVariables, path, 0);
                String srcPath = element.getAttributeValue("sourcepath");
                if (srcPath == null) continue;
                EclipseClasspathReader.createEPathVariable(usedVariables, srcPath, EclipseClasspathReader.srcVarStart(srcPath));
                continue;
            }
            if (!Comparing.strEqual((String)kind, (String)"src") || !EclipseProjectFinder.isExternalResource(rootPath, path)) continue;
            usedVariables.add(EclipseProjectFinder.extractPathVariableName(path));
        }
    }

    private static int srcVarStart(String srcPath) {
        return srcPath.startsWith("/") ? 1 : 0;
    }

    public void readClasspath(ModifiableRootModel model, Collection<String> unknownLibraries, Collection<String> unknownJdks, Set<String> usedVariables, Set<String> refsToModules, String testPattern, Element classpathElement) throws IOException, ConversionException {
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (orderEntry instanceof ModuleSourceOrderEntry) continue;
            model.removeOrderEntry(orderEntry);
        }
        for (Object o : classpathElement.getChildren("classpathentry")) {
            try {
                this.readClasspathEntry(model, unknownLibraries, unknownJdks, usedVariables, refsToModules, testPattern, (Element)o);
            }
            catch (ConversionException e) {
                ErrorLog.rethrow(ErrorLog.Level.Warning, null, ".classpath", e);
            }
        }
        if (!model.isSdkInherited() && model.getSdkName() == null) {
            EclipseModuleManager.getInstance(model.getModule()).setForceConfigureJDK();
            model.inheritSdk();
        }
    }

    private void readClasspathEntry(ModifiableRootModel rootModel, Collection<String> unknownLibraries, Collection<String> unknownJdks, Set<String> usedVariables, Set<String> refsToModules, String testPattern, Element element) throws ConversionException {
        String kind = element.getAttributeValue("kind");
        if (kind == null) {
            throw new ConversionException("Missing classpathentry/@kind");
        }
        String path = element.getAttributeValue("path");
        if (path == null) {
            throw new ConversionException("Missing classpathentry/@path");
        }
        boolean exported = "true".equals(element.getAttributeValue("exported"));
        if (kind.equals("src")) {
            if (path.startsWith("/")) {
                String moduleName = path.substring(1);
                refsToModules.add(moduleName);
                rootModel.addInvalidModuleEntry(moduleName).setExported(exported);
            } else {
                boolean isTestFolder;
                String srcUrl = VfsUtil.pathToUrl((String)(this.myRootPath + "/" + path));
                boolean bl = isTestFolder = testPattern != null && testPattern.length() > 0 && path.matches(testPattern);
                if (EclipseProjectFinder.isExternalResource(this.myRootPath, path)) {
                    String varName = EclipseProjectFinder.extractPathVariableName(path);
                    usedVariables.add(varName);
                    String toPathVariableFormat = EclipseClasspathReader.getVariableRelatedPath(varName, path.length() > varName.length() ? path.substring(varName.length()) : null);
                    srcUrl = VfsUtil.pathToUrl((String)PathMacroManager.getInstance((ComponentManager)rootModel.getModule()).expandPath(toPathVariableFormat));
                    EclipseModuleManager.getInstance(rootModel.getModule()).registerEclipseLinkedSrcVarPath(srcUrl, path);
                    rootModel.addContentEntry(srcUrl).addSourceFolder(srcUrl, isTestFolder);
                } else {
                    this.getContentEntry().addSourceFolder(srcUrl, isTestFolder);
                }
                EclipseClasspathReader.rearrangeOrderEntryOfType(rootModel, ModuleSourceOrderEntry.class);
            }
        } else if (kind.equals("output")) {
            EclipseClasspathReader.setupOutput(rootModel, this.myRootPath + "/" + path);
        } else if (kind.equals("lib")) {
            String libName = EclipseClasspathReader.getPresentableName(path);
            Library library = rootModel.getModuleLibraryTable().getModifiableModel().createLibrary(libName);
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(EPathUtil.expandEclipsePath2Url(path, rootModel, this.myCurrentRoots), OrderRootType.CLASSES);
            String sourcePath = element.getAttributeValue("sourcepath");
            if (sourcePath != null) {
                modifiableModel.addRoot(EPathUtil.expandEclipsePath2Url(sourcePath, rootModel, this.myCurrentRoots), OrderRootType.SOURCES);
            }
            EJavadocUtil.appendJavadocRoots(element, (ModuleRootModel)rootModel, this.myCurrentRoots, modifiableModel);
            modifiableModel.commit();
            EclipseClasspathReader.setLibraryEntryExported(rootModel, exported, library);
        } else if (kind.equals("var")) {
            int slash = path.indexOf("/");
            if (slash == 0) {
                throw new ConversionException("Incorrect 'classpathentry/var@path' format");
            }
            String libName = EclipseClasspathReader.getPresentableName(path);
            Library library = rootModel.getModuleLibraryTable().getModifiableModel().createLibrary(libName);
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            String url = EclipseClasspathReader.eclipseVariabledPath2Url(rootModel, usedVariables, path, 0);
            modifiableModel.addRoot(url, OrderRootType.CLASSES);
            EclipseModuleManager.getInstance(rootModel.getModule()).registerEclipseVariablePath(url, path);
            String srcPathAttr = element.getAttributeValue("sourcepath");
            if (srcPathAttr != null) {
                String srcUrl = EclipseClasspathReader.eclipseVariabledPath2Url(rootModel, usedVariables, srcPathAttr, EclipseClasspathReader.srcVarStart(srcPathAttr));
                modifiableModel.addRoot(srcUrl, OrderRootType.SOURCES);
                EclipseModuleManager.getInstance(rootModel.getModule()).registerEclipseSrcVariablePath(srcUrl, srcPathAttr);
            }
            EJavadocUtil.appendJavadocRoots(element, (ModuleRootModel)rootModel, this.myCurrentRoots, modifiableModel);
            modifiableModel.commit();
            EclipseClasspathReader.setLibraryEntryExported(rootModel, exported, library);
        } else if (kind.equals("con")) {
            if (path.equals("org.eclipse.pde.core.requiredPlugins")) {
                this.addNamedLibrary(rootModel, unknownLibraries, exported, "ECLIPSE", "application");
            } else if (path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                String jdkName = EclipseClasspathReader.getLastPathComponent(path);
                if (jdkName == null) {
                    rootModel.inheritSdk();
                } else {
                    Sdk moduleJdk = ProjectJdkTable.getInstance().findJdk(jdkName);
                    if (moduleJdk != null) {
                        rootModel.setSdk(moduleJdk);
                    } else {
                        rootModel.setInvalidSdk(jdkName, "JavaSDK");
                        unknownJdks.add(jdkName);
                    }
                }
                EclipseClasspathReader.rearrangeOrderEntryOfType(rootModel, JdkOrderEntry.class);
            } else if (path.startsWith("org.eclipse.jdt.USER_LIBRARY")) {
                this.addNamedLibrary(rootModel, unknownLibraries, exported, EclipseClasspathReader.getPresentableName(path), "project");
            } else if (path.startsWith("org.eclipse.jdt.junit.JUNIT_CONTAINER")) {
                String junitName = "junit" + EclipseClasspathReader.getPresentableName(path);
                Library library = rootModel.getModuleLibraryTable().getModifiableModel().createLibrary(junitName);
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                modifiableModel.addRoot(EclipseClasspathReader.getJunitClsUrl(junitName.contains("4")), OrderRootType.CLASSES);
                modifiableModel.commit();
            } else {
                EclipseModuleManager.getInstance(rootModel.getModule()).registerUnknownCons(path);
                this.addNamedLibrary(rootModel, new ArrayList<String>(), exported, path, "application");
            }
        } else {
            throw new ConversionException("Unknown classpathentry/@kind: " + kind);
        }
    }

    private static void rearrangeOrderEntryOfType(ModifiableRootModel rootModel, Class<? extends OrderEntry> orderEntryClass) {
        Object[] orderEntries = rootModel.getOrderEntries();
        int moduleSourcesIdx = 0;
        for (OrderEntry orderEntry : orderEntries) {
            if (orderEntryClass.isAssignableFrom(orderEntry.getClass())) break;
            ++moduleSourcesIdx;
        }
        orderEntries = (OrderEntry[])ArrayUtil.append((Object[])orderEntries, (Object)orderEntries[moduleSourcesIdx]);
        rootModel.rearrangeOrderEntries((OrderEntry[])ArrayUtil.remove((Object[])orderEntries, (int)moduleSourcesIdx));
    }

    public static void setupOutput(ModifiableRootModel rootModel, String path) {
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setCompilerOutputPath(VfsUtil.pathToUrl((String)path));
        compilerModuleExtension.inheritCompilerOutputPath(false);
    }

    private static void setLibraryEntryExported(ModifiableRootModel rootModel, boolean exported, Library library) {
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !((LibraryOrderEntry)orderEntry).isModuleLevel() || !Comparing.equal((Object)((LibraryOrderEntry)orderEntry).getLibrary(), (Object)library)) continue;
            ((LibraryOrderEntry)orderEntry).setExported(exported);
            break;
        }
    }

    private void addNamedLibrary(ModifiableRootModel rootModel, Collection<String> unknownLibraries, boolean exported, String name, String notFoundLibraryLevel) {
        Library lib = EclipseClasspathReader.findLibraryByName(this.myProject, name);
        if (lib != null) {
            rootModel.addLibraryEntry(lib).setExported(exported);
        } else {
            unknownLibraries.add(name);
            rootModel.addInvalidLibrary(name, notFoundLibraryLevel).setExported(exported);
        }
    }

    public static Library findLibraryByName(Project project, String name) {
        Library lib;
        block2: {
            LibraryTable table;
            LibraryTablesRegistrar tablesRegistrar = LibraryTablesRegistrar.getInstance();
            lib = tablesRegistrar.getLibraryTable().getLibraryByName(name);
            if (lib == null) {
                lib = tablesRegistrar.getLibraryTable(project).getLibraryByName(name);
            }
            if (lib != null) break block2;
            Iterator i$ = tablesRegistrar.getCustomLibraryTables().iterator();
            while (i$.hasNext() && (lib = (table = (LibraryTable)i$.next()).getLibraryByName(name)) == null) {
            }
        }
        return lib;
    }

    @NotNull
    private static String getPresentableName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader.getPresentableName must not be null");
        }
        String pathComponent = EclipseClasspathReader.getLastPathComponent(path);
        String string = pathComponent != null ? pathComponent : path;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/eclipse/conversion/EclipseClasspathReader.getPresentableName must not return null");
        }
        return string;
    }

    @Nullable
    public static String getLastPathComponent(String path) {
        int idx = path.lastIndexOf(47);
        return idx < 0 || idx == path.length() - 1 ? null : path.substring(idx + 1);
    }

    private ContentEntry getContentEntry() {
        return this.myContentEntry;
    }

    private static String getVariableRelatedPath(String var, String path) {
        return var == null ? null : "$" + var + "$" + (path == null ? "" : "/" + path);
    }

    static String getJunitClsUrl(boolean version4) {
        String url = version4 ? JavaSdkUtil.getJunit4JarPath() : JavaSdkUtil.getJunit3JarPath();
        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)url));
        if (localFile != null) {
            VirtualFile jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile);
            url = jarFile != null ? jarFile.getUrl() : localFile.getUrl();
        }
        return url;
    }

    private static String eclipseVariabledPath2Url(ModifiableRootModel rootModel, Set<String> usedVariables, String path, int varStart) {
        VirtualFile jarFile;
        EPathVariable var = EclipseClasspathReader.createEPathVariable(usedVariables, path, varStart);
        String url = PathMacroManager.getInstance((ComponentManager)rootModel.getModule()).expandPath(var.toIdeaVariabledUrl());
        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (localFile != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
            return jarFile.getUrl();
        }
        return url;
    }

    private static EPathVariable createEPathVariable(Set<String> usedVariables, String pathAttr, int varStart) {
        int slash = pathAttr.indexOf("/", varStart);
        EPathVariable var = slash > 0 ? new EPathVariable(usedVariables, pathAttr.substring(varStart, slash), pathAttr.substring(slash + 1)) : new EPathVariable(usedVariables, pathAttr.substring(varStart), null);
        return var;
    }

    private static class EPathVariable {
        private String myVariable;
        private String myRelatedPath;

        private EPathVariable(Set<String> usedVariables, String variable, String relatedPath) {
            this.myVariable = variable;
            this.myRelatedPath = relatedPath;
            usedVariables.add(this.myVariable);
        }

        public String toIdeaVariabledUrl() {
            return VfsUtil.pathToUrl((String)EclipseClasspathReader.getVariableRelatedPath(this.myVariable, this.myRelatedPath));
        }
    }
}

