/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.validators.GitBranchNameValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GitCloneDialog
extends DialogWrapper {
    private static final Pattern SSH_URL_PATTERN;
    private JTextField myRepositoryURL;
    private TextFieldWithBrowseButton myParentDirectory;
    private JButton myTestButton;
    private String myTestURL;
    private Boolean myTestResult;
    private JTextField myDirectoryName;
    private String myDefaultDirectoryName = "";
    private JTextField myOriginName;
    private JPanel myPanel;
    private final Project myProject;

    public GitCloneDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.init();
        this.initListeners();
        this.setTitle(GitBundle.getString("clone.title"));
        this.setOKButtonText(GitBundle.getString("clone.button"));
    }

    public String getSourceRepositoryURL() {
        return this.myRepositoryURL.getText();
    }

    public String getParentDirectory() {
        return this.myParentDirectory.getText();
    }

    public String getDirectoryName() {
        return this.myDirectoryName.getText();
    }

    public String getOriginName() {
        return this.myOriginName.getText();
    }

    private void initListeners() {
        FileChooserDescriptor fcd = new FileChooserDescriptor(false, true, false, false, false, false);
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GitBundle.getString("clone.destination.directory.title"));
        fcd.setDescription(GitBundle.getString("clone.destination.directory.description"));
        fcd.setHideIgnored(false);
        this.myParentDirectory.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(fcd.getTitle(), fcd.getDescription(), (ComponentWithBrowseButton)this.myParentDirectory, this.myProject, fcd, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = this.getComponentText();
                if (text.length() == 0 && (file = GitCloneDialog.this.myProject.getBaseDir()) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        DocumentListener updateOkButtonListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GitCloneDialog.this.updateOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GitCloneDialog.this.updateOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GitCloneDialog.this.updateOkButton();
            }
        };
        ((JTextField)this.myParentDirectory.getChildComponent()).getDocument().addDocumentListener(updateOkButtonListener);
        this.myDirectoryName.getDocument().addDocumentListener(updateOkButtonListener);
        this.myOriginName.getDocument().addDocumentListener(updateOkButtonListener);
        this.myRepositoryURL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                String url = GitCloneDialog.this.myRepositoryURL.getText();
                GitCloneDialog.this.myTestButton.setEnabled(url.length() != 0);
                if (GitCloneDialog.this.myDefaultDirectoryName.equals(GitCloneDialog.this.myDirectoryName.getText()) || GitCloneDialog.this.myDirectoryName.getText().length() == 0) {
                    GitCloneDialog.this.myDefaultDirectoryName = GitCloneDialog.defaultDirectoryName(url);
                    GitCloneDialog.this.myDirectoryName.setText(GitCloneDialog.this.myDefaultDirectoryName);
                }
                GitCloneDialog.this.updateOkButton();
            }
        });
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitCloneDialog.this.myTestURL = GitCloneDialog.this.myRepositoryURL.getText();
                String output = GitHandlerUtil.doSynchronously(GitCloneDialog.checkRepository(GitCloneDialog.this.myProject, GitCloneDialog.this.myTestURL), GitBundle.message("clone.testing", GitCloneDialog.this.myTestURL), "connection test");
                if (output != null) {
                    Messages.showInfoMessage((Component)GitCloneDialog.this.myTestButton, (String)GitBundle.message("clone.test.success.message", GitCloneDialog.this.myTestURL), (String)GitBundle.getString("clone.test.success"));
                    GitCloneDialog.this.myTestResult = Boolean.TRUE;
                } else {
                    GitCloneDialog.this.myTestResult = Boolean.FALSE;
                }
                GitCloneDialog.this.updateOkButton();
            }
        });
        this.setOKActionEnabled(false);
    }

    private void updateOkButton() {
        if (!this.checkRepositoryURL()) {
            return;
        }
        if (!this.checkDestination()) {
            return;
        }
        if (!this.checkOrigin()) {
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private boolean checkOrigin() {
        String origin = this.myOriginName.getText();
        if (origin.length() != 0 && !GitBranchNameValidator.INSTANCE.checkInput(origin)) {
            this.setErrorText(GitBundle.getString("clone.invalid.origin"));
            this.setOKActionEnabled(false);
            return false;
        }
        return true;
    }

    private boolean checkDestination() {
        if (this.myParentDirectory.getText().length() == 0 || this.myDirectoryName.getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return false;
        }
        File file = new File(this.myParentDirectory.getText(), this.myDirectoryName.getText());
        if (file.exists()) {
            this.setErrorText(GitBundle.message("clone.destination.exists.error", file));
            this.setOKActionEnabled(false);
            return false;
        }
        if (!file.getParentFile().exists()) {
            this.setErrorText(GitBundle.message("clone.parent.missing.error", file.getParent()));
            this.setOKActionEnabled(false);
            return false;
        }
        return true;
    }

    private boolean checkRepositoryURL() {
        String repository = this.myRepositoryURL.getText();
        if (repository.length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return false;
        }
        if (this.myTestResult != null && repository.equals(this.myTestURL)) {
            if (!this.myTestResult.booleanValue()) {
                this.setErrorText(GitBundle.getString("clone.test.failed.error"));
                this.setOKActionEnabled(false);
                return false;
            }
            return true;
        }
        try {
            if (new URI(repository).isAbsolute()) {
                return true;
            }
        }
        catch (URISyntaxException urlExp) {
            // empty catch block
        }
        if (SSH_URL_PATTERN.matcher(repository).matches()) {
            return true;
        }
        try {
            File file = new File(repository);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    this.setErrorText(GitBundle.getString("clone.url.is.not.directory.error"));
                    this.setOKActionEnabled(false);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setErrorText(GitBundle.getString("clone.invalid.url"));
        this.setOKActionEnabled(false);
        return false;
    }

    private static String defaultDirectoryName(String url) {
        String nonSystemName = url.endsWith("/.git") || url.endsWith(File.separator + ".git") ? url.substring(0, url.length() - 5) : (url.endsWith(".git") ? url.substring(0, url.length() - 4) : url);
        int i = nonSystemName.lastIndexOf(47);
        if (i == -1 && File.separatorChar != '/') {
            i = nonSystemName.lastIndexOf(File.separatorChar);
        }
        return i >= 0 ? nonSystemName.substring(i + 1) : "";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return "GitCloneDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryURL;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CloneRepository";
    }

    private static GitSimpleHandler checkRepository(Project project, String url) {
        GitSimpleHandler handler = new GitSimpleHandler(project, new File("."), GitCommand.LS_REMOTE);
        handler.addParameters(url, "master");
        return handler;
    }

    static {
        String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        String path = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        String all = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("clone.repository.url"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 3, 0, 1, 6, 1, null, null, null));
        this.myRepositoryURL = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("clone.parent.dir"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("clone.dir.name"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("clone.test"));
        jPanel.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDirectoryName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("clone.origin"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOriginName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

