/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.HashMap;
import git4idea.GitRemote;
import git4idea.commands.StringScanner;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitRefspecAddRefsDialog;
import git4idea.ui.GitUIUtil;
import git4idea.validators.GitBranchNameValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GitRefspecPanel
extends JPanel {
    private static final Logger log = Logger.getInstance((String)Logger.class.getName());
    private final HashMap<String, GitRemote> myRemotes;
    private Project myProject;
    private VirtualFile myGitRoot;
    private final SortedSet<String> myRemoteHeads;
    private final SortedSet<String> myRemoteTags;
    private JButton myAddAllBranchesButton;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JTextField myRemoteNameTextField;
    private JPanel myPanel;
    private JTable myReferences;
    private JButton myAddAllTagsButton;
    private JButton myDefaultButton;
    private String myRemote;
    private ReferenceSource myReferenceSource;
    private final MyMappingTableModel myReferencesModel;

    public GitRefspecPanel() {
        super(new GridBagLayout());
        this.$$$setupUI$$$();
        this.myRemotes = new HashMap();
        this.myRemoteHeads = new TreeSet<String>();
        this.myRemoteTags = new TreeSet<String>();
        this.myReferencesModel = new MyMappingTableModel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.myPanel, c);
        this.setupTable();
        this.setupButtons();
    }

    @Nullable
    public String validateFields() {
        String remote = this.getRemoteName();
        if (remote.length() == 0) {
            if (this.myReferencesModel.isRemoteNameUsed()) {
                return GitBundle.getString("refspec.validation.remote.is.blank");
            }
        } else if (!GitBranchNameValidator.INSTANCE.checkInput(remote)) {
            return GitBundle.getString("refspec.validation.remote.invalid");
        }
        return null;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    private void setupButtons() {
        this.myReferences.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitRefspecPanel.this.myRemoveButton.setEnabled(GitRefspecPanel.this.myReferences.getSelectedRowCount() != 0);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRefspecPanel.this.myReferencesModel.removeSelectedMapping();
            }
        });
        this.myAddAllTagsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRefspecPanel.this.myReferencesModel.addMapping(false, GitRefspecPanel.tagName("*"), GitRefspecPanel.tagName("*"));
            }
        });
        this.myAddAllBranchesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRefspecPanel.this.addAllBranches();
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GitRefspecPanel.this.myGitRoot == null) {
                    throw new IllegalStateException("Git root must be already set at this point.");
                }
                GitRefspecAddRefsDialog d = new GitRefspecAddRefsDialog(GitRefspecPanel.this.myProject, GitRefspecPanel.this.myGitRoot, GitRefspecPanel.this.myRemote, GitRefspecPanel.this.myRemoteTags, GitRefspecPanel.this.myRemoteHeads);
                d.show();
                if (!d.isOK()) {
                    return;
                }
                for (String tag : d.getSelected(true)) {
                    GitRefspecPanel.this.myReferencesModel.addMapping(false, tag, tag);
                }
                for (String head : d.getSelected(false)) {
                    GitRefspecPanel.this.myReferencesModel.addMapping(true, head, GitRefspecPanel.this.remoteName(head.substring("refs/heads/".length())));
                }
            }
        });
        this.myDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String remote = GitRefspecPanel.this.myRemote;
                GitRefspecPanel.this.setRemote(null);
                GitRefspecPanel.this.setRemote(remote);
            }
        });
    }

    private void addAllBranches() {
        this.myReferencesModel.addMapping(false, GitRefspecPanel.headName("*"), this.remoteName("*"));
    }

    private static String tagRemoteName(String remoteName, String tagName) {
        return "refs/tags/" + remoteName + "/" + tagName;
    }

    private static String tagName(String tagName) {
        return "refs/tags/" + tagName;
    }

    private String remoteName(String headName) {
        return GitRefspecPanel.remoteName(this.getRemoteName(), headName);
    }

    private static String remoteName(String remote, String headName) {
        return remote.length() != 0 ? "refs/remotes/" + remote + "/" + headName : GitRefspecPanel.headName(headName);
    }

    private static String headName(String head) {
        return "refs/heads/" + head;
    }

    public String getRemoteName() {
        return this.myRemoteNameTextField.getText();
    }

    private void setupTable() {
        this.myReferences.setModel(this.myReferencesModel);
        this.myReferences.setSelectionMode(2);
        this.myReferences.getColumnModel().getColumn(0).sizeWidthToFit();
        this.myRemoteNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitRefspecPanel.this.myReferencesModel.remoteUpdated();
            }
        });
    }

    public void setGitRoot(VirtualFile gitRoot) {
        if (gitRoot == this.myGitRoot) {
            return;
        }
        this.myGitRoot = gitRoot;
        this.myRemotes.clear();
        if (this.myGitRoot != null) {
            try {
                for (GitRemote r : GitRemote.list(this.myProject, this.myGitRoot)) {
                    this.myRemotes.put((Object)r.name(), (Object)r);
                }
            }
            catch (VcsException e) {
                GitUIUtil.showOperationError(this.myProject, e, "listing remotes");
            }
        }
    }

    public void setRemote(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (this.myRemote == null && name == null || this.myRemote != null && this.myRemote.equals(name)) {
            return;
        }
        this.myRemote = name;
        this.myAddButton.setEnabled(this.myRemote != null && this.myRemote.length() != 0);
        GitRemote remote = (GitRemote)this.myRemotes.get((Object)name);
        if (remote != null) {
            this.myRemoteNameTextField.setText(name);
            this.myRemoteNameTextField.setEditable(false);
            this.myDefaultButton.setEnabled(true);
        } else {
            this.myRemoteNameTextField.setText("");
            this.myRemoteNameTextField.setEditable(true);
            this.myDefaultButton.setEnabled(false);
        }
        this.myRemoteHeads.clear();
        this.myRemoteTags.clear();
        this.setDefaultMapping();
    }

    private void setDefaultMapping() {
        GitRemote remote = (GitRemote)this.myRemotes.get((Object)this.myRemote);
        this.myReferencesModel.clear();
        if (remote != null && this.myReferenceSource == ReferenceSource.FETCH) {
            try {
                for (String ref : GitRemote.getFetchSpecs(this.myProject, this.myGitRoot, remote.name())) {
                    StringScanner s = new StringScanner(ref);
                    boolean force = s.tryConsume('+');
                    String remotePart = s.boundedToken(':');
                    String localPart = s.line();
                    this.myReferencesModel.addMapping(force, remotePart, localPart);
                }
            }
            catch (VcsException e) {
                log.error("Failed to get fetch references ", (Throwable)e);
            }
        } else {
            this.addAllBranches();
        }
    }

    public void addValidationRequiredListener(final ActionListener l) {
        this.myRemoteNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                l.actionPerformed(new ActionEvent(GitRefspecPanel.this.myRemoteNameTextField, 1001, "validationRequired"));
            }
        });
    }

    public void setReferenceSource(ReferenceSource referenceSource) {
        this.myReferenceSource = referenceSource;
    }

    public String[] getReferences() {
        return this.myReferencesModel.getReferences();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JTable jTable;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Font font = jPanel.getFont();
        jPanel.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.title"), 0, 2, new Font(font.getName(), font.getStyle(), font.getSize()), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myReferences = jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddAllBranchesButton = jButton5 = new JButton();
        jButton5.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.add.all.branches.tooltip"));
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.add.all.branches"));
        jPanel2.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddButton = jButton4 = new JButton();
        jButton4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.add.ref.tooltip"));
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.add.ref"));
        ((Component)jButton4).setEnabled(false);
        jPanel2.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton3 = new JButton();
        jButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.remove.tooltip"));
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.remove"));
        jPanel2.add((Component)jButton3, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAddAllTagsButton = jButton2 = new JButton();
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.add.all.tags.tooltip"));
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.add.all.tags"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDefaultButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.default.tooltip"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.default"));
        ((Component)jButton).setEnabled(false);
        jPanel2.add((Component)jButton, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.branch.prefix"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRemoteNameTextField = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("refspec.branch.prefix.tooltip"));
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static enum ReferenceSource {
        FETCH,
        PUSH;

    }

    private class MyMappingTableModel
    extends AbstractTableModel {
        private static final int FORCE_COLUMN = 0;
        private static final int REMOTE_COLUMN = 1;
        private static final int LOCAL_COLUMN = 2;
        private String mySavedRemoteName = null;
        private final ArrayList<RefMapping> myMapping = new ArrayList();

        private MyMappingTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.myMapping.size();
        }

        public void removeSelectedMapping() {
            int[] rows = GitRefspecPanel.this.myReferences.getSelectedRows();
            Arrays.sort(rows);
            for (int i = rows.length - 1; i >= 0; --i) {
                this.myMapping.remove(rows[i]);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            RefMapping m = this.myMapping.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    m.force = (Boolean)aValue;
                    break;
                }
                case 2: {
                    m.local = (String)aValue;
                    break;
                }
                case 1: {
                    m.remote = (String)aValue;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid column: " + columnIndex);
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return GitBundle.getString("refspec.column.force");
                }
                case 2: {
                    return GitBundle.getString("refspec.column.local");
                }
                case 1: {
                    return GitBundle.getString("refspec.column.remote");
                }
            }
            throw new IllegalStateException("Invalid column: " + column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RefMapping m = this.myMapping.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return m.force;
                }
                case 2: {
                    return m.local;
                }
                case 1: {
                    return m.remote;
                }
            }
            throw new IllegalStateException("Invalid column: " + columnIndex);
        }

        public void addMapping(boolean force, @NonNls String remote, @NonNls String local) {
            RefMapping m = new RefMapping();
            m.force = force;
            m.remote = remote;
            m.local = local;
            int row = this.myMapping.size();
            this.myMapping.add(m);
            this.fireTableRowsInserted(row, row);
            if (this.mySavedRemoteName == null) {
                this.remoteUpdated();
            }
        }

        private void remoteUpdated() {
            String newText = GitRefspecPanel.this.myRemoteNameTextField.getText();
            if (this.mySavedRemoteName != null && !newText.equals(this.mySavedRemoteName)) {
                String oldTagsPrefix = GitRefspecPanel.tagRemoteName(this.mySavedRemoteName, "");
                String newTagsPrefix = GitRefspecPanel.tagRemoteName(newText, "");
                String oldHeadsPrefix = GitRefspecPanel.remoteName(this.mySavedRemoteName, "");
                String newHeadsPrefix = GitRefspecPanel.remoteName(newText, "");
                for (RefMapping m : this.myMapping) {
                    if (m.local.startsWith(oldTagsPrefix)) {
                        m.local = newTagsPrefix + m.local.substring(oldTagsPrefix.length());
                        continue;
                    }
                    if (!m.local.startsWith(oldHeadsPrefix)) continue;
                    m.local = newHeadsPrefix + m.local.substring(oldHeadsPrefix.length());
                }
                this.fireTableDataChanged();
            }
            this.mySavedRemoteName = newText;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        boolean isRemoteNameUsed() {
            String text = GitRefspecPanel.this.myRemoteNameTextField.getText();
            String tagsPrefix = GitRefspecPanel.tagRemoteName(text, "");
            for (RefMapping m : this.myMapping) {
                if (!m.local.startsWith(tagsPrefix)) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            this.myMapping.clear();
            this.fireTableDataChanged();
        }

        public String[] getReferences() {
            int n = this.myMapping.size();
            String[] rc = new String[n];
            for (int i = 0; i < n; ++i) {
                rc[i] = this.myMapping.get(i).toString();
            }
            return rc;
        }

        class RefMapping {
            boolean force;
            String remote;
            String local;

            RefMapping() {
            }

            public String toString() {
                return (this.force ? "+" : "") + this.remote + ":" + this.local;
            }
        }
    }
}

