/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import com.siyeh.ipp.psiutils.ConcatenationUtils;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithStringBufferIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate();
        if (simpleStringConcatenationPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/concatenation/ReplaceConcatenationWithStringBufferIntention.getElementPredicate must not return null");
        }
        return simpleStringConcatenationPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/concatenation/ReplaceConcatenationWithStringBufferIntention.processIntention must not be null");
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiElement parent = expression.getParent();
        if (parent == null) {
            return;
        }
        while (ConcatenationUtils.isConcatenation(parent)) {
            expression = (PsiBinaryExpression)parent;
            if ((parent = expression.getParent()) != null) continue;
            return;
        }
        StringBuilder newExpression = new StringBuilder();
        if (ReplaceConcatenationWithStringBufferIntention.isPartOfStringBufferAppend((PsiExpression)expression)) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            assert (methodCallExpression != null);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                String qualifierText = qualifierExpression.getText();
                newExpression.append(qualifierText);
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression, newExpression);
            ReplaceConcatenationWithStringBufferIntention.replaceExpression(newExpression.toString(), (PsiExpression)methodCallExpression);
        } else {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                newExpression.append("new StringBuffer()");
            } else {
                newExpression.append("new StringBuilder()");
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression, newExpression);
            newExpression.append(".toString()");
            ReplaceConcatenationWithStringBufferIntention.replaceExpression(newExpression.toString(), (PsiExpression)expression);
        }
    }

    private static boolean isPartOfStringBufferAppend(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiType type = methodExpression.getType();
        if (type == null) {
            return false;
        }
        String className = type.getCanonicalText();
        if (!"java.lang.StringBuffer".equals(className) && !"java.lang.StringBuilder".equals(className)) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        return "append".equals(methodName);
    }

    private static void turnExpressionIntoChainedAppends(PsiExpression expression, @NonNls StringBuilder result) {
        if (ConcatenationUtils.isConcatenation((PsiElement)expression)) {
            PsiBinaryExpression concatenation = (PsiBinaryExpression)expression;
            PsiExpression lhs = concatenation.getLOperand();
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(lhs, result);
            PsiExpression rhs = concatenation.getROperand();
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(rhs, result);
        } else {
            PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
            result.append(".append(");
            if (strippedExpression != null) {
                result.append(strippedExpression.getText());
            }
            result.append(')');
        }
    }
}

