/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.LanguageSelector;
import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class NewCodeStyleSettingsPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel");
    private final Configurable myTab;

    public NewCodeStyleSettingsPanel(Configurable tab) {
        super(new BorderLayout());
        this.myTab = tab;
        JComponent component = this.myTab.createComponent();
        this.add((Component)component, "Center");
    }

    public boolean isModified() {
        return this.myTab.isModified();
    }

    public void updatePreview() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).getPanel().onSomethingChanged();
        }
    }

    public void apply() {
        try {
            if (this.myTab.isModified()) {
                this.myTab.apply();
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public String getHelpTopic() {
        return this.myTab.getHelpTopic();
    }

    public void dispose() {
        this.myTab.disposeUIResources();
    }

    public void reset() {
        this.myTab.reset();
        this.updatePreview();
    }

    public String getDisplayName() {
        return this.myTab.getDisplayName();
    }

    public void setModel(CodeStyleSchemesModel model) {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).setModel(model);
        }
    }

    public void setLanguageSelector(LanguageSelector langSelector) {
        CodeStyleAbstractConfigurable configurable;
        if (this.myTab instanceof CodeStyleAbstractConfigurable && (configurable = (CodeStyleAbstractConfigurable)this.myTab).getPanel() instanceof MultilanguageCodeStyleAbstractPanel) {
            ((MultilanguageCodeStyleAbstractPanel)configurable.getPanel()).setLanguageSelector(langSelector);
        }
    }

    public void onSomethingChanged() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).onSomethingChanged();
        }
    }

    public void resetFromClone() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).resetFromClone();
        }
    }

    public void setLanguage(Language language) {
        CodeStyleAbstractConfigurable configurable;
        if (this.myTab instanceof CodeStyleAbstractConfigurable && (configurable = (CodeStyleAbstractConfigurable)this.myTab).getPanel() instanceof MultilanguageCodeStyleAbstractPanel) {
            ((MultilanguageCodeStyleAbstractPanel)configurable.getPanel()).setPanelLanguage(language);
        }
    }
}

