/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CastMethodArgumentFix
extends MethodArgumentFix {
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private CastMethodArgumentFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getText() {
        String string;
        if (this.myArgList.getExpressions().length == 1) {
            string = QuickFixBundle.message("cast.single.parameter.text", HighlightUtil.formatType(this.myToType));
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix.getText must not return null");
            return string;
        }
        string = QuickFixBundle.message("cast.parameter.text", this.myIndex + 1, HighlightUtil.formatType(this.myToType));
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix.getText must not return null");
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public CastMethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new CastMethodArgumentFix(list, i, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression.getType();
            if (exprType instanceof PsiClassType && toType instanceof PsiPrimitiveType) {
                toType = ((PsiPrimitiveType)toType).getBoxedType((PsiElement)expression);
                assert (toType != null);
            }
            return AddTypeCastFix.createCastExpression(expression, expression.getProject(), toType);
        }

        @Override
        public boolean areTypesConvertible(PsiType exprType, PsiType parameterType, PsiElement context) {
            if (exprType instanceof PsiClassType && parameterType instanceof PsiPrimitiveType && (parameterType = ((PsiPrimitiveType)parameterType).getBoxedType(context)) == null) {
                return false;
            }
            return parameterType.isConvertibleFrom(exprType);
        }
    }
}

