/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class StaticImportMethodFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix");
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
    private List<PsiMethod> candidates;

    public StaticImportMethodFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.<init> must not be null");
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        String text = QuickFixBundle.message("static.import.method.text", new Object[0]);
        if (this.candidates.size() == 1) {
            int options = 6145;
            text = text + " '" + PsiFormatUtil.formatMethod((PsiMethod)this.candidates.get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0) + "'";
        } else {
            text = text + "...";
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.isAvailable must not be null");
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && this.myMethodCall != null && this.myMethodCall.getElement() != null && ((PsiMethodCallExpression)this.myMethodCall.getElement()).isValid() && ((PsiMethodCallExpression)this.myMethodCall.getElement()).getMethodExpression().getQualifierExpression() == null && file.getManager().isInProject((PsiElement)file) && !(this.candidates == null ? (this.candidates = this.getMethodsToImport()) : this.candidates).isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        ArrayList<PsiMethod> arrayList;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myMethodCall.getProject());
        PsiShortNamesCache cache = facade.getShortNamesCache();
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiReferenceExpression reference = element.getMethodExpression();
        PsiExpressionList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            arrayList = list;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.getMethodsToImport must not return null");
            return arrayList;
        }
        GlobalSearchScope scope = element.getResolveScope();
        PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, 20);
        ArrayList<PsiMethod> applicableList = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            PsiFile file;
            ProgressManager.checkCanceled();
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && JavaCompletionUtil.isInExcludedPackage(aClass) || !method.hasModifierProperty("static") || !((file = method.getContainingFile()) instanceof PsiJavaFile) || ((PsiJavaFile)file).getPackageName().length() == 0 || !PsiUtil.isAccessible((PsiMember)method, (PsiElement)element, (PsiClass)aClass)) continue;
            list.add(method);
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpressionList)argumentList)) continue;
            applicableList.add(method);
        }
        ArrayList<PsiMethod> arrayList2 = applicableList.isEmpty() ? list : applicableList;
        Collections.sort(arrayList2, new PsiProximityComparator((PsiElement)argumentList));
        arrayList = arrayList2;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.getMethodsToImport must not return null");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        if (this.candidates.size() == 1) {
            PsiMethod toImport = this.candidates.get(0);
            this.doImport(toImport);
        } else {
            this.chooseAndImport(editor);
        }
    }

    private void doImport(final PsiMethod toImport) {
        CommandProcessor.getInstance().executeCommand(toImport.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiMethodCallExpression element = (PsiMethodCallExpression)StaticImportMethodFix.this.myMethodCall.getElement();
                            if (element != null) {
                                element.getMethodExpression().bindToElementViaStaticImport(toImport.getContainingClass());
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, this.getText(), (Object)this);
    }

    private void chooseAndImport(Editor editor) {
        final JList<PsiMethod> list = new JList<PsiMethod>(new Vector<PsiMethod>(this.candidates));
        list.setCellRenderer(new MethodCellRenderer(true));
        new PopupChooserBuilder(list).setTitle(QuickFixBundle.message("static.import.method.choose.method.to.import", new Object[0])).setMovable(true).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                PsiMethod selectedValue = (PsiMethod)list.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                LOG.assertTrue(selectedValue.isValid());
                StaticImportMethodFix.this.doImport(selectedValue);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

