/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.GenerateAccessorProviderRegistrar;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class GenerateGetterSetterHandlerBase
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateGetterSetterHandlerBase");

    public GenerateGetterSetterHandlerBase(String chooserTitle) {
        super(chooserTitle);
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(final PsiClass aClass) {
        List<EncapsulatableClassMember> list = GenerateAccessorProviderRegistrar.getEncapsulatableClassMembers(aClass);
        List members = ContainerUtil.findAll(list, (Condition)new Condition<EncapsulatableClassMember>(){

            public boolean value(EncapsulatableClassMember member) {
                try {
                    return GenerateGetterSetterHandlerBase.this.generateMemberPrototypes(aClass, member).length > 0;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return false;
                }
            }
        });
        return members.toArray(new ClassMember[members.size()]);
    }

    static {
        GenerateAccessorProviderRegistrar.registerProvider(new NotNullFunction<PsiClass, Collection<EncapsulatableClassMember>>(){

            @NotNull
            public Collection<EncapsulatableClassMember> fun(PsiClass s) {
                ArrayList<EncapsulatableClassMember> result = new ArrayList<EncapsulatableClassMember>();
                for (PsiField field : s.getFields()) {
                    if (field instanceof PsiEnumConstant) continue;
                    result.add(new PsiFieldMember(field));
                }
                ArrayList<EncapsulatableClassMember> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateGetterSetterHandlerBase$1.fun must not return null");
                }
                return arrayList;
            }
        });
    }
}

