/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightManagerImpl
extends HighlightManager
implements ProjectComponent {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightInfo>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getComponentName() {
        if ("HighlightManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/HighlightManagerImpl.getComponentName must not return null");
        }
        return "HighlightManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        MyAnActionListener anActionListener = new MyAnActionListener();
        ActionManagerEx.getInstanceEx().addAnActionListener(anActionListener, (Disposable)this.myProject);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                Editor[] editors;
                Document document = event.getDocument();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                    Map<RangeHighlighter, HighlightInfo> map = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map.keySet()) {
                        HighlightInfo info = map.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || (info.flags & 4) == 0) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
    }

    public void projectClosed() {
    }

    @Nullable
    public Map<RangeHighlighter, HighlightInfo> getHighlightInfoMap(Editor editor, boolean toCreate) {
        Map map = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY);
        if (map == null && toCreate) {
            map = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, (Object)new HashMap());
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public RangeHighlighter[] getHighlighters(Editor editor) {
        RangeHighlighter[] rangeHighlighterArray;
        Map<RangeHighlighter, HighlightInfo> highlightersMap = this.getHighlightInfoMap(editor, false);
        if (highlightersMap == null) {
            rangeHighlighterArray = RangeHighlighter.EMPTY_ARRAY;
            if (RangeHighlighter.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/HighlightManagerImpl.getHighlighters must not return null");
            return rangeHighlighterArray;
        }
        HashSet<RangeHighlighter> set = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightInfo> entry : highlightersMap.entrySet()) {
            HighlightInfo info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set.add(entry.getKey());
        }
        rangeHighlighterArray = set.toArray(new RangeHighlighter[set.size()]);
        if (rangeHighlighterArray != null) return rangeHighlighterArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/HighlightManagerImpl.getHighlighters must not return null");
    }

    private RangeHighlighter addSegmentHighlighter(Editor editor, int startOffset, int endOffset, TextAttributes attributes, int flags) {
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        HighlightInfo info = new HighlightInfo(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, true);
        map.put(highlighter, info);
        return highlighter;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.removeSegmentHighlighter must not be null");
        }
        if (highlighter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.removeSegmentHighlighter must not be null");
        }
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, false);
        if (map == null) {
            return false;
        }
        HighlightInfo info = map.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            markupModel.removeHighlighter(highlighter);
        }
        map.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiReference[] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlights must not be null");
        }
        if (occurrences == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlights must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlights must not be null");
        }
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project;
            PsiElement element = occurrence.getElement();
            int startOffset = element.getTextRange().getStartOffset();
            int start = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project = element.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start, end, attributes, flags, outHighlighters, scrollmarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addElementsOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addElementsOccurrenceHighlights must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addElementsOccurrenceHighlights must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addElementsOccurrenceHighlights must not be null");
        }
        this.addOccurrenceHighlights(editor, elements, attributes, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start, int end, TextAttributes attributes, int flags, Collection<RangeHighlighter> outHighlighters, Color scrollmarkColor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlight must not be null");
        }
        RangeHighlighter highlighter = this.addSegmentHighlighter(editor, start, end, attributes, flags);
        if (outHighlighters != null) {
            outHighlighters.add(highlighter);
        }
        if (scrollmarkColor != null) {
            highlighter.setErrorStripeMarkColor(scrollmarkColor);
        }
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addRangeHighlight must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addRangeHighlight must not be null");
        }
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addRangeHighlight must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addRangeHighlight must not be null");
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, flags, highlighters, scrollmarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlights must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlights must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/highlighting/HighlightManagerImpl.addOccurrenceHighlights must not be null");
        }
        if (elements.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            int offset = PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)element);
            int start = range.getStartOffset() + offset;
            int end = range.getEndOffset() + offset;
            this.addOccurrenceHighlight(editor, start, end, attributes, flags, outHighlighters, scrollmarkColor);
        }
    }

    @Nullable
    private static Color getScrollMarkColor(TextAttributes attributes) {
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            return attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(Editor editor, int mask) {
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, false);
        if (map == null) {
            return false;
        }
        boolean done = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map.keySet()) {
            HighlightInfo info = map.get(highlighter);
            if (!info.editor.equals(editor) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done;
    }

    static class HighlightInfo {
        final Editor editor;
        final int flags;

        public HighlightInfo(Editor editor, int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        @Override
        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            this.requestHideHighlights(dataContext);
        }

        @Override
        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        @Override
        public void beforeEditorTyping(char c, DataContext dataContext) {
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(DataContext dataContext) {
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }
    }
}

