/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupItem<T>
extends MutableLookupElement<T>
implements Comparable {
    public static final Object HIGHLIGHTED_ATTR = Key.create((String)"highlighted");
    public static final Object ICON_ATTR = Key.create((String)"icon");
    public static final Object TYPE_TEXT_ATTR = Key.create((String)"typeText");
    public static final Object TAIL_TEXT_ATTR = Key.create((String)"tailText");
    public static final Object TAIL_TEXT_SMALL_ATTR = Key.create((String)"tailTextSmall");
    public static final Key<Object> FORCE_SHOW_SIGNATURE_ATTR = Key.create((String)"forceShowSignature");
    public static final Object GENERATE_ANONYMOUS_BODY_ATTR = Key.create((String)"GENERATE_ANONYMOUS_BODY_ATTR");
    public static final Key<Object> BRACKETS_COUNT_ATTR = Key.create((String)"BRACKETS_COUNT_ATTR");
    public static final Key<Object> OVERWRITE_ON_AUTOCOMPLETE_ATTR = Key.create((String)"OVERWRITE_ON_AUTOCOMPLETE_ATTR");
    public static final Object NEW_OBJECT_ATTR = Key.create((String)"NEW_OBJECT_ATTR");
    public static final Object DONT_CHECK_FOR_INNERS = Key.create((String)"DONT_CHECK_FOR_INNERS");
    public static final Object FORCE_QUALIFY = Key.create((String)"FORCE_QUALIFY");
    public static final Object SUBSTITUTOR = Key.create((String)"SUBSTITUTOR");
    public static final Object TYPE = Key.create((String)"TYPE");
    public static final Object INDICATE_ANONYMOUS = Key.create((String)"INDICATE ANONYMOUS");
    public static final Key<Object> DEPRECATED_ATTR = Key.create((String)"DEPRECATED");
    public static final Object CASE_INSENSITIVE = Key.create((String)"CASE_INSENSITIVE");
    public static final Key<TailType> TAIL_TYPE_ATTR = Key.create((String)"myTailType");
    private Object myObject;
    private String myLookupString;
    private InsertHandler myInsertHandler;
    private double myPriority;
    private int myGrouping;
    private Map<Object, Object> myAttributes;
    public static final LookupItem[] EMPTY_ARRAY = new LookupItem[0];
    private final Set<String> myAllLookupStrings;
    private String myPresentable;
    private AutoCompletionPolicy myAutoCompletionPolicy;

    public LookupItem(T o, @NotNull @NonNls String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.<init> must not be null");
        }
        this.myAttributes = null;
        this.myAllLookupStrings = new THashSet();
        this.myAutoCompletionPolicy = AutoCompletionPolicy.SETTINGS_DEPENDENT;
        this.setObject(o);
        this.setLookupString(lookupString);
    }

    public static LookupItem fromString(String s) {
        return new LookupItem<String>(s, s);
    }

    public void setObject(@NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.setObject must not be null");
        }
        this.myObject = o;
        if (o instanceof LookupValueWithPriority) {
            this.setPriority(((LookupValueWithPriority)o).getPriority());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LookupItem) {
            LookupItem item = (LookupItem)o;
            return Comparing.equal((Object)this.myObject, (Object)item.myObject) && Comparing.equal((String)this.myLookupString, (String)item.myLookupString) && Comparing.equal(this.myAllLookupStrings, item.myAllLookupStrings) && Comparing.equal(this.myAttributes, item.myAttributes);
        }
        return false;
    }

    public int hashCode() {
        T object = this.getObject();
        assert (object != this) : this.getClass().getName();
        return ((Object)this.myAllLookupStrings).hashCode() * 239 + object.hashCode();
    }

    public String toString() {
        return this.getLookupString();
    }

    @NotNull
    public T getObject() {
        Object object = this.myObject;
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.getObject must not return null");
        }
        return (T)object;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.getLookupString must not return null");
        }
        return string;
    }

    public void setLookupString(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.setLookupString must not be null");
        }
        if (this.myAllLookupStrings.contains("")) {
            this.myAllLookupStrings.remove("");
        }
        this.myLookupString = lookupString;
        this.myAllLookupStrings.add(lookupString);
    }

    public Object getAttribute(Object key) {
        if (this.myAttributes != null) {
            return this.myAttributes.get(key);
        }
        return null;
    }

    public <T> T getAttribute(Key<T> key) {
        if (this.myAttributes != null) {
            return (T)this.myAttributes.get(key);
        }
        return null;
    }

    public void setAttribute(Object key, Object value) {
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap(5);
        }
        this.myAttributes.put(key, value);
    }

    public <T> void setAttribute(Key<T> key, T value) {
        if (value == null && this.myAttributes != null) {
            this.myAttributes.remove(key);
            return;
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap(5);
        }
        this.myAttributes.put(key, value);
    }

    public InsertHandler<? extends LookupItem> getInsertHandler() {
        return this.myInsertHandler;
    }

    public boolean isBold() {
        return this.getAttribute(HIGHLIGHTED_ATTR) != null;
    }

    public void handleInsert(InsertionContext context) {
        InsertHandler<LookupItem> handler;
        if (Boolean.TRUE.equals(this.getAttribute(CASE_INSENSITIVE))) {
            CompletionService.getCompletionService().correctCaseInsensitiveString((LookupElement)this, context);
        }
        if ((handler = this.getInsertHandler()) != null) {
            handler.handleInsert(context, (LookupElement)this);
        }
        if (this.getTailType() != TailType.UNKNOWN && this.myInsertHandler == null) {
            context.setAddCompletionChar(false);
            TailType type = LookupItem.handleCompletionChar(context.getEditor(), (LookupElement)this, context.getCompletionChar());
            type.processTail(context.getEditor(), context.getTailOffset());
        }
    }

    @Nullable
    public static TailType getDefaultTailType(char completionChar) {
        switch (completionChar) {
            case '.': {
                return TailType.DOT;
            }
            case ',': {
                return TailType.COMMA;
            }
            case ';': {
                return TailType.SEMICOLON;
            }
            case '=': {
                return TailType.EQ;
            }
            case ' ': {
                return TailType.SPACE;
            }
            case ':': {
                return TailType.CASE_COLON;
            }
            case '\r': {
                return TailType.SMART_COMPLETION;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TailType handleCompletionChar(@NotNull Editor editor, @NotNull LookupElement lookupElement, char completionChar) {
        TailType tailType;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.handleCompletionChar must not be null");
        }
        if (lookupElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.handleCompletionChar must not be null");
        }
        TailType type = LookupItem.getDefaultTailType(completionChar);
        if (type != null) {
            tailType = type;
            if (tailType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.handleCompletionChar must not return null");
            return tailType;
        }
        LookupItem item = (LookupItem)lookupElement;
        TailType attr = item.getAttribute(CompletionUtil.TAIL_TYPE_ATTR);
        tailType = attr != null ? attr : TailType.NONE;
        if (tailType != null) return tailType;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.handleCompletionChar must not return null");
    }

    @NotNull
    public TailType getTailType() {
        TailType tailType = this.getAttribute(TAIL_TYPE_ATTR);
        TailType tailType2 = tailType != null ? tailType : TailType.UNKNOWN;
        if (tailType2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.getTailType must not return null");
        }
        return tailType2;
    }

    @NotNull
    public LookupItem<T> setTailType(@NotNull TailType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.setTailType must not be null");
        }
        this.setAttribute((Key<T>)TAIL_TYPE_ATTR, (T)type);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setTailType must not return null");
        }
        return lookupItem;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getLookupString().compareTo((String)o);
        }
        if (!(o instanceof LookupItem)) {
            throw new RuntimeException("Trying to compare LookupItem with " + o.getClass() + "!!!");
        }
        return this.getLookupString().compareTo(((LookupItem)o).getLookupString());
    }

    public LookupItem<T> setInsertHandler(@NotNull InsertHandler<? extends LookupElement> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.setInsertHandler must not be null");
        }
        this.myInsertHandler = handler;
        return this;
    }

    public void renderElement(LookupElementPresentation presentation) {
        for (ElementLookupRenderer renderer : (ElementLookupRenderer[])Extensions.getExtensions(ElementLookupRenderer.EP_NAME)) {
            if (!renderer.handlesItem(this.getObject())) continue;
            renderer.renderElement(this, this.getObject(), presentation);
            return;
        }
        DefaultLookupItemRenderer.INSTANCE.renderElement(this, presentation);
    }

    public LookupItem<T> setBold() {
        this.setAttribute(HIGHLIGHTED_ATTR, "");
        return this;
    }

    public LookupItem<T> forceQualify() {
        this.setAttribute(FORCE_QUALIFY, "");
        return this;
    }

    public LookupItem<T> setDeprecated(boolean deprecated) {
        this.setAttribute((Key<T>)DEPRECATED_ATTR, (T)(deprecated ? "" : null));
        return this;
    }

    public LookupItem<T> setAutoCompletionPolicy(AutoCompletionPolicy policy) {
        this.myAutoCompletionPolicy = policy;
        return this;
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.myAutoCompletionPolicy;
    }

    @NotNull
    public LookupItem<T> setIcon(Icon icon) {
        this.setAttribute(ICON_ATTR, icon);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setIcon must not return null");
        }
        return lookupItem;
    }

    @NotNull
    public LookupItem<T> setPriority(double priority) {
        this.myPriority = priority;
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setPriority must not return null");
        }
        return lookupItem;
    }

    @NotNull
    public LookupItem<T> setGrouping(int grouping) {
        this.myGrouping = grouping;
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setGrouping must not return null");
        }
        return lookupItem;
    }

    public final double getPriority() {
        return this.myPriority;
    }

    @NotNull
    public LookupItem<T> setPresentableText(@NotNull String displayText) {
        if (displayText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupItem.setPresentableText must not be null");
        }
        this.myPresentable = displayText;
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setPresentableText must not return null");
        }
        return lookupItem;
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentable;
    }

    @NotNull
    public LookupItem<T> setTypeText(String text) {
        this.setAttribute(TYPE_TEXT_ATTR, text);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setTypeText must not return null");
        }
        return lookupItem;
    }

    @NotNull
    public MutableLookupElement<T> setTailText(String text, boolean grayed) {
        this.setAttribute(TAIL_TEXT_ATTR, text);
        this.setAttribute(TAIL_TEXT_SMALL_ATTR, Boolean.TRUE);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setTailText must not return null");
        }
        return lookupItem;
    }

    @NotNull
    public LookupItem<T> setCaseSensitive(boolean caseSensitive) {
        this.setAttribute(CASE_INSENSITIVE, (Object)(!caseSensitive ? 1 : 0));
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupItem.setCaseSensitive must not return null");
        }
        return lookupItem;
    }

    public LookupItem<T> addLookupStrings(String ... additionalLookupStrings) {
        this.myAllLookupStrings.addAll(Arrays.asList(additionalLookupStrings));
        return this;
    }

    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }

    public void copyAttributes(LookupItem item) {
        if (this.myAttributes == null) {
            if (item.myAttributes == null) {
                return;
            }
            this.myAttributes = new HashMap(5);
        }
        this.myAttributes.putAll(item.myAttributes);
    }

    public boolean isCaseSensitive() {
        return !Boolean.TRUE.equals(this.getAttribute(CASE_INSENSITIVE));
    }

    @Nullable
    public static LookupItem from(LookupElement lookupElement) {
        if (lookupElement instanceof LookupElementDecorator) {
            lookupElement = ((LookupElementDecorator)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupItem) {
            return (LookupItem)lookupElement;
        }
        return null;
    }
}

