/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeLookupItem
extends LookupItem {
    public PsiTypeLookupItem(Object o, @NotNull @NonNls String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/PsiTypeLookupItem.<init> must not be null");
        }
        super(o, lookupString);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof PsiTypeLookupItem && this.getBracketsCount() == ((PsiTypeLookupItem)o).getBracketsCount();
    }

    @Override
    public int hashCode() {
        int fromSuper = super.hashCode();
        int dim = this.getBracketsCount();
        return fromSuper + dim * 31;
    }

    public int getBracketsCount() {
        Integer integer = (Integer)this.getUserData(BRACKETS_COUNT_ATTR);
        return integer == null ? 0 : integer;
    }

    public static LookupItem createLookupItem(@NotNull PsiType type, @Nullable PsiElement context) {
        PsiTypeLookupItem item;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/PsiTypeLookupItem.createLookupItem must not be null");
        }
        PsiType original = type;
        int dim = 0;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
            ++dim;
        }
        if (type instanceof PsiClassType) {
            String text;
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass psiClass = classResolveResult.getElement();
            PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
            String typeString = text = type.getCanonicalText();
            String typeParams = "";
            if (text.indexOf(60) > 0 && text.endsWith(">")) {
                typeString = text.substring(0, text.indexOf(60));
                typeParams = text.substring(text.indexOf(60));
            }
            String lookupString = text.substring(typeString.lastIndexOf(46) + 1);
            if (psiClass != null) {
                PsiClass resolved = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().resolveReferencedClass(psiClass.getName(), context);
                if (!psiClass.getManager().areElementsEquivalent((PsiElement)resolved, (PsiElement)psiClass)) {
                    lookupString = "";
                    for (PsiClass aClass = psiClass; aClass != null; aClass = aClass.getContainingClass()) {
                        lookupString = aClass.getName() + (lookupString == "" ? "" : ".") + lookupString;
                    }
                    lookupString = lookupString + typeParams;
                }
            }
            item = new PsiTypeLookupItem(psiClass == null ? text : psiClass, lookupString);
            item.setAttribute(SUBSTITUTOR, substitutor);
        } else {
            item = new LookupItem(type, type.getPresentableText());
        }
        if (dim > 0) {
            StringBuilder tail = new StringBuilder();
            for (int i = 0; i < dim; ++i) {
                tail.append("[]");
            }
            item.setAttribute(TAIL_TEXT_ATTR, " " + tail.toString());
            item.setAttribute(TAIL_TEXT_SMALL_ATTR, "");
            item.putUserData(BRACKETS_COUNT_ATTR, dim);
        }
        item.setAttribute(TYPE, original);
        return item;
    }

    @Nullable
    public static PsiTypeLookupItem from(LookupElement element) {
        if (element instanceof PsiTypeLookupItem) {
            return (PsiTypeLookupItem)element;
        }
        if (element instanceof LookupElementDecorator && (element = ((LookupElementDecorator)element).getDelegate()) instanceof PsiTypeLookupItem) {
            return (PsiTypeLookupItem)element;
        }
        return null;
    }
}

