/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaElementLookupRenderer
implements ElementLookupRenderer {
    @Override
    public boolean handlesItem(Object element) {
        return element instanceof PsiClass || element instanceof PsiMember || element instanceof PsiVariable || element instanceof PsiType || element instanceof PsiKeyword || element instanceof PsiExpression || element instanceof PsiTypeElement || element instanceof BeanPropertyElement;
    }

    public void renderElement(LookupItem item, Object element, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon(item, presentation.isReal()));
        boolean bold = item.getAttribute(LookupItem.HIGHLIGHTED_ATTR) != null;
        boolean strikeout = JavaElementLookupRenderer.isToStrikeout(item);
        presentation.setItemText(JavaElementLookupRenderer.getName(element, item));
        presentation.setStrikeout(strikeout);
        presentation.setItemTextBold(bold);
        String tailText = StringUtil.notNullize((String)JavaElementLookupRenderer.getTailText(element, item));
        boolean grayed = item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null;
        PsiSubstitutor substitutor = (PsiSubstitutor)item.getAttribute(LookupItem.SUBSTITUTOR);
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (item.getAttribute(LookupItem.INDICATE_ANONYMOUS) != null && (psiClass.isInterface() || psiClass.hasModifierProperty("abstract"))) {
                tailText = "{...}" + tailText;
            }
            if (substitutor == null && psiClass.getTypeParameters().length > 0) {
                tailText = "<" + StringUtil.join((Object[])psiClass.getTypeParameters(), (Function)new Function<PsiTypeParameter, String>(){

                    public String fun(PsiTypeParameter psiTypeParameter) {
                        return psiTypeParameter.getName();
                    }
                }, (String)("," + (JavaElementLookupRenderer.showSpaceAfterComma(psiClass) ? " " : ""))) + ">" + tailText;
            }
            grayed = true;
        }
        presentation.setTailText(tailText, grayed);
        String typeText = JavaElementLookupRenderer.getTypeText(element, item);
        presentation.setTypeText(typeText != null ? typeText : "");
    }

    private static String getName(Object o, LookupItem<?> item) {
        PsiClass psiClass;
        PsiTypeParameter[] params;
        String presentableText = item.getPresentableText();
        if (presentableText != null) {
            return presentableText;
        }
        String name = "";
        if (o instanceof PsiElement) {
            PsiElement element = (PsiElement)o;
            if (element.isValid()) {
                name = element instanceof PsiKeyword || element instanceof PsiExpression || element instanceof PsiTypeElement ? element.getText() : PsiUtilBase.getName((PsiElement)element);
            }
        } else if (o instanceof PsiArrayType) {
            name = ((PsiArrayType)o).getDeepComponentType().getPresentableText();
        } else if (o instanceof PsiType) {
            name = ((PsiType)o).getPresentableText();
        }
        if (item.getAttribute(LookupItem.FORCE_QUALIFY) != null && o instanceof PsiMember && ((PsiMember)o).getContainingClass() != null) {
            name = ((PsiMember)o).getContainingClass().getName() + "." + name;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)item.getAttribute(LookupItem.SUBSTITUTOR);
        if (o instanceof PsiClass && substitutor != null && (params = (psiClass = (PsiClass)o).getTypeParameters()).length > 0) {
            return name + JavaElementLookupRenderer.formatTypeParameters(substitutor, params);
        }
        return StringUtil.notNullize((String)name);
    }

    @Nullable
    private static String getTailText(Object o, LookupItem item) {
        String tailText;
        PsiElement element;
        String text = null;
        if (o instanceof PsiElement && (element = (PsiElement)o).isValid() && element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiSubstitutor substitutor = (PsiSubstitutor)item.getAttribute(LookupItem.SUBSTITUTOR);
            text = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)(substitutor != null ? substitutor : PsiSubstitutor.EMPTY), (int)256, (int)3);
        }
        if ((tailText = (String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR)) != null) {
            text = text == null ? tailText : text + tailText;
        }
        return text;
    }

    @Nullable
    private static String getTypeText(Object o, LookupItem item) {
        PsiElement element;
        String text = null;
        if (o instanceof PsiElement && (element = (PsiElement)o).isValid()) {
            if (element instanceof PsiMethod) {
                text = JavaElementLookupRenderer.getTypeText(item, ((PsiMethod)element).getReturnType());
            } else if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                text = variable.getType().getPresentableText();
            } else if (element instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)element;
                PsiType type = expression.getType();
                if (type != null) {
                    text = type.getPresentableText();
                }
            } else if (element instanceof BeanPropertyElement) {
                return JavaElementLookupRenderer.getTypeText(item, ((BeanPropertyElement)element).getPropertyType());
            }
        }
        return text;
    }

    @Nullable
    private static String getTypeText(LookupItem item, @Nullable PsiType returnType) {
        if (returnType == null) {
            return null;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)item.getAttribute(LookupItem.SUBSTITUTOR);
        if (substitutor != null) {
            return substitutor.substitute(returnType).getPresentableText();
        }
        return returnType.getPresentableText();
    }

    @Nullable
    private static String formatTypeParameters(@NotNull PsiSubstitutor substitutor, PsiTypeParameter[] params) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/JavaElementLookupRenderer.formatTypeParameters must not be null");
        }
        boolean space = JavaElementLookupRenderer.showSpaceAfterComma((PsiClass)params[0]);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            PsiType type = substitutor.substitute(param);
            if (type == null) {
                return "";
            }
            if (type instanceof PsiClassType && ((PsiClassType)type).getParameters().length > 0) {
                buffer.append(((PsiClassType)type).rawType().getPresentableText()).append("<...>");
            } else {
                buffer.append(type.getPresentableText());
            }
            if (i >= params.length - 1) continue;
            buffer.append(",");
            if (!space) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static boolean showSpaceAfterComma(PsiClass element) {
        return CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_AFTER_COMMA;
    }

    private static boolean isToStrikeout(LookupItem<?> item) {
        PsiElement element;
        List allMethods = (List)item.getUserData(JavaCompletionUtil.ALL_METHODS_ATTRIBUTE);
        if (allMethods != null) {
            for (PsiMethod method : allMethods) {
                if (!method.isValid()) {
                    return false;
                }
                if (JavaElementLookupRenderer.isDeprecated((PsiElement)method)) continue;
                return false;
            }
            return true;
        }
        if (item.getObject() instanceof PsiElement && (element = (PsiElement)item.getObject()).isValid()) {
            return JavaElementLookupRenderer.isDeprecated(element);
        }
        return false;
    }

    private static boolean isDeprecated(PsiElement element) {
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

