/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ExternalizablePath
implements JDOMExternalizable {
    @NonNls
    private static final String VALUE_ATTRIBUTE = "value";
    private String myUrl;

    public void readExternal(Element element) throws InvalidDataException {
        String value = element.getAttributeValue(VALUE_ATTRIBUTE);
        this.myUrl = value != null ? value : "";
        String protocol = VirtualFileManager.extractProtocol((String)this.myUrl);
        if (protocol == null) {
            this.myUrl = ExternalizablePath.urlValue(this.myUrl);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(VALUE_ATTRIBUTE, this.myUrl);
    }

    public String getLocalPath() {
        return ExternalizablePath.localPathValue(this.myUrl);
    }

    public static String urlValue(String localPath) {
        if (localPath == null) {
            return "";
        }
        if ((localPath = localPath.trim()).length() == 0) {
            return "";
        }
        return VirtualFileManager.constructUrl((String)"file", (String)localPath.replace(File.separatorChar, '/'));
    }

    public static String localPathValue(String url) {
        if (url == null) {
            return "";
        }
        if ((url = url.trim()).length() == 0) {
            return "";
        }
        return VirtualFileManager.extractPath((String)url).replace('/', File.separatorChar);
    }
}

