/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.Spacing;
import org.jetbrains.annotations.NonNls;

class SpacingImpl
extends Spacing {
    private int myMinSpaces;
    private int myKeepBlankLines;
    private int myMaxSpaces;
    private int myMinLineFeeds;
    private int myPrefLineFeeds = 0;
    protected int myFlags;
    private static final int READ_ONLY_MASK = 1;
    private static final int SAFE_MASK = 2;
    private static final int SHOULD_KEEP_LINEBEAKS_MASK = 4;
    private static final int SHOULD_KEEP_FIRST_COLUMN_MASK = 8;

    public SpacingImpl(int minSpaces, int maxSpaces, int minLineFeeds, boolean isReadOnly, boolean safe, boolean shouldKeepLineBreaks, int keepBlankLines, boolean keepFirstColumn, int prefLineFeeds) {
        this.init(minSpaces, maxSpaces, minLineFeeds, isReadOnly, safe, shouldKeepLineBreaks, keepBlankLines, keepFirstColumn, prefLineFeeds);
    }

    void init(int minSpaces, int maxSpaces, int minLineFeeds, boolean isReadOnly, boolean safe, boolean shouldKeepLineBreaks, int keepBlankLines, boolean keepFirstColumn, int prefLineFeeds) {
        this.myMinSpaces = minSpaces;
        this.myMaxSpaces = Math.max(minSpaces, maxSpaces);
        this.myMinLineFeeds = minLineFeeds;
        this.myPrefLineFeeds = prefLineFeeds;
        this.myKeepBlankLines = minLineFeeds > 1 && minLineFeeds - 1 > keepBlankLines ? minLineFeeds - 1 : keepBlankLines;
        this.myFlags = (isReadOnly ? 1 : 0) | (safe ? 2 : 0) | (shouldKeepLineBreaks ? 4 : 0) | (keepFirstColumn ? 8 : 0);
    }

    int getMinSpaces() {
        return this.myMinSpaces;
    }

    int getMaxSpaces() {
        return this.myMaxSpaces;
    }

    int getMinLineFeeds() {
        return this.myMinLineFeeds;
    }

    final boolean isReadOnly() {
        return (this.myFlags & 1) != 0;
    }

    final boolean containsLineFeeds() {
        return this.myMinLineFeeds > 0;
    }

    public final boolean isSafe() {
        return (this.myFlags & 2) != 0;
    }

    public void refresh(FormatProcessor formatter) {
    }

    public final boolean shouldKeepLineFeeds() {
        return (this.myFlags & 4) != 0;
    }

    public int getKeepBlankLines() {
        return this.myKeepBlankLines;
    }

    public final boolean shouldKeepFirstColumn() {
        return (this.myFlags & 8) != 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpacingImpl)) {
            return false;
        }
        SpacingImpl spacing = (SpacingImpl)((Object)o);
        return this.myFlags == spacing.myFlags && this.myMinSpaces == spacing.myMinSpaces && this.myMaxSpaces == spacing.myMaxSpaces && this.myMinLineFeeds == spacing.myMinLineFeeds && this.myPrefLineFeeds == spacing.myPrefLineFeeds && this.myKeepBlankLines == spacing.myKeepBlankLines;
    }

    public int hashCode() {
        return this.myMinSpaces + this.myMaxSpaces * 29 + this.myMinLineFeeds * 11 + this.myFlags + this.myKeepBlankLines + this.myPrefLineFeeds;
    }

    @NonNls
    public String toString() {
        return "<Spacing: minSpaces=" + this.myMinSpaces + " maxSpaces=" + this.myMaxSpaces + " minLineFeeds=" + this.myMinLineFeeds + ">";
    }

    public int getPrefLineFeeds() {
        return this.myPrefLineFeeds >= this.myMinLineFeeds ? this.myPrefLineFeeds : this.myMinLineFeeds;
    }
}

