/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PsiCopyPasteManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PsiCopyPasteManagerImpl");
    private MyData myRecentData;
    private final CopyPasteManagerEx myCopyPasteManager;
    private static final DataFlavor ourDataFlavor;

    public static PsiCopyPasteManager getInstance() {
        return (PsiCopyPasteManager)ServiceManager.getService(PsiCopyPasteManager.class);
    }

    public PsiCopyPasteManager(CopyPasteManager copyPasteManager) {
        this.myCopyPasteManager = (CopyPasteManagerEx)copyPasteManager;
    }

    @Nullable
    public PsiElement[] getElements(boolean[] isCopied) {
        try {
            Object transferData;
            Transferable content = this.myCopyPasteManager.getSystemClipboardContents();
            try {
                transferData = content.getTransferData(ourDataFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            if (!(transferData instanceof MyData)) {
                return null;
            }
            MyData dataProxy = (MyData)transferData;
            if (!Comparing.equal((Object)dataProxy, (Object)this.myRecentData)) {
                return null;
            }
            if (isCopied != null) {
                isCopied[0] = this.myRecentData.isCopied();
            }
            return this.myRecentData.getElements();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    static PsiElement[] getElements(Transferable content) {
        Object transferData;
        if (content == null) {
            return null;
        }
        try {
            transferData = content.getTransferData(ourDataFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return transferData instanceof MyData ? ((MyData)transferData).getElements() : null;
    }

    public void clear() {
        Transferable old = this.myCopyPasteManager.getContents();
        this.myRecentData = null;
        this.myCopyPasteManager.setSystemClipboardContent(new StringSelection(""));
        this.myCopyPasteManager.fireContentChanged(old);
    }

    public void setElements(PsiElement[] elements, boolean copied) {
        Transferable old = this.myCopyPasteManager.getContents();
        this.myRecentData = new MyData(elements, copied);
        this.myCopyPasteManager.setSystemClipboardContent(new MyTransferable(this.myRecentData));
        this.myCopyPasteManager.fireContentChanged(old);
    }

    public boolean isCutElement(Object element) {
        if (this.myRecentData == null) {
            return false;
        }
        if (this.myRecentData.isCopied()) {
            return false;
        }
        PsiElement[] elements = this.myRecentData.getElements();
        if (elements == null) {
            return false;
        }
        for (PsiElement aElement : elements) {
            if (aElement != element) continue;
            return true;
        }
        return false;
    }

    public static List<File> asFileList(PsiElement[] elements) {
        ArrayList<File> result = new ArrayList<File>();
        for (PsiElement element : elements) {
            VirtualFile vFile;
            PsiFileSystemItem psiFile;
            if (element instanceof PsiFileSystemItem) {
                psiFile = (PsiFileSystemItem)element;
            } else if (element instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
                psiFile = directories[0];
            } else {
                psiFile = element.getContainingFile();
            }
            if (psiFile == null || (vFile = psiFile.getVirtualFile()) == null || !(vFile.getFileSystem() instanceof LocalFileSystem)) continue;
            result.add(new File(vFile.getPath()));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class<MyData> flavorClass = MyData.class;
            Thread currentThread = Thread.currentThread();
            ClassLoader currentLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(flavorClass.getClassLoader());
                ourDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + flavorClass.getName());
            }
            finally {
                currentThread.setContextClassLoader(currentLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MyTransferable
    implements Transferable {
        private final MyData myDataProxy;
        private static final DataFlavor[] DATA_FLAVOR_ARRAY = new DataFlavor[]{PsiCopyPasteManager.access$000(), DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor};

        public MyTransferable(MyData data) {
            this.myDataProxy = data;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (ourDataFlavor.equals(flavor)) {
                return this.myDataProxy;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.getDataAsText();
            }
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return PsiCopyPasteManager.asFileList(this.myDataProxy.getElements());
            }
            return null;
        }

        @Nullable
        private String getDataAsText() {
            ArrayList<String> names = new ArrayList<String>();
            for (PsiElement element : this.myDataProxy.getElements()) {
                String name;
                if (!(element instanceof PsiNamedElement) || (name = ((PsiNamedElement)element).getName()) == null) continue;
                names.add(name);
            }
            if (names.isEmpty()) {
                return null;
            }
            return StringUtil.join(names, (String)"\n");
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return DATA_FLAVOR_ARRAY;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(ourDataFlavor) || flavor.equals(DataFlavor.stringFlavor) || flavor.equals(DataFlavor.javaFileListFlavor);
        }

        public PsiElement[] getElements() {
            return this.myDataProxy.getElements();
        }
    }

    private static class MyData {
        private PsiElement[] myElements;
        private final boolean myIsCopied;

        public MyData(PsiElement[] elements, boolean copied) {
            this.myElements = elements;
            this.myIsCopied = copied;
        }

        public PsiElement[] getElements() {
            if (this.myElements == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            int validElementsCount = 0;
            for (PsiElement element : this.myElements) {
                if (!element.isValid()) continue;
                ++validElementsCount;
            }
            if (validElementsCount == this.myElements.length) {
                return this.myElements;
            }
            PsiElement[] validElements = new PsiElement[validElementsCount];
            int j = 0;
            for (PsiElement element : this.myElements) {
                if (!element.isValid()) continue;
                validElements[j++] = element;
            }
            this.myElements = validElements;
            return this.myElements;
        }

        public boolean isCopied() {
            return this.myIsCopied;
        }
    }
}

