/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataValidator;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.CopyProviderRule;
import com.intellij.ide.impl.dataRules.CutProviderRule;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.FileTextRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.impl.dataRules.InactiveEditorRule;
import com.intellij.ide.impl.dataRules.NavigatableArrayRule;
import com.intellij.ide.impl.dataRules.PasteProviderRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.StringSetSpinAllocator;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataManagerImpl
extends DataManager
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.DataManagerImpl");
    private final Map<String, GetDataRule> myDataConstantToRuleMap = new THashMap();
    private WindowManagerEx myWindowManager;

    public DataManagerImpl() {
        this.registerRules();
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object getData(String dataId, Component focusedComponent) {
        for (Component c = focusedComponent; c != null; c = c.getParent()) {
            DataProvider dataProvider = DataManagerImpl.getDataProvider(c);
            if (dataProvider == null) continue;
            Set set = StringSetSpinAllocator.alloc();
            try {
                Object data = this.getDataFromProvider(dataProvider, dataId, set);
                if (data == null) continue;
                Object object = data;
                return object;
            }
            finally {
                StringSetSpinAllocator.dispose((Set)set);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object getDataFromProvider(final DataProvider provider, String dataId, final Set<String> alreadyComputedIds) {
        if (alreadyComputedIds.contains(dataId)) {
            return null;
        }
        alreadyComputedIds.add(dataId);
        try {
            Object data = provider.getData(dataId);
            if (data != null) {
                Object object = DataManagerImpl.validated(data, dataId, provider);
                return object;
            }
            GetDataRule dataRule = this.getDataRule(dataId);
            if (dataRule != null && (data = dataRule.getData(new DataProvider(){

                public Object getData(String dataId) {
                    return DataManagerImpl.this.getDataFromProvider(provider, dataId, alreadyComputedIds);
                }
            })) != null) {
                Object object = DataManagerImpl.validated(data, dataId, provider);
                return object;
            }
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            alreadyComputedIds.remove(dataId);
        }
    }

    @Nullable
    private static DataProvider getDataProvider(Object component) {
        DataProvider dataProvider = null;
        if (component instanceof DataProvider) {
            dataProvider = (DataProvider)component;
        } else if (component instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component);
        } else if (component instanceof JComponent) {
            dataProvider = (DataProvider)((JComponent)component).getClientProperty("DataProvider");
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(String dataId) {
        GetDataRule rule = this.getRuleFromMap(dataId);
        if (rule != null) {
            return rule;
        }
        final GetDataRule plainRule = this.getRuleFromMap(AnActionEvent.uninjectedId((String)dataId));
        if (plainRule != null) {
            return new GetDataRule(){

                @Override
                public Object getData(final DataProvider dataProvider) {
                    return plainRule.getData(new DataProvider(){

                        @Nullable
                        public Object getData(@NonNls String dataId) {
                            return dataProvider.getData(AnActionEvent.injectedId((String)dataId));
                        }
                    });
                }
            };
        }
        return null;
    }

    @Nullable
    private GetDataRule getRuleFromMap(String dataId) {
        GetDataRule rule = this.myDataConstantToRuleMap.get(dataId);
        if (rule == null && !this.myDataConstantToRuleMap.containsKey(dataId)) {
            KeyedLazyInstanceEP[] eps;
            for (KeyedLazyInstanceEP ruleEP : eps = (KeyedLazyInstanceEP[])Extensions.getExtensions(GetDataRule.EP_NAME)) {
                if (!ruleEP.key.equals(dataId)) continue;
                rule = (GetDataRule)ruleEP.getInstance();
            }
            this.myDataConstantToRuleMap.put(dataId, rule);
        }
        return rule;
    }

    @Nullable
    private static Object validated(Object data, String dataId, Object dataSource) {
        Object invalidData = DataValidator.findInvalidData(dataId, data, dataSource);
        if (invalidData != null) {
            return null;
        }
        return data;
    }

    public DataContext getDataContext(Component component) {
        return new MyDataContext(component);
    }

    public DataContext getDataContext(@NotNull Component component, int x, int y) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/DataManagerImpl.getDataContext must not be null");
        }
        if (x < 0 || x >= component.getWidth() || y < 0 || y >= component.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component;
            int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            return this.getDataContext(index != -1 ? tabbedPane.getComponentAt(index) : tabbedPane);
        }
        return this.getDataContext(component);
    }

    public void setWindowManager(WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    public DataContext getDataContext() {
        return this.getDataContext(this.getFocusedComponent());
    }

    public AsyncResult<DataContext> getDataContextFromFocus() {
        final AsyncResult context = new AsyncResult();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                context.setDone((Object)DataManagerImpl.this.getDataContext());
            }
        });
        return context;
    }

    public DataContext getDataContextTest(Component component) {
        DataContext dataContext = this.getDataContext(component);
        if (this.myWindowManager == null) {
            return dataContext;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = this.myWindowManager.getFocusedComponent(project);
        if (focusedComponent != null) {
            dataContext = this.getDataContext(focusedComponent);
        }
        return dataContext;
    }

    @Nullable
    private Component getFocusedComponent() {
        IdeFocusManager fm;
        if (this.myWindowManager == null) {
            return null;
        }
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (Registry.is((String)"actionSystem.noContextComponentWhileFocusTransfer") && (fm = IdeFocusManager.findInstanceByComponent((Component)activeWindow)).isFocusBeingTransferred()) {
            return null;
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = this.myWindowManager.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    private void registerRules() {
        this.myDataConstantToRuleMap.put(PlatformDataKeys.COPY_PROVIDER.getName(), new CopyProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.CUT_PROVIDER.getName(), new CutProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.PASTE_PROVIDER.getName(), new PasteProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_TEXT.getName(), new FileTextRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_EDITOR.getName(), new FileEditorRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.NAVIGATABLE_ARRAY.getName(), new NavigatableArrayRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.EDITOR_EVEN_IF_INACTIVE.getName(), new InactiveEditorRule());
    }

    @NotNull
    public String getComponentName() {
        if ("DataManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/impl/DataManagerImpl.getComponentName must not return null");
        }
        return "DataManager";
    }

    public class MyDataContext
    implements DataContext {
        private int myEventCount = -1;
        private final WeakReference<Component> myRef;

        public MyDataContext(Component component) {
            this.myRef = new WeakReference<Component>(component);
        }

        public void setEventCount(int eventCount) {
            this.myEventCount = eventCount;
        }

        public Object getData(String dataId) {
            int currentEventCount = IdeEventQueue.getInstance().getEventCount();
            if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
            }
            Component _component = (Component)this.myRef.get();
            if (PlatformDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
                if (_component != null) {
                    return IdeKeyEventDispatcher.isModalContext(_component) ? Boolean.TRUE : Boolean.FALSE;
                }
                return null;
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
                return _component;
            }
            if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
                return _component != null ? ModalityState.stateForComponent((Component)_component) : ModalityState.NON_MODAL;
            }
            if (PlatformDataKeys.EDITOR.is(dataId)) {
                Editor editor = (Editor)DataManagerImpl.this.getData(dataId, _component);
                return this.validateEditor(editor);
            }
            return DataManagerImpl.this.getData(dataId, _component);
        }

        @Nullable
        private Editor validateEditor(Editor editor) {
            JComponent jComponent;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
                return null;
            }
            return editor;
        }

        @NonNls
        public String toString() {
            return "component=" + String.valueOf(this.myRef.get());
        }
    }
}

