/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.SortableProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class PluginManagerColumnInfo
extends ColumnInfo<IdeaPluginDescriptor, String> {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DOWNLOADS = 1;
    public static final int COLUMN_DATE = 2;
    public static final int COLUMN_CATEGORY = 3;
    public static final int COLUMN_INSTALLED_VERSION = 4;
    public static final int COLUMN_SIZE = 5;
    public static final int COLUMN_VERSION = 6;
    public static final int COLUMN_STATE = 7;
    private static final float mgByte = 1048576.0f;
    private static final float kByte = 1024.0f;
    public static final String[] COLUMNS = new String[]{IdeBundle.message((String)"column.plugins.name", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.downloads", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.date", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.category", (Object[])new Object[0])};
    private final int columnIdx;
    private final SortableProvider mySortableProvider;

    public PluginManagerColumnInfo(int columnIdx, SortableProvider sortableProvider) {
        super(COLUMNS[columnIdx]);
        this.columnIdx = columnIdx;
        this.mySortableProvider = sortableProvider;
    }

    public String valueOf(IdeaPluginDescriptor base) {
        if (this.columnIdx == 0) {
            return base.getName();
        }
        if (this.columnIdx == 1) {
            return base instanceof PluginNode ? ((PluginNode)base).getDownloads() : ((IdeaPluginDescriptorImpl)base).getDownloads();
        }
        if (this.columnIdx == 2) {
            long date;
            long l = date = base instanceof PluginNode ? ((PluginNode)base).getDate() : ((IdeaPluginDescriptorImpl)base).getDate();
            if (date != 0L) {
                return DateFormat.getDateInstance(2).format(new Date(date));
            }
            return IdeBundle.message((String)"plugin.info.not.available", (Object[])new Object[0]);
        }
        if (this.columnIdx == 3) {
            return base.getCategory();
        }
        return "";
    }

    public Comparator<IdeaPluginDescriptor> getComparator() {
        final boolean sortDirection = this.mySortableProvider.getSortOrder() == 1;
        switch (this.columnIdx) {
            case 0: {
                return new Comparator<IdeaPluginDescriptor>(){

                    @Override
                    public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                        String name1 = (sortDirection ? o1 : o2).getName();
                        String name2 = (sortDirection ? o2 : o1).getName();
                        return PluginManagerColumnInfo.compareStrings(name1, name2);
                    }
                };
            }
            case 1: {
                return new Comparator<IdeaPluginDescriptor>(){

                    @Override
                    public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                        String count2;
                        if (!sortDirection) {
                            IdeaPluginDescriptor swap = o2;
                            o2 = o1;
                            o1 = swap;
                        }
                        String count1 = o1 instanceof PluginNode ? ((PluginNode)o1).getDownloads() : ((IdeaPluginDescriptorImpl)o1).getDownloads();
                        String string = count2 = o2 instanceof PluginNode ? ((PluginNode)o2).getDownloads() : ((IdeaPluginDescriptorImpl)o2).getDownloads();
                        if (count1 != null && count2 != null) {
                            return new Long(count1).compareTo(new Long(count2));
                        }
                        if (count1 != null) {
                            return 1;
                        }
                        return -1;
                    }
                };
            }
            case 3: {
                return new Comparator<IdeaPluginDescriptor>(){

                    @Override
                    public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                        String cat1 = (sortDirection ? o1 : o2).getCategory();
                        String cat2 = (sortDirection ? o2 : o1).getCategory();
                        return PluginManagerColumnInfo.compareStrings(cat1, cat2);
                    }
                };
            }
            case 2: {
                return new Comparator<IdeaPluginDescriptor>(){

                    @Override
                    public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                        long date2;
                        if (!sortDirection) {
                            IdeaPluginDescriptor swap = o2;
                            o2 = o1;
                            o1 = swap;
                        }
                        long date1 = o1 instanceof PluginNode ? ((PluginNode)o1).getDate() : ((IdeaPluginDescriptorImpl)o1).getDate();
                        long l = date2 = o2 instanceof PluginNode ? ((PluginNode)o2).getDate() : ((IdeaPluginDescriptorImpl)o2).getDate();
                        if (date1 > date2) {
                            return 1;
                        }
                        if (date1 < date2) {
                            return -1;
                        }
                        return 0;
                    }
                };
            }
        }
        return new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o, IdeaPluginDescriptor o1) {
                return 0;
            }
        };
    }

    public static int compareStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static String getFormattedSize(String size) {
        if (size.equals("-1")) {
            return IdeBundle.message((String)"plugin.info.unknown", (Object[])new Object[0]);
        }
        if (size.length() >= 4) {
            size = size.length() < 7 ? String.format("%.1f", Float.valueOf((float)Integer.parseInt(size) / 1024.0f)) + " K" : String.format("%.1f", Float.valueOf((float)Integer.parseInt(size) / 1048576.0f)) + " M";
        }
        return size;
    }

    public static int getRealNodeState(PluginNode node) {
        if (node.getStatus() == 5) {
            return 5;
        }
        return 2;
    }

    public TableCellRenderer getRenderer(IdeaPluginDescriptor o) {
        return new PluginTableCellRenderer(this);
    }

    protected int getHorizontalAlignment() {
        return 10;
    }

    public Class getColumnClass() {
        if (this.columnIdx == 5 || this.columnIdx == 1) {
            return Integer.class;
        }
        return String.class;
    }

    public int getWidth(JTable table) {
        return this.columnIdx == 0 ? 35 : -1;
    }

    private static class PluginTableCellRenderer
    extends DefaultTableCellRenderer {
        private final PluginManagerColumnInfo myColumnInfo;

        private PluginTableCellRenderer(PluginManagerColumnInfo columnInfo) {
            this.myColumnInfo = columnInfo;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            IdeaPluginDescriptor descriptor = ((PluginTable)((Object)table)).getObjectAt(row);
            if (column == 0) {
                this.setIcon(IconLoader.getIcon((String)"/nodes/pluginnotinstalled.png"));
            }
            this.setHorizontalAlignment(this.myColumnInfo.getHorizontalAlignment());
            if (descriptor instanceof IdeaPluginDescriptorImpl) {
                IdeaPluginDescriptorImpl ideaPluginDescriptor = (IdeaPluginDescriptorImpl)descriptor;
                if (ideaPluginDescriptor.isDeleted()) {
                    if (!isSelected) {
                        this.setForeground(FileStatus.COLOR_MISSING);
                    }
                    this.setToolTipText(IdeBundle.message((String)"plugin.deleted.status.tooltip", (Object[])new Object[0]));
                } else if (InstalledPluginsTableModel.hasNewerVersion(ideaPluginDescriptor.getPluginId())) {
                    if (!isSelected) {
                        this.setForeground(FileStatus.COLOR_MODIFIED);
                    }
                    this.setToolTipText(IdeBundle.message((String)"plugin.outdated.version.status.tooltip", (Object[])new Object[0]));
                } else if (InstalledPluginsTableModel.wasUpdated(ideaPluginDescriptor.getPluginId())) {
                    if (!isSelected) {
                        this.setForeground(FileStatus.COLOR_MODIFIED);
                    }
                    this.setToolTipText(IdeBundle.message((String)"plugin.updated.status.tooltip", (Object[])new Object[0]));
                }
            } else if (descriptor instanceof PluginNode) {
                PluginNode pluginNode = (PluginNode)descriptor;
                if (pluginNode.getStatus() == 5) {
                    if (!isSelected) {
                        this.setForeground(FileStatus.COLOR_ADDED);
                    }
                    if (column == 0) {
                        this.setIcon(IconLoader.getIcon((String)"/nodes/plugin.png"));
                    }
                    this.setToolTipText(IdeBundle.message((String)"plugin.download.status.tooltip", (Object[])new Object[0]));
                } else if (pluginNode.getStatus() == 1) {
                    if (!isSelected) {
                        this.setForeground(FileStatus.COLOR_MODIFIED);
                    }
                    this.setToolTipText(IdeBundle.message((String)"plugin.is.already.installed.status.tooltip", (Object[])new Object[0]));
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

