/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.CompositePsiClasChildrenSource;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;

public interface PsiClassChildrenSource {
    public static final PsiClassChildrenSource NONE = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
        }
    };
    public static final PsiClassChildrenSource METHODS = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
            children.addAll(Arrays.asList(psiClass.getMethods()));
        }
    };
    public static final PsiClassChildrenSource FIELDS = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
            children.addAll(Arrays.asList(psiClass.getFields()));
        }
    };
    public static final PsiClassChildrenSource CLASSES = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
            children.addAll(Arrays.asList(psiClass.getInnerClasses()));
        }
    };
    public static final PsiClassChildrenSource DEFAULT_CHILDREN = new CompositePsiClasChildrenSource(new PsiClassChildrenSource[]{CLASSES, METHODS, FIELDS});

    public void addChildren(PsiClass var1, List<PsiElement> var2);
}

