/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileNode
extends BasePsiNode<PsiFile> {
    public PsiFileNode(Project project, PsiFile value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory psiDirectory;
        VirtualFile jarRoot;
        if (this.isArchive() && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(this.getVirtualFile())) != null && (psiDirectory = PsiManager.getInstance((Project)this.getProject()).findDirectory(jarRoot)) != null) {
            return ProjectViewDirectoryHelper.getInstance(this.getProject()).getDirectoryChildren(psiDirectory, this.getSettings(), true);
        }
        return new ArrayList<AbstractTreeNode>();
    }

    private boolean isArchive() {
        VirtualFile file = this.getVirtualFile();
        return file != null && file.isValid() && file.getFileType() instanceof ArchiveFileType;
    }

    @Override
    protected void updateImpl(PresentationData data) {
        PsiFile value = (PsiFile)this.getValue();
        data.setPresentableText(value.getName());
        data.setIcons(value.getIcon(2));
    }

    public VirtualFile getVirtualFile() {
        PsiFile value = (PsiFile)this.getValue();
        return value != null ? value.getVirtualFile() : null;
    }

    public int getWeight() {
        return 20;
    }

    public String getTitle() {
        PsiFile file = (PsiFile)this.getValue();
        if (file != null) {
            return file.getVirtualFile().getPresentableUrl();
        }
        return super.getTitle();
    }

    @Override
    protected boolean isMarkReadOnly() {
        return true;
    }

    public Comparable getTypeSortKey() {
        String extension = PsiFileNode.extension((PsiFile)this.getValue());
        return extension == null ? null : new ExtensionSortKey(extension);
    }

    @Nullable
    public static String extension(PsiFile file) {
        return file == null || file.getVirtualFile() == null ? null : file.getVirtualFile().getFileType().getDefaultExtension();
    }

    public boolean shouldDrillDownOnEmptyElement() {
        PsiFile file = (PsiFile)this.getValue();
        return file != null && file.getFileType() == StdFileTypes.JAVA;
    }

    public boolean canRepresent(Object element) {
        return super.canRepresent(element) || this.getValue() != null && ((PsiFile)this.getValue()).getVirtualFile() == element;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/PsiFileNode.contains must not be null");
        }
        return super.contains(file) || this.isArchive() && PathUtil.getLocalFile((VirtualFile)file) == this.getVirtualFile();
    }

    public static class ExtensionSortKey
    implements Comparable {
        private final String myExtension;

        public ExtensionSortKey(String extension) {
            this.myExtension = extension;
        }

        public int compareTo(Object o) {
            if (!(o instanceof ExtensionSortKey)) {
                return 0;
            }
            ExtensionSortKey rhs = (ExtensionSortKey)o;
            return this.myExtension.compareTo(rhs.myExtension);
        }
    }
}

