/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchableOptionsRegistrarImpl
extends SearchableOptionsRegistrar {
    private final Map<String, Set<OptionDescription>> myStorage = Collections.synchronizedMap(new THashMap(1500, 0.9f));
    private final Map<String, String> myId2Name = Collections.synchronizedMap(new THashMap(20, 0.9f));
    private final Set<String> myStopWords = Collections.synchronizedSet(new HashSet());
    private final Map<Pair<String, String>, Set<String>> myHighlightOption2Synonym = Collections.synchronizedMap(new THashMap());
    private final StringInterner myIdentifierTable = new StringInterner(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public String intern(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1.intern must not be null");
            }
            1 var2_2 = this;
            // MONITORENTER : var2_2
            String string = super.intern(name);
            // MONITOREXIT : var2_2
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1.intern must not return null");
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl");
    public static final int LOAD_FACTOR = 20;
    @NonNls
    private static final Pattern REG_EXP = Pattern.compile("[\\W&&[^_-]]");

    public SearchableOptionsRegistrarImpl() {
        try {
            String groupName;
            String id;
            Element configurable;
            String text = ResourceUtil.loadText((URL)ResourceUtil.getResource(SearchableOptionsRegistrarImpl.class, (String)"/search/", (String)"ignore.txt"));
            String[] stopWords = text.split("[\\W]");
            this.myStopWords.addAll(Arrays.asList(stopWords));
            Document document = JDOMUtil.loadDocument((URL)ResourceUtil.getResource(SearchableOptionsRegistrar.class, (String)"/search/", (String)"searchableOptions.xml"));
            Element root = document.getRootElement();
            List configurables = root.getChildren("configurable");
            for (Object o : configurables) {
                configurable = (Element)o;
                id = configurable.getAttributeValue("id");
                groupName = configurable.getAttributeValue("configurable_name");
                List options = configurable.getChildren("option");
                for (Object o1 : options) {
                    Element optionElement = (Element)o1;
                    String option = optionElement.getAttributeValue("name");
                    String path = optionElement.getAttributeValue("path");
                    String hit = optionElement.getAttributeValue("hit");
                    this.putOptionWithHelpId(option, id, groupName, hit, path);
                }
            }
            document = JDOMUtil.loadDocument((URL)ResourceUtil.getResource(SearchableOptionsRegistrar.class, (String)"/search/", (String)"synonyms.xml"));
            root = document.getRootElement();
            configurables = root.getChildren("configurable");
            for (Object o : configurables) {
                configurable = (Element)o;
                id = configurable.getAttributeValue("id");
                groupName = configurable.getAttributeValue("configurable_name");
                List synonyms = configurable.getChildren("synonym");
                for (Object o1 : synonyms) {
                    Element synonymElement = (Element)o1;
                    String synonym = synonymElement.getTextNormalize();
                    if (synonym == null) continue;
                    Set<String> words = this.getProcessedWords(synonym);
                    for (String word : words) {
                        this.putOptionWithHelpId(word, id, groupName, synonym, null);
                    }
                }
                List options = configurable.getChildren("option");
                for (Object o1 : options) {
                    Element optionElement = (Element)o1;
                    String option = optionElement.getAttributeValue("name");
                    List list = optionElement.getChildren("synonym");
                    for (Object o2 : list) {
                        Element synonymElement = (Element)o2;
                        String synonym = synonymElement.getTextNormalize();
                        if (synonym == null) continue;
                        Set<String> words = this.getProcessedWords(synonym);
                        for (String word : words) {
                            this.putOptionWithHelpId(word, id, groupName, synonym, null);
                        }
                        Pair key = Pair.create((Object)option, (Object)id);
                        THashSet foundSynonyms = this.myHighlightOption2Synonym.get(key);
                        if (foundSynonyms == null) {
                            foundSynonyms = new THashSet();
                            this.myHighlightOption2Synonym.put((Pair<String, String>)key, (Set<String>)foundSynonyms);
                        }
                        foundSynonyms.add((String)synonym);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private synchronized void putOptionWithHelpId(String option, String id, String groupName, String hit, String path) {
        THashSet configs;
        if (this.myStopWords.contains(option)) {
            return;
        }
        String stopWord = PorterStemmerUtil.stem(option);
        if (stopWord == null) {
            return;
        }
        if (this.myStopWords.contains(stopWord)) {
            return;
        }
        if (!this.myId2Name.containsKey(id) && groupName != null) {
            this.myId2Name.put(this.myIdentifierTable.intern(id), this.myIdentifierTable.intern(groupName));
        }
        if ((configs = this.myStorage.get(option)) == null) {
            configs = new THashSet(3, 0.9f);
            this.myStorage.put(new String(option), (Set<OptionDescription>)configs);
        }
        configs.add(new OptionDescription(null, this.myIdentifierTable.intern(id), hit != null ? this.myIdentifierTable.intern(hit) : null, path != null ? this.myIdentifierTable.intern(path) : null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ConfigurableHit getConfigurables(ConfigurableGroup[] groups, DocumentEvent.EventType type, Set<Configurable> configurables, String option, Project project) {
        ConfigurableHit configurableHit;
        ConfigurableHit hits = new ConfigurableHit();
        Set contentHits = hits.getContentHits();
        Set<String> options = this.getProcessedWordsWithoutStemming(option);
        if (configurables == null) {
            for (ConfigurableGroup group : groups) {
                contentHits.addAll(SearchUtil.expandGroup(group));
            }
        } else {
            contentHits.addAll(configurables);
        }
        if (option != null) {
            String optionToCheck = option.trim().toLowerCase();
            for (Configurable each : contentHits) {
                if (each.getDisplayName() == null) continue;
                String displayName = each.getDisplayName().toLowerCase();
                List allWords = StringUtil.getWordsIn((String)displayName);
                if (displayName.contains(optionToCheck)) {
                    hits.getNameFullHits().add(each);
                    hits.getNameHits().add(each);
                }
                for (int i = 0; i < allWords.size(); ++i) {
                    String eachWord = (String)allWords.get(i);
                    if (!eachWord.startsWith(optionToCheck)) continue;
                    hits.getNameHits().add(each);
                }
            }
        }
        HashSet currentConfigurables = new HashSet(contentHits);
        if (options.isEmpty()) {
            options.add(option);
        }
        HashSet<String> helpIds = null;
        for (String opt : options) {
            Set<OptionDescription> optionIds = this.getAcceptableDescriptions(opt);
            if (optionIds == null) {
                contentHits.clear();
                configurableHit = hits;
                if (configurableHit == null) throw new IllegalStateException("@NotNull method com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.getConfigurables must not return null");
                return configurableHit;
            }
            HashSet<String> ids = new HashSet<String>();
            for (OptionDescription id : optionIds) {
                ids.add(id.getConfigurableId());
            }
            if (helpIds == null) {
                helpIds = ids;
            }
            helpIds.retainAll(ids);
        }
        if (helpIds != null) {
            Iterator it = contentHits.iterator();
            while (it.hasNext()) {
                Configurable configurable = (Configurable)it.next();
                if (CodeStyleFacade.getInstance((Project)project).isUnsuitableCodestyleConfigurable(configurable)) {
                    it.remove();
                    continue;
                }
                if (configurable instanceof SearchableConfigurable && helpIds.contains(((SearchableConfigurable)configurable).getId())) continue;
                it.remove();
            }
        }
        if (((Object)currentConfigurables).equals(contentHits)) {
            configurableHit = this.getConfigurables(groups, DocumentEvent.EventType.CHANGE, null, option, project);
            if (configurableHit == null) throw new IllegalStateException("@NotNull method com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.getConfigurables must not return null");
            return configurableHit;
        }
        configurableHit = hits;
        if (configurableHit != null) return configurableHit;
        throw new IllegalStateException("@NotNull method com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.getConfigurables must not return null");
    }

    @Nullable
    public Set<OptionDescription> getAcceptableDescriptions(String prefix) {
        if (prefix == null) {
            return null;
        }
        String stemmedPrefix = PorterStemmerUtil.stem(prefix);
        if (stemmedPrefix == null) {
            return null;
        }
        Set result = null;
        for (String option : this.myStorage.keySet()) {
            String stemmedOption;
            Set<OptionDescription> descriptions = this.myStorage.get(option);
            if (descriptions == null || !option.startsWith(prefix) && !option.startsWith(stemmedPrefix) && (stemmedOption = PorterStemmerUtil.stem(option)) != null && !stemmedOption.startsWith(prefix) && !stemmedOption.startsWith(stemmedPrefix)) continue;
            if (result == null) {
                result = new THashSet();
            }
            result.addAll(descriptions);
        }
        return result;
    }

    @Nullable
    public String getInnerPath(SearchableConfigurable configurable, @NonNls String option) {
        HashSet<OptionDescription> path = null;
        Set<String> words = this.getProcessedWordsWithoutStemming(option);
        for (String word : words) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(word);
            if (configs == null) {
                return null;
            }
            HashSet<OptionDescription> paths = new HashSet<OptionDescription>();
            for (OptionDescription config : configs) {
                if (!Comparing.strEqual((String)config.getConfigurableId(), (String)configurable.getId())) continue;
                paths.add(config);
            }
            if (path == null) {
                path = paths;
            }
            path.retainAll(paths);
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        OptionDescription result = null;
        for (OptionDescription description : path) {
            String hit = description.getHit();
            if (hit != null) {
                boolean theBest = true;
                for (String word : words) {
                    if (hit.contains(word)) continue;
                    theBest = false;
                }
                if (theBest) {
                    return description.getPath();
                }
            }
            result = description;
        }
        return result != null ? result.getPath() : null;
    }

    public boolean isStopWord(String word) {
        return this.myStopWords.contains(word);
    }

    public Set<String> getSynonym(String option, @NotNull SearchableConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.getSynonym must not be null");
        }
        return this.myHighlightOption2Synonym.get(Pair.create((Object)option, (Object)configurable.getId()));
    }

    public Map<String, Set<String>> findPossibleExtension(@NotNull String prefix, Project project) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.findPossibleExtension must not be null");
        }
        boolean perProject = CodeStyleFacade.getInstance((Project)project).projectUsesOwnSettings();
        THashMap result = new THashMap();
        int count = 0;
        Set<String> prefixes = this.getProcessedWordsWithoutStemming(prefix);
        for (String opt : prefixes) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(opt);
            if (configs == null) continue;
            for (OptionDescription description : configs) {
                Set foundHits;
                String groupName = this.myId2Name.get(description.getConfigurableId());
                if (perProject) {
                    if (Comparing.strEqual((String)groupName, (String)ApplicationBundle.message((String)"title.global.code.style", (Object[])new Object[0]))) {
                        groupName = ApplicationBundle.message((String)"title.project.code.style", (Object[])new Object[0]);
                    }
                } else if (Comparing.strEqual((String)groupName, (String)ApplicationBundle.message((String)"title.project.code.style", (Object[])new Object[0]))) {
                    groupName = ApplicationBundle.message((String)"title.global.code.style", (Object[])new Object[0]);
                }
                if ((foundHits = (Set)result.get(groupName)) == null) {
                    foundHits = new THashSet();
                    result.put(groupName, foundHits);
                }
                foundHits.add(description.getHit());
                ++count;
            }
        }
        if (count > 20) {
            result.clear();
        }
        return result;
    }

    public void addOption(String option, String path, String hit, String configurableId, String configurableDisplayName) {
        this.putOptionWithHelpId(option, configurableId, configurableDisplayName, hit, path);
    }

    public Set<String> getProcessedWordsWithoutStemming(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.getProcessedWordsWithoutStemming must not be null");
        }
        HashSet<String> result = new HashSet<String>();
        String toLowerCase = text.toLowerCase();
        String[] options = REG_EXP.split(toLowerCase);
        if (options != null) {
            for (String opt : options) {
                String processed;
                if (opt == null || this.isStopWord(opt) || this.isStopWord(processed = PorterStemmerUtil.stem(opt))) continue;
                result.add(opt);
            }
        }
        return result;
    }

    public Set<String> getProcessedWords(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl.getProcessedWords must not be null");
        }
        HashSet<String> result = new HashSet<String>();
        String toLowerCase = text.toLowerCase();
        String[] options = REG_EXP.split(toLowerCase);
        if (options != null) {
            for (String opt : options) {
                if (this.isStopWord(opt) || (opt = PorterStemmerUtil.stem(opt)) == null) continue;
                result.add(opt);
            }
        }
        return result;
    }

    public Set<String> replaceSynonyms(Set<String> options, SearchableConfigurable configurable) {
        HashSet<String> result = new HashSet<String>(options);
        for (String option : options) {
            Set<String> synonyms = this.getSynonym(option, configurable);
            if (synonyms != null) {
                result.addAll(synonyms);
                continue;
            }
            result.add(option);
        }
        return result;
    }
}

