/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseElementsDialog<T>
extends DialogWrapper {
    protected ElementsChooser<T> myChooser;
    private String myDescription;

    public ChooseElementsDialog(Project project, List<? extends T> items, String title, String description) {
        this(project, items, title, description, false);
    }

    public ChooseElementsDialog(Project project, List<? extends T> items, String title, String description, boolean sort) {
        super(project, true);
        this.myDescription = description;
        this.initializeDialog(items, title, sort);
    }

    public ChooseElementsDialog(Component parent, List<T> items, String title) {
        this(parent, items, title, null, false);
    }

    public ChooseElementsDialog(Component parent, List<T> items, String title, @Nullable String description, boolean sort) {
        super(parent, true);
        this.myDescription = description;
        this.initializeDialog(items, title, sort);
    }

    private void initializeDialog(List<? extends T> items, String title, boolean sort) {
        this.setTitle(title);
        this.myChooser = new ElementsChooser<T>(false){

            @Override
            protected String getItemText(@NotNull T item) {
                if (item == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/ChooseElementsDialog$1.getItemText must not be null");
                }
                return ChooseElementsDialog.this.getItemText(item);
            }
        };
        this.myChooser.setColorUnmarkedElements(false);
        ArrayList<T> elements = new ArrayList<T>(items);
        if (sort) {
            Collections.sort(elements, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ChooseElementsDialog.this.getItemText(o1).compareToIgnoreCase(ChooseElementsDialog.this.getItemText(o2));
                }
            });
        }
        this.setElements(elements, elements.size() > 0 ? elements.subList(0, 1) : Collections.emptyList());
        this.myChooser.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseElementsDialog.this.doOKAction();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.myChooser.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isPopupTrigger() && !e.isConsumed()) {
                    e.consume();
                    ChooseElementsDialog.this.doOKAction();
                }
            }
        });
        this.init();
    }

    protected abstract String getItemText(T var1);

    public List<T> getChosenElements() {
        return this.myChooser.getSelectedElements();
    }

    public void selectElements(@NotNull List<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/ChooseElementsDialog.selectElements must not be null");
        }
        this.myChooser.selectElements(elements);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChooser.getComponent();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myChooser.getComponent()), "Center");
        if (this.myDescription != null) {
            panel.add((Component)new JLabel(this.myDescription), "North");
        }
        return panel;
    }

    private void setElements(Collection<? extends T> elements, Collection<? extends T> elementsToSelect) {
        this.myChooser.clear();
        for (T item : elements) {
            this.myChooser.addElement(item, false, this.createElementProperties(item));
        }
        this.myChooser.selectElements(elementsToSelect);
    }

    private ElementsChooser.ElementProperties createElementProperties(final T item) {
        return new ElementsChooser.ElementProperties(){

            @Override
            public Icon getIcon() {
                return ChooseElementsDialog.this.getItemIcon(item);
            }

            @Override
            public Color getColor() {
                return null;
            }
        };
    }

    @Nullable
    protected abstract Icon getItemIcon(T var1);
}

