/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.ClassMemberWithElement;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Icons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberChooser<T extends ClassMember>
extends DialogWrapper
implements TypeSafeDataProvider {
    protected Tree myTree;
    private DefaultTreeModel myTreeModel;
    private JCheckBox myCopyJavadocCheckbox;
    private JCheckBox myInsertOverrideAnnotationCheckbox;
    private final ArrayList<MemberNode> mySelectedNodes;
    private boolean mySorted;
    private boolean myShowClasses;
    private boolean myAllowEmptySelection;
    private boolean myAllowMultiSelection;
    private final Project myProject;
    private final boolean myIsInsertOverrideVisible;
    private final JComponent myHeaderPanel;
    private T[] myElements;
    private final HashMap<MemberNode, ParentNode> myNodeToParentMap;
    private final HashMap<ClassMember, MemberNode> myElementToNodeMap;
    private final ArrayList<ContainerNode> myContainerNodes;
    private LinkedHashSet<T> mySelectedElements;
    @NonNls
    private static final String PROP_SORTED = "MemberChooser.sorted";
    @NonNls
    private static final String PROP_SHOWCLASSES = "MemberChooser.showClasses";
    @NonNls
    private static final String PROP_COPYJAVADOC = "MemberChooser.copyJavadoc";

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ide/util/MemberChooser.<init> must not be null");
        }
        this((ClassMember[])elements, allowEmptySelection, allowMultiSelection, project, false);
    }

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ide/util/MemberChooser.<init> must not be null");
        }
        this((ClassMember[])elements, allowEmptySelection, allowMultiSelection, project, isInsertOverrideVisible, null);
    }

    public MemberChooser(T[] elements, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible, JComponent headerPanel) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ide/util/MemberChooser.<init> must not be null");
        }
        super(project, true);
        this.mySelectedNodes = new ArrayList();
        this.mySorted = false;
        this.myShowClasses = true;
        this.myAllowEmptySelection = false;
        this.myNodeToParentMap = new HashMap();
        this.myElementToNodeMap = new HashMap();
        this.myContainerNodes = new ArrayList();
        this.myAllowEmptySelection = allowEmptySelection;
        this.myAllowMultiSelection = allowMultiSelection;
        this.myProject = project;
        this.myIsInsertOverrideVisible = isInsertOverrideVisible;
        this.myHeaderPanel = headerPanel;
        this.myTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.resetElements((ClassMember[])elements);
        this.init();
    }

    public void resetElements(T[] elements) {
        this.myElements = elements;
        this.mySelectedNodes.clear();
        this.myNodeToParentMap.clear();
        this.myElementToNodeMap.clear();
        this.myContainerNodes.clear();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                MemberChooser.this.myTreeModel = MemberChooser.this.buildModel();
            }
        });
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.doSort();
        TreeUtil.expandAll((JTree)this.myTree);
        this.myCopyJavadocCheckbox = new NonFocusableCheckBox(IdeBundle.message((String)"checkbox.copy.javadoc", (Object[])new Object[0]));
        if (this.myIsInsertOverrideVisible) {
            this.myInsertOverrideAnnotationCheckbox = new NonFocusableCheckBox(IdeBundle.message((String)"checkbox.insert.at.override", (Object[])new Object[0]));
        }
        this.myTree.doLayout();
    }

    private DefaultTreeModel buildModel() {
        final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        final Ref count = new Ref((Object)0);
        FactoryMap<MemberChooserObject, ParentNode> map = new FactoryMap<MemberChooserObject, ParentNode>(){

            protected ParentNode create(MemberChooserObject key) {
                ParentNode node = null;
                if (key instanceof PsiElementMemberChooserObject) {
                    ContainerNode containerNode;
                    node = containerNode = new ContainerNode(rootNode, key, (Ref<Integer>)count);
                    MemberChooser.this.myContainerNodes.add(containerNode);
                }
                if (node == null) {
                    node = new ParentNode(rootNode, key, (Ref<Integer>)count);
                }
                return node;
            }
        };
        for (T object : this.myElements) {
            ParentNode parentNode = (ParentNode)map.get((Object)object.getParentNodeDelegate());
            MemberNode elementNode = new MemberNode(parentNode, (ClassMember)object, (Ref<Integer>)count);
            this.myNodeToParentMap.put((Object)elementNode, (Object)parentNode);
            this.myElementToNodeMap.put(object, (Object)elementNode);
        }
        return new DefaultTreeModel(rootNode);
    }

    public void selectElements(ClassMember[] elements) {
        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        for (ClassMember element : elements) {
            MemberNode treeNode = (MemberNode)this.myElementToNodeMap.get((Object)element);
            if (treeNode == null) continue;
            selectionPaths.add(new TreePath(treeNode.getPath()));
        }
        this.myTree.setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
    }

    protected Action[] createActions() {
        if (this.myAllowEmptySelection) {
            return new Action[]{this.getOKAction(), new SelectNoneAction(), this.getCancelAction()};
        }
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected void doHelpAction() {
    }

    protected List<JComponent> customizeOptionsPanel() {
        SmartList list = new SmartList();
        if (this.myIsInsertOverrideVisible) {
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings();
            this.myInsertOverrideAnnotationCheckbox.setSelected(styleSettings.INSERT_OVERRIDE_ANNOTATION);
            list.add((Object)this.myInsertOverrideAnnotationCheckbox);
        }
        this.myCopyJavadocCheckbox.setSelected(PropertiesComponent.getInstance().isTrueValue(PROP_COPYJAVADOC));
        list.add((Object)this.myCopyJavadocCheckbox);
        return list;
    }

    protected JComponent createSouthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel optionsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        for (JComponent component : this.customizeOptionsPanel()) {
            optionsPanel.add(component);
        }
        panel.add((Component)optionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        if (this.myElements == null || this.myElements.length == 0) {
            this.setOKActionEnabled(false);
        }
        panel.add((Component)super.createSouthPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected JComponent createNorthPanel() {
        return this.myHeaderPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillToolbarActions(group);
        group.addSeparator();
        ExpandAllAction expandAllAction = new ExpandAllAction();
        expandAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(61, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
        group.add((AnAction)expandAllAction);
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        collapseAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(45, SystemInfo.isMac ? 4 : 2)), (JComponent)this.myTree);
        group.add((AnAction)collapseAllAction);
        panel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent(), "North");
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof ElementNode) {
                    ((ElementNode)value).getDelegate().renderTreeNode((SimpleColoredComponent)this, tree);
                }
            }
        });
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.addKeyListener((KeyListener)new TreeKeyListener());
        this.myTree.addTreeSelectionListener((TreeSelectionListener)new MyTreeSelectionListener());
        if (!this.myAllowMultiSelection) {
            this.myTree.getSelectionModel().setSelectionMode(1);
        }
        if (this.getRootNode().getChildCount() > 0) {
            this.myTree.expandRow(0);
            this.myTree.setSelectionRow(1);
        }
        TreeUtil.expandAll((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            @Nullable
            public String convert(TreePath path) {
                MemberChooserObject delegate = ((ElementNode)path.getLastPathComponent()).getDelegate();
                return delegate.getText();
            }
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MemberChooser.this.myTree.getPathForLocation(e.getX(), e.getY()) != null) {
                    MemberChooser.this.doOKAction();
                }
            }
        });
        TreeToolTipHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize(new Dimension(350, 450));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    protected void fillToolbarActions(DefaultActionGroup group) {
        SortEmAction sortAction = new SortEmAction();
        sortAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(65, 8)), (JComponent)this.myTree);
        this.setSorted(PropertiesComponent.getInstance().isTrueValue(PROP_SORTED));
        group.add((AnAction)sortAction);
        ShowContainersAction showContainersAction = this.getShowContainersAction();
        showContainersAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(67, 8)), (JComponent)this.myTree);
        this.setShowClasses(PropertiesComponent.getInstance().isTrueValue(PROP_SHOWCLASSES));
        group.add((AnAction)showContainersAction);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.MemberChooser";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    private LinkedHashSet<T> getSelectedElementsList() {
        return this.getExitCode() == 0 ? this.mySelectedElements : null;
    }

    @Nullable
    public List<T> getSelectedElements() {
        LinkedHashSet<T> list = this.getSelectedElementsList();
        return list == null ? null : new ArrayList<T>(list);
    }

    @Nullable
    public T[] getSelectedElements(T[] a) {
        LinkedHashSet<T> list = this.getSelectedElementsList();
        if (list == null) {
            return null;
        }
        return (ClassMember[])list.toArray(a);
    }

    protected final boolean areElementsSelected() {
        return this.mySelectedElements != null && !this.mySelectedElements.isEmpty();
    }

    public void setCopyJavadocVisible(boolean state) {
        this.myCopyJavadocCheckbox.setVisible(state);
    }

    public boolean isCopyJavadoc() {
        return this.myCopyJavadocCheckbox.isSelected();
    }

    public boolean isInsertOverrideAnnotation() {
        return this.myIsInsertOverrideVisible && this.myInsertOverrideAnnotationCheckbox.isSelected();
    }

    private boolean isSorted() {
        return this.mySorted;
    }

    private void setSorted(boolean sorted) {
        if (this.mySorted == sorted) {
            return;
        }
        this.mySorted = sorted;
        this.doSort();
    }

    private void doSort() {
        Pair<ElementNode, List<ElementNode>> pair = this.storeSelection();
        Enumeration<ParentNode> children = this.getRootNodeChildren();
        while (children.hasMoreElements()) {
            ParentNode classNode = children.nextElement();
            MemberChooser.sortNode(classNode, this.mySorted);
            this.myTreeModel.nodeStructureChanged(classNode);
        }
        this.restoreSelection(pair);
    }

    private static void sortNode(ParentNode node, boolean sorted) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            arrayList.add(children.nextElement());
        }
        Collections.sort(arrayList, sorted ? new AlphaComparator() : new OrderComparator());
        MemberChooser.replaceChildren(node, arrayList);
    }

    private static void replaceChildren(DefaultMutableTreeNode node, Collection<? extends ElementNode> arrayList) {
        node.removeAllChildren();
        for (ElementNode elementNode : arrayList) {
            node.add(elementNode);
        }
    }

    private void setShowClasses(boolean showClasses) {
        this.myShowClasses = showClasses;
        Pair<ElementNode, List<ElementNode>> selection = this.storeSelection();
        DefaultMutableTreeNode root = this.getRootNode();
        if (!this.myShowClasses || this.myContainerNodes.isEmpty()) {
            ArrayList<ParentNode> otherObjects = new ArrayList<ParentNode>();
            Enumeration<ParentNode> children = this.getRootNodeChildren();
            ParentNode newRoot = new ParentNode(null, (MemberChooserObject)new MemberChooserObjectBase(this.getAllContainersNodeName()), (Ref<Integer>)new Ref((Object)0));
            while (children.hasMoreElements()) {
                ParentNode nextElement = children.nextElement();
                if (nextElement instanceof ContainerNode) {
                    ContainerNode containerNode = (ContainerNode)nextElement;
                    Enumeration<TreeNode> enumeration = containerNode.children();
                    ArrayList<TreeNode> memberNodesList = new ArrayList<TreeNode>();
                    while (enumeration.hasMoreElements()) {
                        memberNodesList.add(enumeration.nextElement());
                    }
                    for (MemberNode memberNode : memberNodesList) {
                        newRoot.add(memberNode);
                    }
                    continue;
                }
                otherObjects.add(nextElement);
            }
            MemberChooser.replaceChildren(root, otherObjects);
            MemberChooser.sortNode(newRoot, this.mySorted);
            if (newRoot.children().hasMoreElements()) {
                root.add(newRoot);
            }
        } else {
            Enumeration<ParentNode> children = this.getRootNodeChildren();
            if (children.hasMoreElements()) {
                ParentNode allClassesNode = children.nextElement();
                Enumeration<TreeNode> memberNodes = allClassesNode.children();
                ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
                while (memberNodes.hasMoreElements()) {
                    arrayList.add(memberNodes.nextElement());
                }
                for (MemberNode memberNode : arrayList) {
                    ((ParentNode)this.myNodeToParentMap.get((Object)memberNode)).add(memberNode);
                }
            }
            MemberChooser.replaceChildren(root, this.myContainerNodes);
        }
        this.myTreeModel.nodeStructureChanged(root);
        TreeUtil.expandAll((JTree)this.myTree);
        this.restoreSelection(selection);
    }

    protected String getAllContainersNodeName() {
        return IdeBundle.message((String)"node.memberchooser.all.classes", (Object[])new Object[0]);
    }

    private Enumeration<ParentNode> getRootNodeChildren() {
        return this.getRootNode().children();
    }

    private DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.myTreeModel.getRoot();
    }

    private Pair<ElementNode, List<ElementNode>> storeSelection() {
        TreePath leadSelectionPath;
        ArrayList<ElementNode> selectedNodes = new ArrayList<ElementNode>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                selectedNodes.add((ElementNode)path.getLastPathComponent());
            }
        }
        return Pair.create((Object)((leadSelectionPath = this.myTree.getLeadSelectionPath()) != null ? (ElementNode)leadSelectionPath.getLastPathComponent() : null), selectedNodes);
    }

    private void restoreSelection(Pair<ElementNode, List<ElementNode>> pair) {
        ElementNode leadNode;
        List selectedNodes = (List)pair.second;
        DefaultMutableTreeNode root = this.getRootNode();
        ArrayList<TreePath> toSelect = new ArrayList<TreePath>();
        for (ElementNode node : selectedNodes) {
            if (!root.isNodeDescendant(node)) continue;
            toSelect.add(new TreePath(node.getPath()));
        }
        if (!toSelect.isEmpty()) {
            this.myTree.setSelectionPaths(toSelect.toArray(new TreePath[toSelect.size()]));
        }
        if ((leadNode = (ElementNode)pair.first) != null) {
            this.myTree.setLeadSelectionPath(new TreePath(leadNode.getPath()));
        }
    }

    public void dispose() {
        PropertiesComponent instance = PropertiesComponent.getInstance();
        instance.setValue(PROP_SORTED, Boolean.toString(this.isSorted()));
        instance.setValue(PROP_SHOWCLASSES, Boolean.toString(this.myShowClasses));
        instance.setValue(PROP_COPYJAVADOC, Boolean.toString(this.myCopyJavadocCheckbox.isSelected()));
        this.getContentPane().removeAll();
        this.mySelectedNodes.clear();
        this.myElements = null;
        super.dispose();
    }

    public void calcData(DataKey key, DataSink sink) {
        ClassMember selectedElement;
        if (key.equals(LangDataKeys.PSI_ELEMENT) && this.mySelectedElements != null && !this.mySelectedElements.isEmpty() && (selectedElement = (ClassMember)this.mySelectedElements.iterator().next()) instanceof ClassMemberWithElement) {
            sink.put(LangDataKeys.PSI_ELEMENT, (Object)((ClassMemberWithElement)selectedElement).getElement());
        }
    }

    protected ShowContainersAction getShowContainersAction() {
        return new ShowContainersAction(IdeBundle.message((String)"action.show.classes", (Object[])new Object[0]), Icons.CLASS_ICON);
    }

    private static class OrderComparator
    implements Comparator<ElementNode> {
        private OrderComparator() {
        }

        @Override
        public int compare(ElementNode n1, ElementNode n2) {
            if (n1.getDelegate() instanceof ClassMemberWithElement && n2.getDelegate() instanceof ClassMemberWithElement) {
                return ((ClassMemberWithElement)n1.getDelegate()).getElement().getTextOffset() - ((ClassMemberWithElement)n2.getDelegate()).getElement().getTextOffset();
            }
            return n1.getOrder() - n2.getOrder();
        }
    }

    private static class AlphaComparator
    implements Comparator<ElementNode> {
        private AlphaComparator() {
        }

        @Override
        public int compare(ElementNode n1, ElementNode n2) {
            return n1.getDelegate().getText().compareToIgnoreCase(n2.getDelegate().getText());
        }
    }

    private class CollapseAllAction
    extends AnAction {
        public CollapseAllAction() {
            super(IdeBundle.message((String)"action.collapse.all", (Object[])new Object[0]), IdeBundle.message((String)"action.collapse.all", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/collapseall.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            TreeUtil.collapseAll((JTree)MemberChooser.this.myTree, (int)1);
        }
    }

    private class ExpandAllAction
    extends AnAction {
        public ExpandAllAction() {
            super(IdeBundle.message((String)"action.expand.all", (Object[])new Object[0]), IdeBundle.message((String)"action.expand.all", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/expandall.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            TreeUtil.expandAll((JTree)MemberChooser.this.myTree);
        }
    }

    protected class ShowContainersAction
    extends ToggleAction {
        public ShowContainersAction(String text, Icon icon) {
            super(text, text, icon);
        }

        public boolean isSelected(AnActionEvent event) {
            return MemberChooser.this.myShowClasses;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            MemberChooser.this.setShowClasses(flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(MemberChooser.this.myContainerNodes.size() > 1);
        }
    }

    private class SortEmAction
    extends ToggleAction {
        public SortEmAction() {
            super(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IconLoader.getIcon((String)"/objectBrowser/sorted.png"));
        }

        public boolean isSelected(AnActionEvent event) {
            return MemberChooser.this.isSorted();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            MemberChooser.this.setSorted(flag);
        }
    }

    private class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath path = MemberChooser.this.myTree.getLeadSelectionPath();
            if (path == null) {
                return;
            }
            Object lastComponent = path.getLastPathComponent();
            if (e.getKeyCode() == 10) {
                if (lastComponent instanceof ParentNode) {
                    return;
                }
                MemberChooser.this.doOKAction();
                e.consume();
            } else if (e.getKeyCode() == 155 && lastComponent instanceof ElementNode) {
                ElementNode node = (ElementNode)lastComponent;
                if (!MemberChooser.this.mySelectedNodes.contains(node)) {
                    if (node.getNextNode() != null) {
                        MemberChooser.this.myTree.setSelectionPath(new TreePath(node.getNextNode().getPath()));
                    }
                } else if (node.getNextNode() != null) {
                    MemberChooser.this.myTree.removeSelectionPath(new TreePath(node.getPath()));
                    MemberChooser.this.myTree.setSelectionPath(new TreePath(node.getNextNode().getPath()));
                    MemberChooser.this.myTree.repaint();
                }
                e.consume();
            }
        }
    }

    private class SelectNoneAction
    extends AbstractAction {
        public SelectNoneAction() {
            super(IdeBundle.message((String)"action.select.none", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberChooser.this.myTree.clearSelection();
            MemberChooser.this.doOKAction();
        }
    }

    private static class ContainerNode
    extends ParentNode {
        public ContainerNode(DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            super(parent, delegate, order);
        }
    }

    private static class ParentNode
    extends ElementNode {
        public ParentNode(@Nullable DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            super(parent, delegate, order);
        }
    }

    private static class MemberNode
    extends ElementNode {
        public MemberNode(ParentNode parent, ClassMember delegate, Ref<Integer> order) {
            super(parent, (MemberChooserObject)delegate, order);
        }
    }

    private static abstract class ElementNode
    extends DefaultMutableTreeNode {
        private final int myOrder;
        private final MemberChooserObject myDelegate;

        public ElementNode(@Nullable DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            this.myOrder = (Integer)order.get();
            order.set((Object)(this.myOrder + 1));
            this.myDelegate = delegate;
            if (parent != null) {
                parent.add(this);
            }
        }

        public MemberChooserObject getDelegate() {
            return this.myDelegate;
        }

        public int getOrder() {
            return this.myOrder;
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            if (paths == null) {
                return;
            }
            for (int i = 0; i < paths.length; ++i) {
                Object node = paths[i].getLastPathComponent();
                if (!(node instanceof MemberNode)) continue;
                MemberNode memberNode = (MemberNode)node;
                if (e.isAddedPath(i)) {
                    if (MemberChooser.this.mySelectedNodes.contains(memberNode)) continue;
                    MemberChooser.this.mySelectedNodes.add(memberNode);
                    continue;
                }
                MemberChooser.this.mySelectedNodes.remove(memberNode);
            }
            MemberChooser.this.mySelectedElements = new LinkedHashSet();
            for (MemberNode selectedNode : MemberChooser.this.mySelectedNodes) {
                MemberChooser.this.mySelectedElements.add((ClassMember)selectedNode.getDelegate());
            }
        }
    }
}

