/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import java.util.concurrent.ConcurrentMap;

public class TreeViewUtil {
    private static final int SUBPACKAGE_LIMIT = 2;
    private static final Key<ResolveCache.MapPair<PsiPackage, Boolean>> SHOULD_ABBREV_PACK_KEY = Key.create((String)"PACK_ABBREV_CACHE");

    private static boolean shouldAbbreviateName(PsiPackage aPackage) {
        ConcurrentMap<PsiPackage, Boolean> map = ((PsiManagerEx)PsiManager.getInstance((Project)aPackage.getProject())).getResolveCache().getOrCreateWeakMap(SHOULD_ABBREV_PACK_KEY, true);
        Boolean ret = (Boolean)map.get(aPackage);
        if (ret != null) {
            return ret;
        }
        ret = TreeViewUtil.scanPackages(aPackage, 1);
        map.put(aPackage, ret);
        return ret;
    }

    private static boolean scanPackages(PsiPackage p, int packageNameOccurrencesFound) {
        PsiPackage[] subPackages = p.getSubPackages();
        if ((packageNameOccurrencesFound += subPackages.length) > 2) {
            return true;
        }
        for (PsiPackage subPackage : subPackages) {
            if (!TreeViewUtil.scanPackages(subPackage, packageNameOccurrencesFound)) continue;
            return true;
        }
        return false;
    }

    public static String calcAbbreviatedPackageFQName(PsiPackage aPackage) {
        String packageName;
        StringBuilder name = new StringBuilder(aPackage.getName());
        for (PsiPackage parentPackage = aPackage.getParentPackage(); parentPackage != null && (packageName = parentPackage.getName()) != null && packageName.length() != 0; parentPackage = parentPackage.getParentPackage()) {
            name.insert(0, ".");
            if (packageName.length() > 2 && TreeViewUtil.shouldAbbreviateName(parentPackage)) {
                name.insert(0, packageName.substring(0, 1));
                continue;
            }
            name.insert(0, packageName);
        }
        return name.toString();
    }

    public static boolean isEmptyMiddlePackage(PsiDirectory dir, boolean strictlyEmpty) {
        VirtualFile[] files = dir.getVirtualFile().getChildren();
        if (files.length == 0) {
            return false;
        }
        PsiManager manager = dir.getManager();
        int subpackagesCount = 0;
        int directoriesCount = 0;
        for (VirtualFile file : files) {
            if (FileTypeManager.getInstance().isFileIgnored(file.getName())) continue;
            if (!file.isDirectory()) {
                return false;
            }
            PsiDirectory childDir = manager.findDirectory(file);
            if (childDir == null) continue;
            if (strictlyEmpty && ++directoriesCount > 1) {
                return false;
            }
            if (JavaDirectoryService.getInstance().getPackage(childDir) == null) continue;
            ++subpackagesCount;
        }
        if (strictlyEmpty) {
            return directoriesCount == subpackagesCount && directoriesCount == 1;
        }
        return directoriesCount == subpackagesCount && directoriesCount > 0;
    }
}

