/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.BundledQuickListsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QuickListsManager
implements ExportableApplicationComponent,
NamedJDOMExternalizable {
    @NonNls
    private static final String LIST_TAG = "list";
    private final ActionManager myActionManager;
    private final SchemesManager<QuickList, QuickList> mySchemesManager;
    private static final Logger LOG = Logger.getInstance((String)("#" + QuickListsManager.class.getName()));

    public static QuickListsManager getInstance() {
        return (QuickListsManager)ApplicationManager.getApplication().getComponent(QuickListsManager.class);
    }

    public QuickListsManager(ActionManagerEx actionManagerEx, SchemesManagerFactory schemesManagerFactory) {
        this.myActionManager = actionManagerEx;
        this.mySchemesManager = schemesManagerFactory.createSchemesManager("$ROOT_CONFIG$/quicklists", (SchemeProcessor)new SchemeProcessor<QuickList>(){

            public QuickList readScheme(Document schemeContent) throws InvalidDataException, IOException, JDOMException {
                return QuickListsManager.this.loadListFromDocument(schemeContent);
            }

            public Document writeScheme(QuickList scheme) throws WriteExternalException {
                Element element = new Element(QuickListsManager.LIST_TAG);
                scheme.writeExternal(element);
                return new Document(element);
            }

            public boolean shouldBeSaved(QuickList scheme) {
                return true;
            }

            public void initScheme(QuickList scheme) {
            }

            public void onSchemeAdded(QuickList scheme) {
            }

            public void onSchemeDeleted(QuickList scheme) {
            }

            public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
            }
        }, RoamingType.PER_USER);
        this.loadAdditionalDefaultSchemes();
        this.registerActions();
    }

    private QuickList loadListFromDocument(Document schemeContent) {
        QuickList list = new QuickList();
        list.readExternal(schemeContent.getRootElement());
        return list;
    }

    @NotNull
    public String getComponentName() {
        if ("QuickListsManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/ex/QuickListsManager.getComponentName must not return null");
        }
        return "QuickListsManager";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/ex/QuickListsManager.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message((String)"quick.lists.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/ex/QuickListsManager.getPresentableName must not return null");
        }
        return string;
    }

    public void initComponent() {
        this.mySchemesManager.loadSchemes();
        this.registerActions();
    }

    public void disposeComponent() {
    }

    public String getExternalFileName() {
        return "quicklists";
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (Object group : element.getChildren(LIST_TAG)) {
            Element groupElement = (Element)group;
            QuickList list = new QuickList();
            list.readExternal(groupElement);
            this.mySchemesManager.addNewScheme((Scheme)list, true);
        }
        this.mySchemesManager.loadSchemes();
        this.registerActions();
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    public QuickList[] getAllQuickLists() {
        List lists = this.mySchemesManager.getAllSchemes();
        return lists.toArray(new QuickList[lists.size()]);
    }

    public void removeAllQuickLists() {
        this.mySchemesManager.clearAllSchemes();
    }

    public void registerActions() {
        this.unregisterActions();
        HashSet<String> registeredIds = new HashSet<String>();
        ActionManager actionManager = this.myActionManager;
        for (QuickList list : this.mySchemesManager.getAllSchemes()) {
            String actionId = list.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            actionManager.registerAction(actionId, (AnAction)new InvokeQuickListAction(list));
        }
    }

    private void unregisterActions() {
        ActionManagerEx actionManager = (ActionManagerEx)this.myActionManager;
        for (String oldId : actionManager.getActionIds("QuickList.")) {
            actionManager.unregisterAction(oldId);
        }
    }

    public void registerQuickList(QuickList quickList) {
        this.mySchemesManager.addNewScheme((Scheme)quickList, true);
    }

    public SchemesManager<QuickList, QuickList> getSchemesManager() {
        return this.mySchemesManager;
    }

    private void loadAdditionalDefaultSchemes() {
        for (BundledQuickListsProvider provider : (BundledQuickListsProvider[])BundledQuickListsProvider.EP_NAME.getExtensions()) {
            String[] paths;
            for (final String path : paths = provider.getBundledListsRelativePaths()) {
                try {
                    Document document;
                    InputStream inputStream = DecodeDefaultsUtil.getDefaultsInputStream(provider, path);
                    if (inputStream == null) {
                        LOG.error("Cannot read quick list from " + path);
                        continue;
                    }
                    try {
                        document = JDOMUtil.loadDocument((InputStream)inputStream);
                    }
                    catch (JDOMException e) {
                        LOG.info("Error reading quick list from  " + path + ": " + e.getLocalizedMessage());
                        throw e;
                    }
                    QuickList scheme = this.loadListFromDocument(document);
                    this.mySchemesManager.addNewScheme((Scheme)scheme, false);
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOG.error("Cannot read quick list from " + path + ": " + e.getLocalizedMessage(), (Throwable)e);
                        }
                    });
                }
            }
        }
    }

    private static class InvokeQuickListAction
    extends QuickSwitchSchemeAction {
        private final QuickList myQuickList;

        public InvokeQuickListAction(QuickList quickList) {
            this.myQuickList = quickList;
            this.getTemplatePresentation().setDescription(this.myQuickList.getDescription());
            this.getTemplatePresentation().setText(this.myQuickList.getDisplayName(), false);
        }

        protected void fillActions(Project project, DefaultActionGroup group, DataContext dataContext) {
            ActionManager actionManager = ActionManagerEx.getInstance();
            for (String actionId : this.myQuickList.getActionIds()) {
                if ("QuickList.$Separator$".equals(actionId)) {
                    group.addSeparator();
                    continue;
                }
                AnAction action = actionManager.getAction(actionId);
                if (action == null) continue;
                group.add(action);
            }
        }

        protected boolean isEnabled() {
            return true;
        }
    }
}

