/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class ImportOldConfigsPanel
extends JDialog {
    private TextFieldWithBrowseButton myPrevInstallation;
    private JRadioButton myRbDoNotImport;
    private JRadioButton myRbImport;
    private JPanel myRootPanel;
    private File myLastSelection = null;
    private JButton myOkButton;
    private JLabel mySuggestLabel;
    private JLabel myHomeLabel;

    public ImportOldConfigsPanel(Frame owner) {
        super(owner, true);
        this.$$$setupUI$$$();
        this.init();
    }

    public ImportOldConfigsPanel() {
        super((Dialog)null, true);
        this.$$$setupUI$$$();
        this.init();
    }

    private void init() {
        String prevInstall;
        new MnemonicHelper().register((Component)this.getContentPane());
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbDoNotImport);
        group.add(this.myRbImport);
        this.myRbDoNotImport.setSelected(true);
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String productName = namesInfo.getProductName().equals("IDEA") ? namesInfo.getFullProductName() : namesInfo.getProductName();
        this.mySuggestLabel.setText(ApplicationBundle.message((String)"label.you.can.import", (Object[])new Object[]{productName}));
        this.myRbDoNotImport.setText(ApplicationBundle.message((String)"radio.do.not.import", (Object[])new Object[]{productName}));
        this.myHomeLabel.setText(ApplicationBundle.message((String)"editbox.installation.home", (Object[])new Object[]{productName}));
        this.myRbImport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportOldConfigsPanel.this.update();
            }
        });
        if (SystemInfo.isMac) {
            this.myPrevInstallation.setText(ImportOldConfigsPanel.findPreviousInstallationMac(productName));
        } else if (SystemInfo.isWindows && (prevInstall = ImportOldConfigsPanel.findPreviousInstallationWindows(productName)) != null) {
            this.myPrevInstallation.setText(prevInstall);
        }
        this.myPrevInstallation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                int returnVal;
                JFileChooser fc = new JFileChooser();
                if (ImportOldConfigsPanel.this.myLastSelection != null) {
                    fc = new JFileChooser(ImportOldConfigsPanel.this.myLastSelection);
                }
                if (!SystemInfo.isMac) {
                    fc.setFileSelectionMode(1);
                }
                if ((returnVal = fc.showOpenDialog(ImportOldConfigsPanel.this)) == 0 && (file = fc.getSelectedFile()) != null) {
                    ImportOldConfigsPanel.this.myLastSelection = file;
                    ImportOldConfigsPanel.this.myPrevInstallation.setText(file.getAbsolutePath());
                }
            }
        });
        this.myOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOldConfigsPanel.this.close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myRootPanel);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.setTitle(ApplicationBundle.message((String)"title.complete.installation", (Object[])new Object[0]));
        this.update();
        this.pack();
        Dimension parentSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension ownSize = this.getPreferredSize();
        this.setLocation((parentSize.width - ownSize.width) / 2, (parentSize.height - ownSize.height) / 2);
    }

    @Nullable
    private static String findPreviousInstallationWindows(String productName) {
        File jetbrainsHome;
        String programFiles = System.getenv("ProgramFiles");
        if (programFiles != null && (jetbrainsHome = new File(programFiles, "JetBrains")).isDirectory()) {
            File[] files = jetbrainsHome.listFiles();
            String latestVersion = null;
            File latestFile = null;
            for (File file : files) {
                String versionName;
                if (!file.isDirectory() || !file.getName().startsWith(productName) || (versionName = file.getName().substring(productName.length()).trim()).indexOf(46) <= 0 || latestVersion != null && StringUtil.compareVersionNumbers((String)latestVersion, (String)versionName) <= 0) continue;
                latestVersion = versionName;
                latestFile = file;
            }
            if (latestFile != null) {
                return latestFile.getAbsolutePath();
            }
        }
        return null;
    }

    private static String findPreviousInstallationMac(String productName) {
        String mostProbable = "/Applications/" + productName;
        if (new File(mostProbable).exists()) {
            return mostProbable;
        }
        return "/Applications";
    }

    private void close() {
        if (this.isImportEnabled()) {
            String productWithVendor = ApplicationNamesInfo.getInstance().getFullProductName();
            String instHome = this.myPrevInstallation.getText();
            if ("".equals(instHome)) {
                JOptionPane.showMessageDialog(this, ApplicationBundle.message((String)"error.please.select.previous.installation.home", (Object[])new Object[]{productWithVendor}), ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]), 0);
                return;
            }
            if (PathManager.getHomePath().equals(instHome)) {
                JOptionPane.showMessageDialog(this, ApplicationBundle.message((String)"error.selected.current.installation.home", (Object[])new Object[]{productWithVendor, productWithVendor}), ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]), 0);
                return;
            }
            if (!ConfigImportHelper.isInstallationHome(instHome)) {
                JOptionPane.showMessageDialog(this, ApplicationBundle.message((String)"error.does.not.appear.to.be.installation.home", (Object[])new Object[]{instHome, productWithVendor}), ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]), 0);
                return;
            }
            if (!new File(instHome).canRead()) {
                JOptionPane.showMessageDialog(this, ApplicationBundle.message((String)"error.no.read.permissions", (Object[])new Object[]{instHome}), ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]), 0);
                return;
            }
        }
        this.dispose();
    }

    public boolean isImportEnabled() {
        return this.myRbImport.isSelected();
    }

    public File getSelectedFile() {
        return new File(this.myPrevInstallation.getText());
    }

    private void update() {
        this.myPrevInstallation.setEnabled(this.myRbImport.isSelected());
    }

    public static void main(String[] args) {
        ImportOldConfigsPanel dlg = new ImportOldConfigsPanel();
        dlg.setVisible(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JLabel jLabel2;
        JButton jButton;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.ok"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySuggestLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.you.can.import"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myRbImport = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.import"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRbDoNotImport = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.do.not.import"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myHomeLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.installation.home"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrevInstallation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel3.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(10, 0), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

