/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;

public class PersistentLineMarker
extends RangeMarkerImpl {
    private int myLine;

    public PersistentLineMarker(DocumentEx document, int offset) {
        super(document, offset, offset);
        this.myLine = document.getLineNumber(offset);
    }

    @Override
    protected void changedUpdateImpl(DocumentEvent e) {
        DocumentEventImpl event = (DocumentEventImpl)e;
        if (event.isWholeTextReplaced()) {
            this.myLine = event.translateLineViaDiff(this.myLine);
            if (this.myLine < 0 || this.myLine >= this.getDocument().getLineCount()) {
                this.invalidate();
            } else {
                this.myEnd = this.myStart = MarkupModelImpl.getFirstNonspaceCharOffset(this.getDocument(), this.myLine);
            }
        } else {
            super.changedUpdateImpl(e);
            if (this.isValid()) {
                this.myLine = this.getDocument().getLineNumber(this.myStart);
            }
        }
    }

    @Override
    public String toString() {
        return "PersistentLineMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " - " + this.myLine + (this.isGreedyToRight() ? "]" : ")");
    }
}

