/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class SelectionModelImpl
implements SelectionModel,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.SelectionModelImpl");
    private final CopyOnWriteArrayList<SelectionListener> mySelectionListeners = ContainerUtil.createEmptyCOWList();
    private MyRangeMarker mySelectionMarker = null;
    private final EditorImpl myEditor;
    private int myLastSelectionStart;
    private LogicalPosition myBlockStart;
    private LogicalPosition myBlockEnd;
    private TextAttributes myTextAttributes;
    private DocumentEvent myIsInUpdate;

    public void beforeDocumentChange(DocumentEvent event) {
        this.myIsInUpdate = event;
    }

    public void documentChanged(DocumentEvent event) {
        if (this.myIsInUpdate == event) {
            this.myIsInUpdate = null;
            if (this.mySelectionMarker != null && this.mySelectionMarker.isValid()) {
                this.mySelectionMarker.documentChanged(event);
            }
        }
    }

    @Override
    public int getPriority() {
        return 4;
    }

    public SelectionModelImpl(EditorImpl editor) {
        this.myEditor = editor;
    }

    public int getSelectionStart() {
        this.validateContext(false);
        if (!this.hasSelection()) {
            return this.myEditor.getCaretModel().getOffset();
        }
        return this.mySelectionMarker.getStartOffset();
    }

    private void validateContext(boolean isWrite) {
        if (isWrite) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        } else {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if (this.myIsInUpdate != null) {
            this.documentChanged(this.myIsInUpdate);
        }
    }

    public int getSelectionEnd() {
        this.validateContext(false);
        if (!this.hasSelection()) {
            return this.myEditor.getCaretModel().getOffset();
        }
        return this.mySelectionMarker.getEndOffset();
    }

    public boolean hasSelection() {
        this.validateContext(false);
        if (this.mySelectionMarker != null && !this.mySelectionMarker.isValid()) {
            this.removeSelection();
        }
        return this.mySelectionMarker != null;
    }

    public void setSelection(int startOffset, int endOffset) {
        int oldSelectionEnd;
        int oldSelectionStart;
        Toolkit toolkit;
        Clipboard clip;
        this.validateContext(true);
        this.removeBlockSelection();
        Document doc = this.myEditor.getDocument();
        if (startOffset < 0 || startOffset > doc.getTextLength()) {
            LOG.error("Wrong startOffset: " + startOffset);
        }
        if (endOffset < 0 || endOffset > doc.getTextLength()) {
            LOG.error("Wrong endOffset: " + endOffset);
        }
        this.myLastSelectionStart = startOffset;
        if (startOffset == endOffset) {
            this.removeSelection();
            return;
        }
        if (startOffset > endOffset) {
            int tmp = startOffset;
            startOffset = endOffset;
            endOffset = tmp;
        }
        if (!GraphicsEnvironment.isHeadless() && (clip = (toolkit = this.myEditor.getComponent().getToolkit()).getSystemSelection()) != null) {
            clip.setContents(new StringSelection(this.getSelectedText()), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
        if (this.hasSelection()) {
            oldSelectionStart = this.mySelectionMarker.getStartOffset();
            oldSelectionEnd = this.mySelectionMarker.getEndOffset();
            if (oldSelectionStart == startOffset && oldSelectionEnd == endOffset) {
                return;
            }
        } else {
            oldSelectionStart = oldSelectionEnd = this.myEditor.getCaretModel().getOffset();
        }
        if (this.mySelectionMarker != null) {
            this.mySelectionMarker.release();
        }
        this.mySelectionMarker = new MyRangeMarker((DocumentEx)doc, startOffset, endOffset);
        this.fireSelectionChanged(oldSelectionStart, oldSelectionEnd, startOffset, endOffset);
    }

    private void fireSelectionChanged(int oldSelectionStart, int oldSelectionEnd, int startOffset, int endOffset) {
        this.repaintBySelectionChange(oldSelectionStart, startOffset, oldSelectionEnd, endOffset);
        SelectionEvent event = new SelectionEvent((Editor)this.myEditor, oldSelectionStart, oldSelectionEnd, startOffset, endOffset);
        for (SelectionListener listener : this.mySelectionListeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void repaintBySelectionChange(int oldSelectionStart, int startOffset, int oldSelectionEnd, int endOffset) {
        this.myEditor.repaint(Math.min(oldSelectionStart, startOffset), Math.max(oldSelectionStart, startOffset));
        this.myEditor.repaint(Math.min(oldSelectionEnd, endOffset), Math.max(oldSelectionEnd, endOffset));
    }

    public void setBlockSelection(LogicalPosition blockStart, LogicalPosition blockEnd) {
        int newEndLine;
        int newStartLine;
        this.removeSelection();
        int oldStartLine = 0;
        int oldEndLine = 0;
        if (this.hasBlockSelection() && (oldStartLine = this.myBlockStart.line) > (oldEndLine = this.myBlockEnd.line)) {
            int t = oldStartLine;
            oldStartLine = oldEndLine;
            oldEndLine = t;
        }
        if ((newStartLine = blockStart.line) > (newEndLine = blockEnd.line)) {
            int t = newStartLine;
            newStartLine = newEndLine;
            newEndLine = t;
        }
        this.myEditor.repaintLines(Math.min(oldStartLine, newStartLine), Math.max(newEndLine, oldEndLine));
        this.myBlockStart = blockStart;
        this.myBlockEnd = blockEnd;
    }

    public void removeSelection() {
        this.validateContext(true);
        this.removeBlockSelection();
        this.myLastSelectionStart = this.myEditor.getCaretModel().getOffset();
        if (this.mySelectionMarker != null) {
            int startOffset = this.mySelectionMarker.getStartOffset();
            int endOffset = this.mySelectionMarker.getEndOffset();
            this.mySelectionMarker.release();
            this.mySelectionMarker = null;
            this.fireSelectionChanged(startOffset, endOffset, this.myLastSelectionStart, this.myLastSelectionStart);
        }
    }

    public void removeBlockSelection() {
        if (this.hasBlockSelection()) {
            this.myEditor.repaint(0, this.myEditor.getDocument().getTextLength());
            this.myBlockStart = null;
            this.myBlockEnd = null;
        }
    }

    public boolean hasBlockSelection() {
        return this.myBlockStart != null;
    }

    public LogicalPosition getBlockStart() {
        return this.myBlockStart;
    }

    public LogicalPosition getBlockEnd() {
        return this.myBlockEnd;
    }

    public boolean isBlockSelectionGuarded() {
        if (!this.hasBlockSelection()) {
            return false;
        }
        int[] starts = this.getBlockSelectionStarts();
        int[] ends = this.getBlockSelectionEnds();
        Document doc = this.myEditor.getDocument();
        for (int i = 0; i < starts.length; ++i) {
            int start = starts[i];
            int end = ends[i];
            if ((start != end || doc.getOffsetGuard(start) == null) && (start == end || doc.getRangeGuard(start, end) == null)) continue;
            return true;
        }
        return false;
    }

    public RangeMarker getBlockSelectionGuard() {
        if (!this.hasBlockSelection()) {
            return null;
        }
        int[] starts = this.getBlockSelectionStarts();
        int[] ends = this.getBlockSelectionEnds();
        Document doc = this.myEditor.getDocument();
        for (int i = 0; i < starts.length; ++i) {
            RangeMarker guard;
            int start = starts[i];
            int end = ends[i];
            if (start == end && (guard = doc.getOffsetGuard(start)) != null) {
                return guard;
            }
            if (start == end || (guard = doc.getRangeGuard(start, end)) == null) continue;
            return guard;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public int[] getBlockSelectionStarts() {
        int[] nArray;
        if (this.hasSelection()) {
            nArray = new int[]{this.getSelectionStart()};
            if (nArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/SelectionModelImpl.getBlockSelectionStarts must not return null");
            return nArray;
        }
        if (!this.hasBlockSelection()) {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
            if (ArrayUtil.EMPTY_INT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/SelectionModelImpl.getBlockSelectionStarts must not return null");
            return nArray;
        }
        int lineCount = Math.abs(this.myBlockEnd.line - this.myBlockStart.line) + 1;
        int startLine = Math.min(this.myBlockStart.line, this.myBlockEnd.line);
        int startColumn = Math.min(this.myBlockStart.column, this.myBlockEnd.column);
        int[] res = new int[lineCount];
        for (int i = startLine; i < startLine + lineCount; ++i) {
            res[i - startLine] = this.myEditor.logicalPositionToOffset(new LogicalPosition(i, startColumn));
        }
        nArray = res;
        if (res != null) return nArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/SelectionModelImpl.getBlockSelectionStarts must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public int[] getBlockSelectionEnds() {
        int[] nArray;
        if (this.hasSelection()) {
            nArray = new int[]{this.getSelectionEnd()};
            if (nArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/SelectionModelImpl.getBlockSelectionEnds must not return null");
            return nArray;
        }
        if (!this.hasBlockSelection()) {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
            if (ArrayUtil.EMPTY_INT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/SelectionModelImpl.getBlockSelectionEnds must not return null");
            return nArray;
        }
        int lineCount = Math.abs(this.myBlockEnd.line - this.myBlockStart.line) + 1;
        int startLine = Math.min(this.myBlockStart.line, this.myBlockEnd.line);
        int startColumn = Math.min(this.myBlockStart.column, this.myBlockEnd.column);
        int columnCount = Math.abs(this.myBlockEnd.column - this.myBlockStart.column);
        int[] res = new int[lineCount];
        for (int i = startLine; i < startLine + lineCount; ++i) {
            res[i - startLine] = this.myEditor.logicalPositionToOffset(new LogicalPosition(i, startColumn + columnCount));
        }
        nArray = res;
        if (res != null) return nArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/SelectionModelImpl.getBlockSelectionEnds must not return null");
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mySelectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        boolean success = this.mySelectionListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public String getSelectedText() {
        this.validateContext(false);
        if (!this.hasSelection() && !this.hasBlockSelection()) {
            return null;
        }
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        if (this.hasBlockSelection()) {
            int[] starts = this.getBlockSelectionStarts();
            int[] ends = this.getBlockSelectionEnds();
            int width = Math.abs(this.myBlockEnd.column - this.myBlockStart.column);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < starts.length; ++i) {
                if (i > 0) {
                    buf.append('\n');
                }
                int len = ends[i] - starts[i];
                SelectionModelImpl.appendCharSequence(buf, text, starts[i], len);
                for (int j = len; j < width; ++j) {
                    buf.append(' ');
                }
            }
            return buf.toString();
        }
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        return ((Object)text.subSequence(selectionStart, selectionEnd)).toString();
    }

    private static void appendCharSequence(@NotNull StringBuffer buf, @NotNull CharSequence s, int srcOffset, int len) {
        if (buf == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/SelectionModelImpl.appendCharSequence must not be null");
        }
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/SelectionModelImpl.appendCharSequence must not be null");
        }
        if (srcOffset < 0 || len < 0 || srcOffset > s.length() - len) {
            throw new IndexOutOfBoundsException("srcOffset " + srcOffset + ", len " + len + ", s.length() " + s.length());
        }
        if (len == 0) {
            return;
        }
        int limit = srcOffset + len;
        for (int i = srcOffset; i < limit; ++i) {
            buf.append(s.charAt(i));
        }
    }

    public int getLeadSelectionOffset() {
        this.validateContext(false);
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        if (!this.hasSelection()) {
            return caretOffset;
        }
        int startOffset = this.mySelectionMarker.getStartOffset();
        int endOffset = this.mySelectionMarker.getEndOffset();
        if (caretOffset == endOffset) {
            return startOffset;
        }
        return endOffset;
    }

    public void selectLineAtCaret() {
        this.validateContext(true);
        int lineNumber = this.myEditor.getCaretModel().getLogicalPosition().line;
        Document document = this.myEditor.getDocument();
        if (lineNumber >= document.getLineCount()) {
            return;
        }
        VisualPosition caret = this.myEditor.getCaretModel().getVisualPosition();
        LogicalPosition lineStart = this.myEditor.visualToLogicalPosition(new VisualPosition(caret.line, 0));
        LogicalPosition nextLineStart = this.myEditor.visualToLogicalPosition(new VisualPosition(caret.line + 1, 0));
        int start = this.myEditor.logicalPositionToOffset(lineStart);
        int end = this.myEditor.logicalPositionToOffset(nextLineStart);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        this.myEditor.getSelectionModel().setSelection(start, end);
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        boolean needOverrideSetting;
        this.validateContext(true);
        this.removeSelection();
        EditorSettings settings = this.myEditor.getSettings();
        boolean camelTemp = settings.isCamelWords();
        boolean bl = needOverrideSetting = camelTemp && !honorCamelWordsSettings;
        if (needOverrideSetting) {
            settings.setCamelWords(false);
        }
        EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler.execute((Editor)this.myEditor, this.myEditor.getDataContext());
        if (needOverrideSetting) {
            settings.setCamelWords(camelTemp);
        }
    }

    int getWordAtCaretStart() {
        int newOffset;
        Document document = this.myEditor.getDocument();
        int offset = this.myEditor.getCaretModel().getOffset();
        if (offset == 0) {
            return 0;
        }
        int lineNumber = this.myEditor.getCaretModel().getLogicalPosition().line;
        CharSequence text = document.getCharsSequence();
        int minOffset = lineNumber > 0 ? document.getLineEndOffset(lineNumber - 1) : 0;
        boolean camel = this.myEditor.getSettings().isCamelWords();
        for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordStart(text, newOffset, camel); --newOffset) {
        }
        return newOffset;
    }

    int getWordAtCaretEnd() {
        Document document = this.myEditor.getDocument();
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence text = document.getCharsSequence();
        if (offset >= document.getTextLength() - 1 || document.getLineCount() == 0) {
            return offset;
        }
        int newOffset = offset + 1;
        int lineNumber = this.myEditor.getCaretModel().getLogicalPosition().line;
        int maxOffset = document.getLineEndOffset(lineNumber);
        if (newOffset > maxOffset) {
            if (lineNumber + 1 >= document.getLineCount()) {
                return offset;
            }
            maxOffset = document.getLineEndOffset(lineNumber + 1);
        }
        boolean camel = this.myEditor.getSettings().isCamelWords();
        while (newOffset < maxOffset && !EditorActionUtil.isWordEnd(text, newOffset, camel)) {
            ++newOffset;
        }
        return newOffset;
    }

    public void copySelectionToClipboard() {
        this.validateContext(true);
        String s = this.myEditor.getSelectionModel().getSelectedText();
        if (s == null) {
            return;
        }
        s = StringUtil.convertLineSeparators((String)s);
        StringSelection contents = new StringSelection(s);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myEditor.getContentComponent()));
        if (project == null) {
            Clipboard clipboard = this.myEditor.getComponent().getToolkit().getSystemClipboard();
            clipboard.setContents(contents, (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        } else {
            CopyPasteManager.getInstance().setContents((Transferable)contents);
        }
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            TextAttributes textAttributes = new TextAttributes();
            EditorColorsScheme scheme = this.myEditor.getColorsScheme();
            textAttributes.setForegroundColor(scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            textAttributes.setBackgroundColor(scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            this.myTextAttributes = textAttributes;
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    private class MyRangeMarker
    extends RangeMarkerImpl {
        private boolean myIsReleased;

        private MyRangeMarker(DocumentEx document, int start, int end) {
            super(document, start, end);
            this.myIsReleased = false;
        }

        public void release() {
            this.myIsReleased = true;
        }

        @Override
        protected void changedUpdateImpl(DocumentEvent e) {
            if (this.myIsReleased) {
                return;
            }
            int startBefore = this.getStartOffset();
            int endBefore = this.getEndOffset();
            super.changedUpdateImpl(e);
            if (!this.isValid()) {
                SelectionModelImpl.this.myLastSelectionStart = SelectionModelImpl.this.myEditor.getCaretModel().getOffset();
                this.release();
                SelectionModelImpl.this.mySelectionMarker = null;
                SelectionModelImpl.this.fireSelectionChanged(startBefore, endBefore, SelectionModelImpl.this.myLastSelectionStart, SelectionModelImpl.this.myLastSelectionStart);
                return;
            }
            if (startBefore != this.getStartOffset() || endBefore != this.getStartOffset()) {
                SelectionModelImpl.this.fireSelectionChanged(startBefore, endBefore, this.getStartOffset(), this.getEndOffset());
            }
        }

        @Override
        protected void registerInDocument() {
        }
    }
}

