/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeEP;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.UnknownModuleType;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ModuleTypeManagerImpl
extends ModuleTypeManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleTypeManagerImpl");
    private final LinkedHashMap<ModuleType, Boolean> myModuleTypes = new LinkedHashMap();

    public ModuleTypeManagerImpl() {
        this.registerModuleType(this.getDefaultModuleType(), true);
    }

    public void registerModuleType(ModuleType type) {
        this.registerModuleType(type, false);
    }

    public void registerModuleType(ModuleType type, boolean classpathProvider) {
        for (ModuleType oldType : this.myModuleTypes.keySet()) {
            if (!oldType.getId().equals(type.getId())) continue;
            LOG.error("Trying to register a module type that claunches with existing one. Old=" + oldType + ", new = " + type);
            return;
        }
        this.myModuleTypes.put(type, classpathProvider);
    }

    public ModuleType[] getRegisteredTypes() {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>();
        result.addAll(this.myModuleTypes.keySet());
        for (ModuleTypeEP moduleTypeEP : (ModuleTypeEP[])Extensions.getExtensions((ExtensionPointName)ModuleTypeEP.EP_NAME)) {
            result.add(moduleTypeEP.getModuleType());
        }
        return result.toArray(new ModuleType[result.size()]);
    }

    public ModuleType findByID(String moduleTypeID) {
        if (moduleTypeID == null) {
            return this.getDefaultModuleType();
        }
        for (ModuleType type : this.myModuleTypes.keySet()) {
            if (!type.getId().equals(moduleTypeID)) continue;
            return type;
        }
        for (ModuleTypeEP ep : (ModuleTypeEP[])Extensions.getExtensions((ExtensionPointName)ModuleTypeEP.EP_NAME)) {
            if (!ep.id.equals(moduleTypeID)) continue;
            return ep.getModuleType();
        }
        return new UnknownModuleType(moduleTypeID, this.getDefaultModuleType());
    }

    public boolean isClasspathProvider(ModuleType moduleType) {
        for (ModuleTypeEP ep : (ModuleTypeEP[])Extensions.getExtensions((ExtensionPointName)ModuleTypeEP.EP_NAME)) {
            if (!ep.id.equals(moduleType.getId())) continue;
            return ep.classpathProvider;
        }
        Boolean provider = this.myModuleTypes.get(moduleType);
        return provider != null && provider != false;
    }

    public ModuleType getDefaultModuleType() {
        return EmptyModuleType.getInstance();
    }
}

