/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexImplUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectFileIndexImpl
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;
    private final FileTypeManager myFileTypeManager;
    private final DirectoryIndex myDirectoryIndex;
    private final ContentFilter myContentFilter;

    public ProjectFileIndexImpl(Project project, DirectoryIndex directoryIndex, FileTypeManager fileTypeManager) {
        this.myProject = project;
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeManager = fileTypeManager;
        this.myContentFilter = new ContentFilter();
    }

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        Module[] modules;
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.iterateContent must not be null");
        }
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            VirtualFile[] contentRoots;
            for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                boolean finished;
                DirectoryInfo parentInfo;
                VirtualFile parent;
                DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(contentRoot);
                if (info == null || !module.equals(info.module) || (parent = contentRoot.getParent()) != null && (parentInfo = this.myDirectoryIndex.getInfoForDirectory(parent)) != null && parentInfo.module != null || (finished = FileIndexImplUtil.iterateRecursively((VirtualFile)contentRoot, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.iterateContentUnderDirectory must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.iterateContentUnderDirectory must not be null");
        }
        return FileIndexImplUtil.iterateRecursively((VirtualFile)dir, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
    }

    public boolean isIgnored(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isIgnored must not be null");
        }
        if (this.myFileTypeManager.isFileIgnored(file.getName())) {
            return true;
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return false;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
        if (info != null) {
            return false;
        }
        if (this.myDirectoryIndex.isProjectExcludeRoot(dir)) {
            return true;
        }
        VirtualFile parent = dir.getParent();
        while (parent != null) {
            DirectoryInfo parentInfo = this.myDirectoryIndex.getInfoForDirectory(parent);
            if (parentInfo != null) {
                return true;
            }
            if (this.myDirectoryIndex.isProjectExcludeRoot(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public Module getModuleForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getModuleForFile must not be null");
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return null;
        }
        DirectoryIndex directoryIndex = this.myDirectoryIndex;
        DirectoryInfo info = directoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            return null;
        }
        return info.module;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file) {
        List<Object> list;
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getOrderEntriesForFile must not be null");
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getOrderEntriesForFile must not return null");
            return list;
        }
        DirectoryIndex directoryIndex = this.myDirectoryIndex;
        DirectoryInfo info = directoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getOrderEntriesForFile must not return null");
            return list;
        }
        list = Collections.unmodifiableList(info.getOrderEntries());
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getOrderEntriesForFile must not return null");
    }

    public VirtualFile getClassRootForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getClassRootForFile must not be null");
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return null;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            return null;
        }
        return info.libraryClassRoot;
    }

    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getSourceRootForFile must not be null");
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return null;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            return null;
        }
        return info.sourceRoot;
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getContentRootForFile must not be null");
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (dir == null) {
            return null;
        }
        DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
        if (info == null) {
            return null;
        }
        return info.contentRoot;
    }

    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.getPackageNameByDirectory must not be null");
        }
        LOG.assertTrue(dir.isDirectory());
        return this.myDirectoryIndex.getPackageName(dir);
    }

    public boolean isContentJavaSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isContentJavaSourceFile must not be null");
        }
        if (file.isDirectory()) {
            return false;
        }
        if (this.myFileTypeManager.getFileTypeByFile(file) != StdFileTypes.JAVA) {
            return false;
        }
        if (this.myFileTypeManager.isFileIgnored(file.getName())) {
            return false;
        }
        return this.isInSourceContent(file);
    }

    public boolean isLibraryClassFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isLibraryClassFile must not be null");
        }
        if (file.isDirectory()) {
            return false;
        }
        if (this.myFileTypeManager.getFileTypeByFile(file) != StdFileTypes.CLASS) {
            return false;
        }
        if (this.myFileTypeManager.isFileIgnored(file.getName())) {
            return false;
        }
        VirtualFile parent = file.getParent();
        DirectoryInfo parentInfo = this.myDirectoryIndex.getInfoForDirectory(parent);
        return parentInfo != null && parentInfo.libraryClassRoot != null;
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isInSource must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            if (info == null) {
                return false;
            }
            return info.isInModuleSource || info.isInLibrarySource;
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInSource(parent);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isInLibraryClasses must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.libraryClassRoot != null;
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInLibraryClasses(parent);
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isInLibrarySource must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.isInLibrarySource;
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInLibrarySource(parent);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isInContent must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.module != null;
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInContent(parent);
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isInSourceContent must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.isInModuleSource;
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInSourceContent(parent);
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl.isInTestSourceContent must not be null");
        }
        if (fileOrDir.isDirectory()) {
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(fileOrDir);
            return info != null && info.isInModuleSource && info.isTestSource;
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent != null && this.isInTestSourceContent(parent);
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ProjectFileIndexImpl$ContentFilter.accept must not be null");
            }
            if (file.isDirectory()) {
                DirectoryInfo info = ProjectFileIndexImpl.this.myDirectoryIndex.getInfoForDirectory(file);
                return info != null && info.module != null;
            }
            return !ProjectFileIndexImpl.this.myFileTypeManager.isFileIgnored(file.getName());
        }
    }
}

