/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.EditChangelistPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooserPanel
extends JPanel {
    private JPanel myPanel;
    private JRadioButton myRbExisting;
    private JRadioButton myRbNew;
    private JComboBox myExisitingsCombo;
    private EditChangelistPanel myNewListPanel;
    @Nullable
    private final ChangeListEditHandler myHandler;
    private final Consumer<String> myOkEnabledListener;
    private Project myProject;

    public ChangeListChooserPanel(@Nullable ChangeListEditHandler handler, @NotNull Consumer<String> okEnabledListener) {
        if (okEnabledListener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel.<init> must not be null");
        }
        super(new BorderLayout());
        this.myHandler = handler;
        this.myOkEnabledListener = okEnabledListener;
        this.$$$setupUI$$$();
        this.add((Component)this.myPanel, "Center");
        this.myRbExisting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ChangeListChooserPanel.this.updateEnabledItems();
            }
        });
    }

    public void init(final Project project) {
        this.myProject = project;
        this.myExisitingsCombo.setRenderer(new ColoredListCellRenderer(){
            private final IssueLinkRenderer myLinkRenderer;
            {
                this.myLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
            }

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof LocalChangeList) {
                    this.myLinkRenderer.appendTextWithLinks(((LocalChangeList)value).getName(), ((LocalChangeList)value).isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.myNewListPanel.init(project, null);
    }

    public void setChangeLists(Collection<? extends ChangeList> changeLists) {
        DefaultComboBoxModel<ChangeList> model = new DefaultComboBoxModel<ChangeList>();
        for (ChangeList changeList : changeLists) {
            model.addElement(changeList);
        }
        this.myExisitingsCombo.setModel(model);
    }

    public void setDefaultName(String name) {
        this.myNewListPanel.setName(name);
    }

    private void updateEnabledItems() {
        if (this.myRbExisting.isSelected()) {
            this.myExisitingsCombo.setEnabled(true);
            this.myNewListPanel.setEnabled(false);
            this.myExisitingsCombo.requestFocus();
        } else {
            this.myExisitingsCombo.setEnabled(false);
            this.myNewListPanel.setEnabled(true);
            this.myNewListPanel.requestFocus();
        }
        if (this.myProject != null) {
            this.myNewListPanel.nameChangedImpl(this.myProject, null);
        }
    }

    @Nullable
    public LocalChangeList getSelectedList(Project project) {
        String newText;
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        if (this.myRbNew.isSelected() && manager.findChangeList(newText = this.myNewListPanel.getName()) != null) {
            Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"changes.newchangelist.warning.already.exists.text", (Object[])new Object[]{newText}), (String)VcsBundle.message((String)"changes.newchangelist.warning.already.exists.title", (Object[])new Object[0]));
            return null;
        }
        if (this.myRbExisting.isSelected()) {
            return (LocalChangeList)this.myExisitingsCombo.getSelectedItem();
        }
        LocalChangeList changeList = manager.addChangeList(this.myNewListPanel.getName(), this.myNewListPanel.getDescription());
        this.myNewListPanel.changelistCreatedOrChanged(changeList);
        if (this.myNewListPanel.getMakeActiveCheckBox().isSelected()) {
            manager.setDefaultChangeList(changeList);
        }
        VcsConfiguration.getInstance((Project)project).MAKE_NEW_CHANGELIST_ACTIVE = this.myNewListPanel.getMakeActiveCheckBox().isSelected();
        return changeList;
    }

    public void setDefaultSelection(ChangeList defaultSelection) {
        if (defaultSelection == null) {
            this.myExisitingsCombo.setSelectedIndex(0);
        } else {
            this.myExisitingsCombo.setSelectedItem(defaultSelection);
        }
        if (defaultSelection != null) {
            this.myRbExisting.setSelected(true);
        } else {
            this.myRbNew.setSelected(true);
        }
        this.updateEnabledItems();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRbExisting.isSelected() ? this.myExisitingsCombo : this.myNewListPanel.getPrefferedFocusedComponent();
    }

    private void createUIComponents() {
        this.myNewListPanel = new EditChangelistPanel(this.myHandler){

            @Override
            protected void nameChanged(String errorMessage) {
                if (ChangeListChooserPanel.this.myRbExisting.isSelected()) {
                    ChangeListChooserPanel.this.myOkEnabledListener.consume(null);
                } else {
                    ChangeListChooserPanel.this.myOkEnabledListener.consume((Object)errorMessage);
                }
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRbExisting = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/VcsBundle").getString("changes.changelist.chooser.existing.changelist"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbNew = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/VcsBundle").getString("changes.changelist.chooser.new.changelist"));
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExisitingsCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null, 3));
        EditChangelistPanel editChangelistPanel = this.myNewListPanel;
        JComponent jComponent = editChangelistPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

