/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public class ChangesViewBalloonProblemNotifier
implements Runnable {
    private final Project myProject;
    private final String myMessage;
    private final MessageType myMessageType;

    public ChangesViewBalloonProblemNotifier(Project project, String message, MessageType messageType) {
        this.myProject = project;
        this.myMessage = message;
        this.myMessageType = messageType;
    }

    public static void showMe(final Project project, final String message, final MessageType type) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment()) {
            return;
        }
        Runnable showErrorAction = new Runnable(){

            @Override
            public void run() {
                new ChangesViewBalloonProblemNotifier(project, message, type).run();
            }
        };
        if (application.isDispatchThread()) {
            showErrorAction.run();
        } else {
            ApplicationManager.getApplication().invokeLater(showErrorAction);
        }
    }

    @Override
    public void run() {
        List<Project> projects;
        if (this.myProject != null) {
            projects = Collections.singletonList(this.myProject);
        } else {
            ProjectManager projectManager = ProjectManager.getInstance();
            projects = Arrays.asList(projectManager.getOpenProjects());
        }
        for (Project project : projects) {
            this.doForProject(project);
        }
    }

    private void doForProject(@NotNull Project project) {
        boolean haveWindow;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ui/ChangesViewBalloonProblemNotifier.doForProject must not be null");
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        boolean bl = haveWindow = !project.isDefault() && manager.getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID) != null;
        if (haveWindow) {
            manager.notifyByBalloon(ChangesViewContentManager.TOOLWINDOW_ID, this.myMessageType, this.myMessage, null, null);
        } else {
            JFrame frame = WindowManager.getInstance().getFrame(project.isDefault() ? null : project);
            if (frame == null) {
                return;
            }
            JRootPane component = frame.getRootPane();
            if (component == null) {
                return;
            }
            Rectangle rect = component.getVisibleRect();
            Point p = new Point(rect.x + 30, rect.y + rect.height - 10);
            RelativePoint point = new RelativePoint((Component)component, p);
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.myMessage, this.myMessageType.getDefaultIcon(), this.myMessageType.getPopupBackground(), null).createBalloon().show(point, Balloon.Position.above);
        }
    }
}

