/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.annotate.Annotater;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ContentsUtil;
import com.intellij.util.ui.ConfirmationDialog;
import com.intellij.util.ui.ErrorTreeView;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractVcsHelperImpl
extends AbstractVcsHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl");
    private final Project myProject;

    public AbstractVcsHelperImpl(Project project) {
        this.myProject = project;
    }

    public void openMessagesView(final VcsErrorViewPanel errorTreeView, final String tabDisplayName) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                final MessageView messageView = MessageView.SERVICE.getInstance(AbstractVcsHelperImpl.this.myProject);
                messageView.runWhenInitialized(new Runnable(){

                    @Override
                    public void run() {
                        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
                        messageView.getContentManager().addContent(content);
                        Disposer.register((Disposable)content, (Disposable)errorTreeView);
                        messageView.getContentManager().setSelectedContent(content);
                        AbstractVcsHelperImpl.this.removeContents(content, tabDisplayName);
                        ToolWindowManager.getInstance((Project)AbstractVcsHelperImpl.this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
                    }
                });
            }
        }, VcsBundle.message((String)"command.name.open.error.message.view", (Object[])new Object[0]), null);
    }

    public void showFileHistory(VcsHistoryProvider vcsHistoryProvider, FilePath path, AbstractVcs vcs, String repositoryPath) {
        this.showFileHistory(vcsHistoryProvider, null, path, repositoryPath, vcs);
    }

    public void showFileHistory(VcsHistoryProvider vcsHistoryProvider, AnnotationProvider annotationProvider, FilePath path, String repositoryPath, AbstractVcs vcs) {
        MyRefresher refresher = new MyRefresher(vcsHistoryProvider, annotationProvider, path, repositoryPath, vcs);
        refresher.run();
    }

    public void showRollbackChangesDialog(List<Change> changes) {
        RollbackChangesDialog.rollbackChanges(this.myProject, changes);
    }

    @Nullable
    public Collection<VirtualFile> selectFilesToProcess(List<VirtualFile> files, String title, @Nullable String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption) {
        if (files.size() == 1 && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon())) {
                return files;
            }
            return null;
        }
        SelectFilesDialog dlg = new SelectFilesDialog(this.myProject, files, prompt, confirmationOption);
        dlg.setTitle(title);
        dlg.show();
        if (dlg.isOK()) {
            Collection<VirtualFile> selection = dlg.getSelectedFiles();
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            for (VirtualFile file : files) {
                if (!selection.contains(file)) continue;
                result.add(file);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(List<FilePath> files, String title, @Nullable String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption) {
        if (files.size() == 1 && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon())) {
                return files;
            }
            return null;
        }
        SelectFilePathsDialog dlg = new SelectFilePathsDialog(this.myProject, files, prompt, confirmationOption);
        dlg.setTitle(title);
        dlg.show();
        return dlg.isOK() ? dlg.getSelectedFiles() : null;
    }

    protected void reportError(Exception exception) {
        LOG.info((Throwable)exception);
        Messages.showMessageDialog((String)exception.getLocalizedMessage(), (String)VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    public void showErrors(final List<VcsException> abstractVcsExceptions, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showErrors must not be null");
        }
        this.showErrorsImpl(abstractVcsExceptions.isEmpty(), new Getter<VcsException>(){

            public VcsException get() {
                return (VcsException)((Object)abstractVcsExceptions.get(0));
            }
        }, tabDisplayName, new Consumer<VcsErrorViewPanel>(){

            public void consume(VcsErrorViewPanel vcsErrorViewPanel) {
                AbstractVcsHelperImpl.this.addDirectMessages(vcsErrorViewPanel, abstractVcsExceptions);
            }
        });
    }

    private void addDirectMessages(VcsErrorViewPanel vcsErrorViewPanel, List<VcsException> abstractVcsExceptions) {
        for (VcsException exception : abstractVcsExceptions) {
            String[] messages = this.getExceptionMessages(exception);
            vcsErrorViewPanel.addMessage(AbstractVcsHelperImpl.getErrorCategory(exception), messages, exception.getVirtualFile(), -1, -1, null);
        }
    }

    private String[] getExceptionMessages(VcsException exception) {
        String[] messages = exception.getMessages();
        if (messages.length == 0) {
            messages = new String[]{VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0])};
        }
        return messages;
    }

    private void showErrorsImpl(final boolean isEmpty, Getter<VcsException> firstGetter, final @NotNull String tabDisplayName, final Consumer<VcsErrorViewPanel> viewFiller) {
        if (tabDisplayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showErrorsImpl must not be null");
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !isEmpty) {
            throw new RuntimeException((Throwable)firstGetter.get());
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractVcsHelperImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (isEmpty) {
                    AbstractVcsHelperImpl.this.removeContents(null, tabDisplayName);
                    return;
                }
                VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(AbstractVcsHelperImpl.this.myProject);
                AbstractVcsHelperImpl.this.openMessagesView(errorTreeView, tabDisplayName);
                viewFiller.consume((Object)errorTreeView);
            }
        });
    }

    public void showErrors(final Map<HotfixData, List<VcsException>> exceptionGroups, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showErrors must not be null");
        }
        this.showErrorsImpl(exceptionGroups.isEmpty(), new Getter<VcsException>(){

            public VcsException get() {
                List exceptionList = (List)exceptionGroups.values().iterator().next();
                return exceptionList == null ? null : (exceptionList.isEmpty() ? null : (VcsException)((Object)exceptionList.get(0)));
            }
        }, tabDisplayName, new Consumer<VcsErrorViewPanel>(){

            public void consume(VcsErrorViewPanel vcsErrorViewPanel) {
                for (Map.Entry entry : exceptionGroups.entrySet()) {
                    if (entry.getKey() == null) {
                        AbstractVcsHelperImpl.this.addDirectMessages(vcsErrorViewPanel, (List)entry.getValue());
                        continue;
                    }
                    List exceptionList = (List)entry.getValue();
                    ArrayList<SimpleErrorData> list = new ArrayList<SimpleErrorData>(exceptionList.size());
                    for (VcsException exception : exceptionList) {
                        String[] messages = AbstractVcsHelperImpl.this.getExceptionMessages(exception);
                        list.add(new SimpleErrorData(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)AbstractVcsHelperImpl.getErrorCategory(exception)), messages, exception.getVirtualFile()));
                    }
                    vcsErrorViewPanel.addHotfixGroup((HotfixData)entry.getKey(), list);
                }
            }
        });
    }

    private static int getErrorCategory(VcsException exception) {
        if (exception.isWarning()) {
            return 5;
        }
        return 4;
    }

    protected void removeContents(Content notToRemove, String tabDisplayName) {
        Content[] contents;
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            LOG.assertTrue(content != null);
            if (content.isPinned() || !tabDisplayName.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
            content.release();
        }
    }

    public List<VcsException> runTransactionRunnable(AbstractVcs vcs, TransactionRunnable runnable, Object vcsParameters) {
        boolean transactionSupported;
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TransactionProvider transactionProvider = vcs.getTransactionProvider();
        boolean bl = transactionSupported = transactionProvider != null;
        if (transactionSupported) {
            try {
                transactionProvider.startTransaction(vcsParameters);
            }
            catch (VcsException e) {
                return Collections.singletonList(e);
            }
        }
        runnable.run(exceptions);
        if (transactionSupported) {
            if (exceptions.isEmpty()) {
                try {
                    transactionProvider.commitTransaction(vcsParameters);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    transactionProvider.rollbackTransaction(vcsParameters);
                }
            } else {
                transactionProvider.rollbackTransaction(vcsParameters);
            }
        }
        return exceptions;
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file) {
        new Annotater(annotation, this.myProject, file).showAnnotation();
    }

    public void showDifferences(VcsFileRevision version1, VcsFileRevision version2, File file) {
        try {
            version1.loadContent();
            version2.loadContent();
            if (Comparing.equal((Object)version1.getContent(), (Object)version2.getContent())) {
                Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.versions.are.identical", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
            }
            SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, file.getAbsolutePath());
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName());
            if (fileType.isBinary()) {
                Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.differ", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                return;
            }
            DiffContent content1 = AbstractVcsHelperImpl.getContentForVersion(version1, file);
            DiffContent content2 = AbstractVcsHelperImpl.getContentForVersion(version2, file);
            if (version2.getRevisionNumber().compareTo((Object)version1.getRevisionNumber()) > 0) {
                request.setContents(content2, content1);
                request.setContentTitles(version2.getRevisionNumber().asString(), version1.getRevisionNumber().asString());
            } else {
                request.setContents(content1, content2);
                request.setContentTitles(version1.getRevisionNumber().asString(), version2.getRevisionNumber().asString());
            }
            DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
        }
        catch (VcsException e) {
            this.showError(e, VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
        }
        catch (IOException e) {
            this.showError(new VcsException((Throwable)e), VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
        }
    }

    public void showChangesBrowser(List<CommittedChangeList> changelists) {
        this.showChangesBrowser(changelists, null);
    }

    public void showChangesBrowser(List<CommittedChangeList> changelists, @Nls String title) {
        this.showChangesBrowser(new CommittedChangesTableModel(changelists, false), title, false, null);
    }

    private ChangesBrowserDialog createChangesBrowserDialog(CommittedChangesTableModel changelists, String title, boolean showSearchAgain, @Nullable Component parent) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = showSearchAgain ? ChangesBrowserDialog.Mode.Browse : ChangesBrowserDialog.Mode.Simple;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode) : new ChangesBrowserDialog(this.myProject, changelists, mode);
        if (title != null) {
            dlg.setTitle(title);
        }
        return dlg;
    }

    private void showChangesBrowser(CommittedChangesTableModel changelists, String title, boolean showSearchAgain, @Nullable Component parent) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = showSearchAgain ? ChangesBrowserDialog.Mode.Browse : ChangesBrowserDialog.Mode.Simple;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode) : new ChangesBrowserDialog(this.myProject, changelists, mode);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesListBrowser(CommittedChangeList changelist, @Nls String title) {
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.myProject, changelist);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showWhatDiffersBrowser(Component parent, Collection<Change> changes, @Nls String title) {
        ChangeListViewerDialog dlg = parent != null ? new ChangeListViewerDialog(parent, this.myProject, changes, false) : new ChangeListViewerDialog(this.myProject, changes, false);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesBrowser(CommittedChangesProvider provider, RepositoryLocation location, @Nls String title, Component parent) {
        boolean ok;
        ChangesBrowserSettingsEditor filterUI = provider.createFilterUI(true);
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        if (filterUI != null) {
            CommittedChangesFilterDialog dlg = new CommittedChangesFilterDialog(this.myProject, filterUI, settings);
            dlg.show();
            ok = dlg.getExitCode() == 0;
            settings = dlg.getSettings();
        } else {
            ok = true;
        }
        if (ok) {
            if (this.myProject.isDefault() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length == 0 || !ModalityState.NON_MODAL.equals(ModalityState.current())) {
                ArrayList<CommittedChangeList> versions = new ArrayList<CommittedChangeList>();
                if (parent == null || !parent.isValid()) {
                    parent = WindowManager.getInstance().suggestParentWindow(this.myProject);
                }
                CommittedChangesTableModel model = new CommittedChangesTableModel(versions, true);
                ChangesBrowserDialog dlg = this.createChangesBrowserDialog(model, title, filterUI != null, parent);
                AsynchronousListsLoader task = new AsynchronousListsLoader(this.myProject, provider, location, settings, dlg);
                ProgressManager.getInstance().run((Task)task);
                dlg.show();
                dlg.startLoading();
                task.cancel();
                List<VcsException> exceptions = task.getExceptions();
                if (!exceptions.isEmpty()) {
                    Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.error.message", (Object[])new Object[]{exceptions.get(0).getMessage()}), (String)VcsBundle.message((String)"browse.changes.error.title", (Object[])new Object[0]));
                    return;
                }
                if (!task.isRevisionsReturned()) {
                    Messages.showInfoMessage((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.nothing.found", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.nothing.found.title", (Object[])new Object[0]));
                }
            } else {
                this.openCommittedChangesTab(provider, location, settings, 0, title);
            }
        }
    }

    @Nullable
    public <T extends CommittedChangeList, U extends ChangeBrowserSettings> T chooseCommittedChangeList(CommittedChangesProvider<T, U> provider, RepositoryLocation location) {
        List changes;
        try {
            changes = provider.getCommittedChanges(provider.createDefaultSettings(), location, 0);
        }
        catch (VcsException e) {
            return null;
        }
        ChangesBrowserDialog dlg = new ChangesBrowserDialog(this.myProject, new CommittedChangesTableModel(changes, provider.getColumns(), false), ChangesBrowserDialog.Mode.Choose);
        dlg.show();
        if (dlg.isOK()) {
            return (T)dlg.getSelectedChangeList();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<VirtualFile> showMergeDialog(List<VirtualFile> files, MergeProvider provider) {
        List<VirtualFile> list;
        if (files.isEmpty()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showMergeDialog must not return null");
            return list;
        }
        MultipleFileMergeDialog fileMergeDialog = new MultipleFileMergeDialog(this.myProject, files, provider);
        fileMergeDialog.show();
        list = fileMergeDialog.getProcessedFiles();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showMergeDialog must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<VirtualFile> showMergeDialog(List<VirtualFile> files) {
        List<Object> list;
        if (files.isEmpty()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showMergeDialog must not return null");
            return list;
        }
        MergeProvider provider = null;
        for (VirtualFile virtualFile : files) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile);
            if (vcs == null || (provider = vcs.getMergeProvider()) == null) continue;
        }
        if (provider == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showMergeDialog must not return null");
            return list;
        }
        list = this.showMergeDialog(files, provider);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl.showMergeDialog must not return null");
    }

    private static DiffContent getContentForVersion(VcsFileRevision version, File file) throws IOException {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile != null && version instanceof CurrentRevision && !vFile.getFileType().isBinary()) {
            return new DocumentContent(FileDocumentManager.getInstance().getDocument(vFile), vFile.getFileType());
        }
        return new SimpleContent(new String(version.getContent()), FileTypeManager.getInstance().getFileTypeByFileName(file.getName()));
    }

    public void openCommittedChangesTab(AbstractVcs vcs, VirtualFile root, ChangeBrowserSettings settings, int maxCount, String title) {
        RepositoryLocation location = CommittedChangesCache.getInstance(this.myProject).getLocationCache().getLocation(vcs, new FilePathImpl(root), false);
        this.openCommittedChangesTab(vcs.getCommittedChangesProvider(), location, settings, maxCount, title);
    }

    public void openCommittedChangesTab(CommittedChangesProvider provider, RepositoryLocation location, ChangeBrowserSettings settings, int maxCount, String title) {
        DefaultActionGroup extraActions = new DefaultActionGroup();
        CommittedChangesPanel panel = new CommittedChangesPanel(this.myProject, provider, settings, location, (ActionGroup)extraActions);
        panel.setMaxCount(maxCount);
        panel.refreshChanges(false);
        ContentFactory factory = ContentFactory.SERVICE.getInstance();
        if (title == null && location != null) {
            title = VcsBundle.message((String)"browse.changes.content.title", (Object[])new Object[]{location.toPresentableString()});
        }
        final Content content = factory.createContent((JComponent)panel, title, false);
        final ChangesViewContentManager contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        extraActions.add((AnAction)new CloseTabToolbarAction(){

            public void actionPerformed(AnActionEvent e) {
                contentManager.removeContent(content);
            }
        });
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        if (!window.isVisible()) {
            window.activate(null);
        }
    }

    private static class AsynchronousListsLoader
    extends Task.Backgroundable {
        private final CommittedChangesProvider myProvider;
        private final RepositoryLocation myLocation;
        private final ChangeBrowserSettings mySettings;
        private final ChangesBrowserDialog myDlg;
        private final List<VcsException> myExceptions;
        private volatile boolean myCanceled;
        private boolean myRevisionsReturned;

        private AsynchronousListsLoader(@Nullable Project project, CommittedChangesProvider provider, RepositoryLocation location, ChangeBrowserSettings settings, ChangesBrowserDialog dlg) {
            super(project, VcsBundle.message((String)"browse.changes.progress.title", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance());
            this.myProvider = provider;
            this.myLocation = location;
            this.mySettings = settings;
            this.myDlg = dlg;
            this.myExceptions = new LinkedList<VcsException>();
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$AsynchronousListsLoader.run must not be null");
            }
            final AsynchConsumer<List<CommittedChangeList>> appender = this.myDlg.getAppender();
            final BufferedListConsumer bufferedListConsumer = new BufferedListConsumer(10, appender, -1);
            final Application application = ApplicationManager.getApplication();
            try {
                this.myProvider.loadCommittedChanges(this.mySettings, this.myLocation, 0, (AsynchConsumer)new AsynchConsumer<CommittedChangeList>(){

                    public void consume(CommittedChangeList committedChangeList) {
                        AsynchronousListsLoader.this.myRevisionsReturned = true;
                        bufferedListConsumer.consumeOne((Object)committedChangeList);
                        if (AsynchronousListsLoader.this.myCanceled) {
                            indicator.cancel();
                        }
                    }

                    public void finished() {
                        bufferedListConsumer.flush();
                        appender.finished();
                        if (!AsynchronousListsLoader.this.myRevisionsReturned) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AsynchronousListsLoader.this.myDlg.close(-1);
                                }
                            }, ModalityState.stateForComponent((Component)AsynchronousListsLoader.this.myDlg.getWindow()));
                        }
                    }
                });
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
                application.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AsynchronousListsLoader.this.myDlg.close(-1);
                    }
                }, ModalityState.stateForComponent((Component)this.myDlg.getWindow()));
            }
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public boolean isRevisionsReturned() {
            return this.myRevisionsReturned;
        }
    }

    private static class MyRefresher
    implements Runnable {
        private final MyVcsAppendableHistorySessionPartner mySessionPartner;
        private final VcsHistoryProvider myVcsHistoryProvider;
        private final FilePath myPath;
        private final AbstractVcs myVcs;

        private MyRefresher(VcsHistoryProvider vcsHistoryProvider, AnnotationProvider annotationProvider, FilePath path, String repositoryPath, AbstractVcs vcs) {
            this.myVcsHistoryProvider = vcsHistoryProvider;
            this.myPath = path;
            this.myVcs = vcs;
            this.mySessionPartner = new MyVcsAppendableHistorySessionPartner(vcsHistoryProvider, annotationProvider, path, repositoryPath, vcs, this);
        }

        @Override
        public void run() {
            VcsHistoryProviderBackgroundableProxy proxy = new VcsHistoryProviderBackgroundableProxy(this.myVcs.getProject(), this.myVcsHistoryProvider);
            proxy.executeAppendableSession(this.myPath, this.mySessionPartner, null, false);
        }
    }

    private static class MyVcsAppendableHistorySessionPartner
    implements VcsAppendableHistorySessionPartner {
        private FileHistoryPanelImpl myFileHistoryPanel;
        private final VcsHistoryProvider myVcsHistoryProvider;
        private final AnnotationProvider myAnnotationProvider;
        private final FilePath myPath;
        private final String myRepositoryPath;
        private final AbstractVcs myVcs;
        private final Runnable myRefresher;
        private volatile VcsAbstractHistorySession mySession;
        private final BufferedListConsumer<VcsFileRevision> myBuffer;

        private MyVcsAppendableHistorySessionPartner(VcsHistoryProvider vcsHistoryProvider, AnnotationProvider annotationProvider, FilePath path, String repositoryPath, AbstractVcs vcs, Runnable refresher) {
            this.myVcsHistoryProvider = vcsHistoryProvider;
            this.myAnnotationProvider = annotationProvider;
            this.myPath = path;
            this.myRepositoryPath = repositoryPath;
            this.myVcs = vcs;
            this.myRefresher = refresher;
            this.myBuffer = new BufferedListConsumer(5, (Consumer)new Consumer<List<VcsFileRevision>>(){

                public void consume(List<VcsFileRevision> vcsFileRevisions) {
                    MyVcsAppendableHistorySessionPartner.this.mySession.getRevisionList().addAll(vcsFileRevisions);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MyVcsAppendableHistorySessionPartner.this.myFileHistoryPanel.getHistoryPanelRefresh().consume((Object)MyVcsAppendableHistorySessionPartner.this.mySession);
                        }
                    });
                }
            }, 1000);
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myBuffer.consumeOne((Object)revision);
        }

        public void reportCreatedEmptySession(final VcsAbstractHistorySession session) {
            this.mySession = session;
            if (this.myFileHistoryPanel != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyVcsAppendableHistorySessionPartner.this.myFileHistoryPanel.getHistoryPanelRefresh().consume((Object)MyVcsAppendableHistorySessionPartner.this.mySession);
                    }
                });
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String actionName = VcsBundle.message((String)"action.name.file.history", (Object[])new Object[]{MyVcsAppendableHistorySessionPartner.this.myPath.getName()});
                    ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(MyVcsAppendableHistorySessionPartner.this.myVcs.getProject()).getContentManager();
                    MyVcsAppendableHistorySessionPartner.this.myFileHistoryPanel = new FileHistoryPanelImpl(MyVcsAppendableHistorySessionPartner.this.myVcs.getProject(), MyVcsAppendableHistorySessionPartner.this.myPath, MyVcsAppendableHistorySessionPartner.this.myRepositoryPath, (VcsHistorySession)session, MyVcsAppendableHistorySessionPartner.this.myVcsHistoryProvider, MyVcsAppendableHistorySessionPartner.this.myAnnotationProvider, contentManager, MyVcsAppendableHistorySessionPartner.this.myRefresher);
                    Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)MyVcsAppendableHistorySessionPartner.this.myFileHistoryPanel), actionName, true);
                    ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content, (boolean)true);
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)MyVcsAppendableHistorySessionPartner.this.myVcs.getProject()).getToolWindow(ToolWindowId.VCS);
                    toolWindow.activate(null);
                }
            });
        }

        public void reportException(VcsException exception) {
            ChangesViewBalloonProblemNotifier.showMe(this.myVcs.getProject(), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]) + ": " + exception.getMessage(), MessageType.ERROR);
        }

        public void finished() {
            this.myBuffer.flush();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MyVcsAppendableHistorySessionPartner.this.myFileHistoryPanel != null) {
                        MyVcsAppendableHistorySessionPartner.this.myFileHistoryPanel.getHistoryPanelRefresh().finished();
                    }
                }
            });
        }
    }
}

